/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.logging.adapter.formatters;

import java.net.InetAddress;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.hyades.logging.adapter.AdapterInvalidConfig;
import org.eclipse.hyades.logging.adapter.ICBEPropertyConstants;
import org.eclipse.hyades.logging.adapter.IDirectedGraph;
import org.eclipse.hyades.logging.adapter.IFormatter;
import org.eclipse.hyades.logging.adapter.impl.ProcessUnit;
import org.eclipse.hyades.logging.adapter.util.Messages;
import org.eclipse.hyades.logging.core.Guid;
import org.eclipse.hyades.logging.events.cbe.AssociatedEvent;
import org.eclipse.hyades.logging.events.cbe.AssociationEngine;
import org.eclipse.hyades.logging.events.cbe.AvailableSituation;
import org.eclipse.hyades.logging.events.cbe.CommonBaseEvent;
import org.eclipse.hyades.logging.events.cbe.ComponentIdentification;
import org.eclipse.hyades.logging.events.cbe.ConfigureSituation;
import org.eclipse.hyades.logging.events.cbe.ConnectSituation;
import org.eclipse.hyades.logging.events.cbe.ContextDataElement;
import org.eclipse.hyades.logging.events.cbe.CreateSituation;
import org.eclipse.hyades.logging.events.cbe.DependencySituation;
import org.eclipse.hyades.logging.events.cbe.DestroySituation;
import org.eclipse.hyades.logging.events.cbe.EventFactory;
import org.eclipse.hyades.logging.events.cbe.ExtendedDataElement;
import org.eclipse.hyades.logging.events.cbe.FeatureSituation;
import org.eclipse.hyades.logging.events.cbe.MsgDataElement;
import org.eclipse.hyades.logging.events.cbe.OtherSituation;
import org.eclipse.hyades.logging.events.cbe.ReportSituation;
import org.eclipse.hyades.logging.events.cbe.RequestSituation;
import org.eclipse.hyades.logging.events.cbe.Situation;
import org.eclipse.hyades.logging.events.cbe.SituationType;
import org.eclipse.hyades.logging.events.cbe.StartSituation;
import org.eclipse.hyades.logging.events.cbe.StopSituation;
import org.eclipse.hyades.logging.events.cbe.ValidationException;
import org.eclipse.hyades.logging.events.cbe.impl.SimpleEventFactoryHomeImpl;
import org.w3c.dom.Element;

public class CBEFormatter
extends ProcessUnit
implements IFormatter,
ICBEPropertyConstants {
    private static final String BUILTIN = "##BUILTIN";
    private static EventFactory eventFactory = new SimpleEventFactoryHomeImpl().getEventFactory("org.eclipse.hyades.logging.adapter.formatters.CBEFormatter");
    private String localHostId = null;
    private String localHostIdFormat = null;
    private static final String HOST_ID_FORMAT_IPV4 = "IPV4";
    private static final String HOST_ID_FORMAT_IPV6 = "IPV6";
    private static final String NONE = "None";
    private static final String UNKNOWN_HOST = "Unknown Host";
    private boolean testMode = false;

    public Object[] processEventItems(Object[] msgs) {
        if (msgs == null || msgs.length == 0) {
            return null;
        }
        return this.processDirectedGraphs(msgs);
    }

    private CommonBaseEvent[] processDirectedGraphs(Object[] msgs) {
        int cbesCreatedCount = 0;
        CommonBaseEvent[] cbes = new CommonBaseEvent[msgs.length];
        int k = 0;
        while (k < msgs.length) {
            Situation sit;
            CommonBaseEvent event;
            HashMap<String, Object> cache = new HashMap<String, Object>();
            Iterator ni = ((List)msgs[k]).iterator();
            CommonBaseEvent cbe = eventFactory.createCommonBaseEvent();
            cbe.setGlobalInstanceId(Guid.generate());
            while (ni.hasNext()) {
                CommonBaseEvent event2;
                IDirectedGraph graphEntry = (IDirectedGraph)ni.next();
                List path = graphEntry.getPath();
                try {
                    if (((String)path.get(0)).equals("CommonBaseEvent")) {
                        CommonBaseEvent event3;
                        CommonBaseEvent event4;
                        String key;
                        EList valueList;
                        String value;
                        if (((String)path.get(2)).equals("extensionName")) {
                            cbe.setExtensionName((String)graphEntry.getValue());
                            continue;
                        }
                        if (((String)path.get(2)).equals("localInstanceId")) {
                            value = (String)graphEntry.getValue();
                            if (value.equals(BUILTIN)) {
                                value = String.valueOf(this.getLocalHostId()) + System.currentTimeMillis() + Integer.toString(msgs[k].hashCode());
                            }
                            cbe.setLocalInstanceId(value);
                            continue;
                        }
                        if (((String)path.get(2)).equals("globalInstanceId")) {
                            value = (String)graphEntry.getValue();
                            if (value.equals(BUILTIN)) {
                                value = new Guid().toString();
                            }
                            cbe.setGlobalInstanceId(value);
                            continue;
                        }
                        if (((String)path.get(2)).equals("creationTime")) {
                            try {
                                String strValue = (String)graphEntry.getValue();
                                cbe.setCreationTime(strValue);
                                continue;
                            }
                            catch (ClassCastException classCastException) {
                                Long lValue = (Long)graphEntry.getValue();
                                cbe.setCreationTimeAsLong(lValue.longValue());
                                continue;
                            }
                            catch (Exception e) {
                                throw e;
                            }
                        }
                        if (((String)path.get(2)).equals("severity")) {
                            cbe.setSeverity(Short.parseShort((String)graphEntry.getValue()));
                            continue;
                        }
                        if (((String)path.get(2)).equals("priority")) {
                            cbe.setPriority(Short.parseShort((String)graphEntry.getValue()));
                            continue;
                        }
                        if (((String)path.get(2)).equals("msg")) {
                            String message = (String)graphEntry.getValue();
                            int msgLength = message.length();
                            if (msgLength <= 1024) {
                                cbe.setMsg(message);
                                continue;
                            }
                            cbe.setMsg(message.substring(0, 1024));
                            String edeName = "message";
                            ExtendedDataElement ede = (ExtendedDataElement)cache.get(edeName);
                            if (ede == null) {
                                ede = eventFactory.createExtendedDataElement();
                                cbe.addExtendedDataElement(ede);
                                cache.put(edeName, ede);
                            }
                            ede.setName(edeName);
                            valueList = ede.getValues();
                            ede.setTypeAsInt(16);
                            int counter = 0;
                            while (counter < msgLength) {
                                valueList.add(message.substring(counter, Math.min(counter + 1024, msgLength)));
                                counter += 1024;
                            }
                            continue;
                        }
                        if (((String)path.get(2)).equals("repeatCount")) {
                            cbe.setRepeatCount(Short.parseShort((String)graphEntry.getValue()));
                            continue;
                        }
                        if (((String)path.get(2)).equals("elapsedTime")) {
                            cbe.setElapsedTime(Long.parseLong((String)graphEntry.getValue()));
                            continue;
                        }
                        if (((String)path.get(2)).equals("sequenceNumber")) {
                            cbe.setSequenceNumber(Long.parseLong((String)graphEntry.getValue()));
                            continue;
                        }
                        if (((String)path.get(2)).equals("version")) {
                            cbe.setVersion((String)graphEntry.getValue());
                            continue;
                        }
                        if (((String)path.get(2)).equals("otherData")) {
                            cbe.addAny((String)graphEntry.getValue());
                            continue;
                        }
                        if (((String)path.get(2)).equals("msgDataElement")) {
                            MsgDataElement mde = cbe.getMsgDataElement();
                            if (mde == null) {
                                mde = eventFactory.createMsgDataElement();
                                cbe.setMsgDataElement(mde);
                            }
                            if (((String)path.get(4)).equals("msgId")) {
                                mde.setMsgId((String)graphEntry.getValue());
                                continue;
                            }
                            if (((String)path.get(4)).equals("msgIdType")) {
                                mde.setMsgIdType((String)graphEntry.getValue());
                                continue;
                            }
                            if (((String)path.get(4)).equals("msgCatalogId")) {
                                mde.setMsgCatalogId((String)graphEntry.getValue());
                                continue;
                            }
                            if (((String)path.get(4)).equals("msgCatalogTokens")) {
                                String msgCatTok = (String)graphEntry.getValue();
                                if (msgCatTok == null || msgCatTok.length() <= 0) continue;
                                mde.addMsgCatalogTokenAsString(msgCatTok);
                                continue;
                            }
                            if (((String)path.get(4)).equals("msgCatalogType")) {
                                mde.setMsgCatalogType((String)graphEntry.getValue());
                                continue;
                            }
                            if (((String)path.get(4)).equals("msgCatalog")) {
                                mde.setMsgCatalog((String)graphEntry.getValue());
                                continue;
                            }
                            if (((String)path.get(4)).equals("msgLocale")) {
                                mde.setMsgLocale((String)graphEntry.getValue());
                                continue;
                            }
                            event = this.getEventFactory().createCommonBaseEvent();
                            event.getMsgDataElement().setMsgCatalogId("HyadesGA_CBE_Formatter_MsgDataElement_WARN_");
                            event.getMsgDataElement().setMsgCatalogTokensAsStrings(new String[]{this.getUniqueID(), (String)path.get(4)});
                            event.setSeverity((short)30);
                            this.log(event);
                            continue;
                        }
                        if (((String)path.get(2)).equals("contextDataElements")) {
                            key = String.valueOf((String)path.get(2)) + (String)path.get(3);
                            ContextDataElement cde = (ContextDataElement)cache.get(key);
                            if (cde == null) {
                                cde = eventFactory.createContextDataElement();
                                cbe.addContextDataElement(cde);
                                cache.put(key, cde);
                            }
                            if (((String)path.get(4)).equals("contextId")) {
                                if (cde.getContextValue() != null) {
                                    event4 = this.getEventFactory().createCommonBaseEvent();
                                    event4.getMsgDataElement().setMsgCatalogId("HyadesGA_CBE_Formatter_Duplicate_ContextDataElement_WARN_");
                                    event4.getMsgDataElement().setMsgCatalogTokensAsStrings(new String[]{this.getUniqueID(), (String)path.get(4), "contextValue"});
                                    event4.setSeverity((short)30);
                                    this.log(event4);
                                    continue;
                                }
                                cde.setContextId((String)graphEntry.getValue());
                                continue;
                            }
                            if (((String)path.get(4)).equals("type")) {
                                cde.setType((String)graphEntry.getValue());
                                continue;
                            }
                            if (((String)path.get(4)).equals("name")) {
                                cde.setName((String)graphEntry.getValue());
                                continue;
                            }
                            if (((String)path.get(4)).equals("contextValue")) {
                                if (cde.getContextId() != null) {
                                    event4 = this.getEventFactory().createCommonBaseEvent();
                                    event4.getMsgDataElement().setMsgCatalogId("HyadesGA_CBE_Formatter_Duplicate_ContextDataElement_WARN_");
                                    event4.getMsgDataElement().setMsgCatalogTokensAsStrings(new String[]{this.getUniqueID(), (String)path.get(4), "contextId"});
                                    event4.setSeverity((short)30);
                                    this.log(event4);
                                    continue;
                                }
                                cde.setContextValue((String)graphEntry.getValue());
                                continue;
                            }
                            event4 = this.getEventFactory().createCommonBaseEvent();
                            event4.getMsgDataElement().setMsgCatalogId("HyadesGA_CBE_Formatter_ContextDataElement_WARN_");
                            event4.getMsgDataElement().setMsgCatalogTokensAsStrings(new String[]{this.getUniqueID(), (String)path.get(4)});
                            event4.setSeverity((short)30);
                            this.log(event4);
                            continue;
                        }
                        if (((String)path.get(2)).equals("reporterComponentId") || ((String)path.get(2)).equals("sourceComponentId")) {
                            String value2;
                            ComponentIdentification cid;
                            if (((String)path.get(2)).equals("reporterComponentId")) {
                                cid = cbe.getReporterComponentId();
                                if (cid == null) {
                                    cid = eventFactory.createComponentIdentification();
                                    cbe.setReporterComponentId(cid);
                                }
                            } else {
                                cid = cbe.getSourceComponentId();
                                if (cid == null) {
                                    cid = eventFactory.createComponentIdentification();
                                    cbe.setSourceComponentId(cid);
                                }
                            }
                            if (((String)path.get(4)).equals("location")) {
                                value2 = (String)graphEntry.getValue();
                                if (value2.equals(BUILTIN)) {
                                    value2 = this.getLocalHostId();
                                }
                                cid.setLocation(value2);
                                continue;
                            }
                            if (((String)path.get(4)).equals("locationType")) {
                                value2 = (String)graphEntry.getValue();
                                if (value2.equals(BUILTIN)) {
                                    value2 = this.getLocalHostIdFormat();
                                }
                                cid.setLocationType(value2);
                                continue;
                            }
                            if (((String)path.get(4)).equals("application")) {
                                cid.setApplication((String)graphEntry.getValue());
                                continue;
                            }
                            if (((String)path.get(4)).equals("executionEnvironment")) {
                                cid.setExecutionEnvironment((String)graphEntry.getValue());
                                continue;
                            }
                            if (((String)path.get(4)).equals("component")) {
                                cid.setComponent((String)graphEntry.getValue());
                                continue;
                            }
                            if (((String)path.get(4)).equals("subComponent")) {
                                cid.setSubComponent((String)graphEntry.getValue());
                                continue;
                            }
                            if (((String)path.get(4)).equals("componentIdType")) {
                                cid.setComponentIdType((String)graphEntry.getValue());
                                continue;
                            }
                            if (((String)path.get(4)).equals("componentType")) {
                                cid.setComponentType((String)graphEntry.getValue());
                                continue;
                            }
                            if (((String)path.get(4)).equals("instanceId")) {
                                cid.setInstanceId((String)graphEntry.getValue());
                                continue;
                            }
                            if (((String)path.get(4)).equals("processId")) {
                                cid.setProcessId((String)graphEntry.getValue());
                                continue;
                            }
                            if (((String)path.get(4)).equals("threadId")) {
                                cid.setThreadId((String)graphEntry.getValue());
                                continue;
                            }
                            event = this.getEventFactory().createCommonBaseEvent();
                            event.getMsgDataElement().setMsgCatalogId("HyadesGA_CBE_Formatter_ComponentIdentification_WARN_");
                            event.getMsgDataElement().setMsgCatalogTokensAsStrings(new String[]{this.getUniqueID(), (String)path.get(4)});
                            event.setSeverity((short)30);
                            this.log(event);
                            continue;
                        }
                        if (((String)path.get(2)).equals("situation")) {
                            SituationType sittype;
                            AvailableSituation asit;
                            sit = cbe.getSituation();
                            if (sit == null) {
                                sit = eventFactory.createSituation();
                                cbe.setSituation(sit);
                            }
                            if (((String)path.get(4)).equals("categoryName")) {
                                sit.setCategoryName((String)graphEntry.getValue());
                                continue;
                            }
                            if (((String)path.get(4)).equals("AvailableSituation") || ((String)path.get(4)).equals("situationType") && ((String)path.get(6)).equals("AvailableSituation")) {
                                asit = null;
                                sittype = sit.getSituationType();
                                if (sittype == null) {
                                    asit = eventFactory.createAvailableSituation();
                                    sit.setSituationType((SituationType)asit);
                                    sit.setCategoryName("AvailableSituation");
                                } else if (sittype instanceof AvailableSituation) {
                                    asit = (AvailableSituation)sittype;
                                }
                                if (asit == null) continue;
                                int pindex = 6;
                                if (((String)path.get(4)).equals("situationType")) {
                                    pindex = 8;
                                }
                                if (((String)path.get(pindex)).equals("reasoningScope")) {
                                    asit.setReasoningScope((String)graphEntry.getValue());
                                    continue;
                                }
                                if (((String)path.get(pindex)).equals("operationDisposition")) {
                                    asit.setOperationDisposition((String)graphEntry.getValue());
                                    continue;
                                }
                                if (((String)path.get(pindex)).equals("processingDisposition")) {
                                    asit.setProcessingDisposition((String)graphEntry.getValue());
                                    continue;
                                }
                                if (((String)path.get(pindex)).equals("availabilityDisposition")) {
                                    asit.setAvailabilityDisposition((String)graphEntry.getValue());
                                    continue;
                                }
                                event3 = this.getEventFactory().createCommonBaseEvent();
                                event3.getMsgDataElement().setMsgCatalogId("HyadesGA_CBE_Formatter_AvailableSituation_WARN_");
                                event3.getMsgDataElement().setMsgCatalogTokensAsStrings(new String[]{this.getUniqueID(), (String)path.get(pindex)});
                                event3.setSeverity((short)30);
                                this.log(event3);
                                continue;
                            }
                            if (((String)path.get(4)).equals("RequestSituation") || ((String)path.get(4)).equals("situationType") && ((String)path.get(6)).equals("RequestSituation")) {
                                asit = null;
                                sittype = sit.getSituationType();
                                if (sittype == null) {
                                    asit = eventFactory.createRequestSituation();
                                    sit.setSituationType((SituationType)asit);
                                    sit.setCategoryName("RequestSituation");
                                } else if (sittype instanceof RequestSituation) {
                                    asit = (RequestSituation)sittype;
                                }
                                if (asit == null) continue;
                                int pindex = 6;
                                if (((String)path.get(4)).equals("situationType")) {
                                    pindex = 8;
                                }
                                if (((String)path.get(pindex)).equals("reasoningScope")) {
                                    asit.setReasoningScope((String)graphEntry.getValue());
                                    continue;
                                }
                                if (((String)path.get(pindex)).equals("successDisposition")) {
                                    asit.setSuccessDisposition((String)graphEntry.getValue());
                                    continue;
                                }
                                if (((String)path.get(pindex)).equals("situationQualifier")) {
                                    asit.setSituationQualifier((String)graphEntry.getValue());
                                    continue;
                                }
                                event3 = this.getEventFactory().createCommonBaseEvent();
                                event3.getMsgDataElement().setMsgCatalogId("HyadesGA_CBE_Formatter_RequestSituation_WARN_");
                                event3.getMsgDataElement().setMsgCatalogTokensAsStrings(new String[]{this.getUniqueID(), (String)path.get(pindex)});
                                event3.setSeverity((short)30);
                                this.log(event3);
                                continue;
                            }
                            if (((String)path.get(4)).equals("StartSituation") || ((String)path.get(4)).equals("situationType") && ((String)path.get(6)).equals("StartSituation")) {
                                asit = null;
                                sittype = sit.getSituationType();
                                if (sittype == null) {
                                    asit = eventFactory.createStartSituation();
                                    sit.setSituationType((SituationType)asit);
                                    sit.setCategoryName("StartSituation");
                                } else if (sittype instanceof StartSituation) {
                                    asit = (StartSituation)sittype;
                                }
                                if (asit == null) continue;
                                int pindex = 6;
                                if (((String)path.get(4)).equals("situationType")) {
                                    pindex = 8;
                                }
                                if (((String)path.get(pindex)).equals("reasoningScope")) {
                                    asit.setReasoningScope((String)graphEntry.getValue());
                                    continue;
                                }
                                if (((String)path.get(pindex)).equals("successDisposition")) {
                                    asit.setSuccessDisposition((String)graphEntry.getValue());
                                    continue;
                                }
                                if (((String)path.get(pindex)).equals("situationQualifier")) {
                                    asit.setSituationQualifier((String)graphEntry.getValue());
                                    continue;
                                }
                                event3 = this.getEventFactory().createCommonBaseEvent();
                                event3.getMsgDataElement().setMsgCatalogId("HyadesGA_CBE_Formatter_StartSituation_WARN_");
                                event3.getMsgDataElement().setMsgCatalogTokensAsStrings(new String[]{this.getUniqueID(), (String)path.get(pindex)});
                                event3.setSeverity((short)30);
                                this.log(event3);
                                continue;
                            }
                            if (((String)path.get(4)).equals("StopSituation") || ((String)path.get(4)).equals("situationType") && ((String)path.get(6)).equals("StopSituation")) {
                                asit = null;
                                sittype = sit.getSituationType();
                                if (sittype == null) {
                                    asit = eventFactory.createStopSituation();
                                    sit.setSituationType((SituationType)asit);
                                    sit.setCategoryName("StopSituation");
                                } else if (sittype instanceof StopSituation) {
                                    asit = (StopSituation)sittype;
                                }
                                if (asit == null) continue;
                                int pindex = 6;
                                if (((String)path.get(4)).equals("situationType")) {
                                    pindex = 8;
                                }
                                if (((String)path.get(pindex)).equals("reasoningScope")) {
                                    asit.setReasoningScope((String)graphEntry.getValue());
                                    continue;
                                }
                                if (((String)path.get(pindex)).equals("successDisposition")) {
                                    asit.setSuccessDisposition((String)graphEntry.getValue());
                                    continue;
                                }
                                if (((String)path.get(pindex)).equals("situationQualifier")) {
                                    asit.setSituationQualifier((String)graphEntry.getValue());
                                    continue;
                                }
                                event3 = this.getEventFactory().createCommonBaseEvent();
                                event3.getMsgDataElement().setMsgCatalogId("HyadesGA_CBE_Formatter_StopSituation_WARN_");
                                event3.getMsgDataElement().setMsgCatalogTokensAsStrings(new String[]{this.getUniqueID(), (String)path.get(pindex)});
                                event3.setSeverity((short)30);
                                this.log(event3);
                                continue;
                            }
                            if (((String)path.get(4)).equals("ConnectSituation") || ((String)path.get(4)).equals("situationType") && ((String)path.get(6)).equals("ConnectSituation")) {
                                asit = null;
                                sittype = sit.getSituationType();
                                if (sittype == null) {
                                    asit = eventFactory.createConnectSituation();
                                    sit.setSituationType((SituationType)asit);
                                    sit.setCategoryName("ConnectSituation");
                                } else if (sittype instanceof ConnectSituation) {
                                    asit = (ConnectSituation)sittype;
                                }
                                if (asit == null) continue;
                                int pindex = 6;
                                if (((String)path.get(4)).equals("situationType")) {
                                    pindex = 8;
                                }
                                if (((String)path.get(pindex)).equals("reasoningScope")) {
                                    asit.setReasoningScope((String)graphEntry.getValue());
                                    continue;
                                }
                                if (((String)path.get(pindex)).equals("successDisposition")) {
                                    asit.setSuccessDisposition((String)graphEntry.getValue());
                                    continue;
                                }
                                if (((String)path.get(pindex)).equals("situationDisposition")) {
                                    asit.setSituationDisposition((String)graphEntry.getValue());
                                    continue;
                                }
                                event3 = this.getEventFactory().createCommonBaseEvent();
                                event3.getMsgDataElement().setMsgCatalogId("HyadesGA_CBE_Formatter_ConnectSituation_WARN_");
                                event3.getMsgDataElement().setMsgCatalogTokensAsStrings(new String[]{this.getUniqueID(), (String)path.get(pindex)});
                                event3.setSeverity((short)30);
                                this.log(event3);
                                continue;
                            }
                            if (((String)path.get(4)).equals("ConfigureSituation") || ((String)path.get(4)).equals("situationType") && ((String)path.get(6)).equals("ConfigureSituation")) {
                                asit = null;
                                sittype = sit.getSituationType();
                                if (sittype == null) {
                                    asit = eventFactory.createConfigureSituation();
                                    sit.setSituationType((SituationType)asit);
                                    sit.setCategoryName("ConfigureSituation");
                                } else if (sittype instanceof ConfigureSituation) {
                                    asit = (ConfigureSituation)sittype;
                                }
                                if (asit == null) continue;
                                int pindex = 6;
                                if (((String)path.get(4)).equals("situationType")) {
                                    pindex = 8;
                                }
                                if (((String)path.get(pindex)).equals("reasoningScope")) {
                                    asit.setReasoningScope((String)graphEntry.getValue());
                                    continue;
                                }
                                if (((String)path.get(pindex)).equals("successDisposition")) {
                                    asit.setSuccessDisposition((String)graphEntry.getValue());
                                    continue;
                                }
                                event3 = this.getEventFactory().createCommonBaseEvent();
                                event3.getMsgDataElement().setMsgCatalogId("HyadesGA_CBE_Formatter_ConfigureSituation_WARN_");
                                event3.getMsgDataElement().setMsgCatalogTokensAsStrings(new String[]{this.getUniqueID(), (String)path.get(pindex)});
                                event3.setSeverity((short)30);
                                this.log(event3);
                                continue;
                            }
                            if (((String)path.get(4)).equals("CreateSituation") || ((String)path.get(4)).equals("situationType") && ((String)path.get(6)).equals("CreateSituation")) {
                                asit = null;
                                sittype = sit.getSituationType();
                                if (sittype == null) {
                                    asit = eventFactory.createCreateSituation();
                                    sit.setSituationType((SituationType)asit);
                                    sit.setCategoryName("CreateSituation");
                                } else if (sittype instanceof CreateSituation) {
                                    asit = (CreateSituation)sittype;
                                }
                                if (asit == null) continue;
                                int pindex = 6;
                                if (((String)path.get(4)).equals("situationType")) {
                                    pindex = 8;
                                }
                                if (((String)path.get(pindex)).equals("reasoningScope")) {
                                    asit.setReasoningScope((String)graphEntry.getValue());
                                    continue;
                                }
                                if (((String)path.get(pindex)).equals("successDisposition")) {
                                    asit.setSuccessDisposition((String)graphEntry.getValue());
                                    continue;
                                }
                                event3 = this.getEventFactory().createCommonBaseEvent();
                                event3.getMsgDataElement().setMsgCatalogId("HyadesGA_CBE_Formatter_CreateSituation_WARN_");
                                event3.getMsgDataElement().setMsgCatalogTokensAsStrings(new String[]{this.getUniqueID(), (String)path.get(pindex)});
                                event3.setSeverity((short)30);
                                this.log(event3);
                                continue;
                            }
                            if (((String)path.get(4)).equals("DestroySituation") || ((String)path.get(4)).equals("situationType") && ((String)path.get(6)).equals("DestroySituation")) {
                                asit = null;
                                sittype = sit.getSituationType();
                                if (sittype == null) {
                                    asit = eventFactory.createDestroySituation();
                                    sit.setSituationType((SituationType)asit);
                                    sit.setCategoryName("DestroySituation");
                                } else if (sittype instanceof DestroySituation) {
                                    asit = (DestroySituation)sittype;
                                }
                                if (asit == null) continue;
                                int pindex = 6;
                                if (((String)path.get(4)).equals("situationType")) {
                                    pindex = 8;
                                }
                                if (((String)path.get(pindex)).equals("reasoningScope")) {
                                    asit.setReasoningScope((String)graphEntry.getValue());
                                    continue;
                                }
                                if (((String)path.get(pindex)).equals("successDisposition")) {
                                    asit.setSuccessDisposition((String)graphEntry.getValue());
                                    continue;
                                }
                                event3 = this.getEventFactory().createCommonBaseEvent();
                                event3.getMsgDataElement().setMsgCatalogId("HyadesGA_CBE_Formatter_CreateSituation_WARN_");
                                event3.getMsgDataElement().setMsgCatalogTokensAsStrings(new String[]{this.getUniqueID(), (String)path.get(pindex)});
                                event3.setSeverity((short)30);
                                this.log(event3);
                                continue;
                            }
                            if (((String)path.get(4)).equals("ReportSituation") || ((String)path.get(4)).equals("situationType") && ((String)path.get(6)).equals("ReportSituation")) {
                                asit = null;
                                sittype = sit.getSituationType();
                                if (sittype == null) {
                                    asit = eventFactory.createReportSituation();
                                    sit.setSituationType((SituationType)asit);
                                    sit.setCategoryName("ReportSituation");
                                } else if (sittype instanceof ReportSituation) {
                                    asit = (ReportSituation)sittype;
                                }
                                if (asit == null) continue;
                                int pindex = 6;
                                if (((String)path.get(4)).equals("situationType")) {
                                    pindex = 8;
                                }
                                if (((String)path.get(pindex)).equals("reasoningScope")) {
                                    asit.setReasoningScope((String)graphEntry.getValue());
                                    continue;
                                }
                                if (((String)path.get(pindex)).equals("reportCategory")) {
                                    asit.setReportCategory((String)graphEntry.getValue());
                                    continue;
                                }
                                event3 = this.getEventFactory().createCommonBaseEvent();
                                event3.getMsgDataElement().setMsgCatalogId("HyadesGA_CBE_Formatter_ReportSituation_WARN_");
                                event3.getMsgDataElement().setMsgCatalogTokensAsStrings(new String[]{this.getUniqueID(), (String)path.get(pindex)});
                                event3.setSeverity((short)30);
                                this.log(event3);
                                continue;
                            }
                            if (((String)path.get(4)).equals("FeatureSituation") || ((String)path.get(4)).equals("situationType") && ((String)path.get(6)).equals("FeatureSituation")) {
                                asit = null;
                                sittype = sit.getSituationType();
                                if (sittype == null) {
                                    asit = eventFactory.createFeatureSituation();
                                    sit.setSituationType((SituationType)asit);
                                    sit.setCategoryName("FeatureSituation");
                                } else if (sittype instanceof FeatureSituation) {
                                    asit = (FeatureSituation)sittype;
                                }
                                if (asit == null) continue;
                                int pindex = 6;
                                if (((String)path.get(4)).equals("situationType")) {
                                    pindex = 8;
                                }
                                if (((String)path.get(pindex)).equals("reasoningScope")) {
                                    asit.setReasoningScope((String)graphEntry.getValue());
                                    continue;
                                }
                                if (((String)path.get(pindex)).equals("featureDisposition")) {
                                    asit.setFeatureDisposition((String)graphEntry.getValue());
                                    continue;
                                }
                                event3 = this.getEventFactory().createCommonBaseEvent();
                                event3.getMsgDataElement().setMsgCatalogId("HyadesGA_CBE_Formatter_FeatureSituation_WARN_");
                                event3.getMsgDataElement().setMsgCatalogTokensAsStrings(new String[]{this.getUniqueID(), (String)path.get(pindex)});
                                event3.setSeverity((short)30);
                                this.log(event3);
                                continue;
                            }
                            if (((String)path.get(4)).equals("DependencySituation") || ((String)path.get(4)).equals("situationType") && ((String)path.get(6)).equals("DependencySituation")) {
                                asit = null;
                                sittype = sit.getSituationType();
                                if (sittype == null) {
                                    asit = eventFactory.createDependencySituation();
                                    sit.setSituationType((SituationType)asit);
                                    sit.setCategoryName("DependencySituation");
                                } else if (sittype instanceof DependencySituation) {
                                    asit = (DependencySituation)sittype;
                                }
                                if (asit == null) continue;
                                int pindex = 6;
                                if (((String)path.get(4)).equals("situationType")) {
                                    pindex = 8;
                                }
                                if (((String)path.get(pindex)).equals("reasoningScope")) {
                                    asit.setReasoningScope((String)graphEntry.getValue());
                                    continue;
                                }
                                if (((String)path.get(pindex)).equals("dependencyDisposition")) {
                                    asit.setDependencyDisposition((String)graphEntry.getValue());
                                    continue;
                                }
                                event3 = this.getEventFactory().createCommonBaseEvent();
                                event3.getMsgDataElement().setMsgCatalogId("HyadesGA_CBE_Formatter_DependencySituation_WARN_");
                                event3.getMsgDataElement().setMsgCatalogTokensAsStrings(new String[]{this.getUniqueID(), (String)path.get(pindex)});
                                event3.setSeverity((short)30);
                                this.log(event3);
                                continue;
                            }
                            if (((String)path.get(4)).equals("OtherSituation") || ((String)path.get(4)).equals("situationType") && ((String)path.get(6)).equals("OtherSituation")) {
                                asit = null;
                                sittype = sit.getSituationType();
                                if (sittype == null) {
                                    asit = eventFactory.createOtherSituation();
                                    sit.setSituationType((SituationType)asit);
                                    sit.setCategoryName("OtherSituation");
                                } else if (sittype instanceof OtherSituation) {
                                    asit = (OtherSituation)sittype;
                                }
                                if (asit == null) continue;
                                int pindex = 6;
                                if (((String)path.get(4)).equals("situationType")) {
                                    pindex = 8;
                                }
                                if (((String)path.get(pindex)).equals("reasoningScope")) {
                                    asit.setReasoningScope((String)graphEntry.getValue());
                                    continue;
                                }
                                if (((String)path.get(pindex)).equals("##any")) {
                                    asit.setAny((String)graphEntry.getValue());
                                    continue;
                                }
                                event3 = this.getEventFactory().createCommonBaseEvent();
                                event3.getMsgDataElement().setMsgCatalogId("HyadesGA_CBE_Formatter_DependencySituation_WARN_");
                                event3.getMsgDataElement().setMsgCatalogTokensAsStrings(new String[]{this.getUniqueID(), (String)path.get(pindex)});
                                event3.setSeverity((short)30);
                                this.log(event3);
                                continue;
                            }
                            event = this.getEventFactory().createCommonBaseEvent();
                            event.getMsgDataElement().setMsgCatalogId("HyadesGA_CBE_Formatter_Invalid_SituationType_WARN_");
                            event.getMsgDataElement().setMsgCatalogTokensAsStrings(new String[]{this.getUniqueID(), (String)path.get(6)});
                            event.setSeverity((short)30);
                            this.log(event);
                            continue;
                        }
                        if (((String)path.get(2)).startsWith("associatedEvents")) {
                            key = String.valueOf((String)path.get(2)) + (String)path.get(3);
                            AssociatedEvent ae = (AssociatedEvent)cache.get(key);
                            if (ae == null) {
                                ae = eventFactory.createAssociatedEvent();
                                cbe.addAssociatedEvent(ae);
                                cache.put(key, ae);
                            }
                            if (((String)path.get(4)).equals("associationEngine")) {
                                event4 = this.getEventFactory().createCommonBaseEvent();
                                event4.getMsgDataElement().setMsgCatalogId("HyadesGA_CBE_Formatter_Invalid_AssociatedEvent_WARN_");
                                event4.getMsgDataElement().setMsgCatalogTokensAsStrings(new String[]{this.getUniqueID(), (String)path.get(4)});
                                event4.setSeverity((short)30);
                                this.log(event4);
                                continue;
                            }
                            if (((String)path.get(4)).equals("associationEngineInfo")) {
                                AssociationEngine aei = ae.getAssociationEngineInfo();
                                if (aei == null) {
                                    aei = eventFactory.createAssociationEngine();
                                    aei.setId(Guid.generate());
                                    ae.setAssociationEngineInfo(aei);
                                }
                                if (((String)path.get(6)).equals("id")) {
                                    aei.setId((String)graphEntry.getValue());
                                    continue;
                                }
                                if (((String)path.get(6)).equals("name")) {
                                    aei.setName((String)graphEntry.getValue());
                                    continue;
                                }
                                if (((String)path.get(6)).equals("type")) {
                                    aei.setType((String)graphEntry.getValue());
                                    continue;
                                }
                                CommonBaseEvent event5 = this.getEventFactory().createCommonBaseEvent();
                                event5.getMsgDataElement().setMsgCatalogId("HyadesGA_CBE_Formatter_Invalid_AssociationEngine_WARN_");
                                event5.getMsgDataElement().setMsgCatalogTokensAsStrings(new String[]{this.getUniqueID(), (String)path.get(6)});
                                event5.setSeverity((short)30);
                                this.log(event5);
                                continue;
                            }
                            if (((String)path.get(4)).equals("resolvedEvents")) {
                                ae.addResolvedEvent((String)graphEntry.getValue());
                                continue;
                            }
                            event4 = this.getEventFactory().createCommonBaseEvent();
                            event4.getMsgDataElement().setMsgCatalogId("HyadesGA_CBE_Formatter_Invalid_AssociatedEvent_WARN_");
                            event4.getMsgDataElement().setMsgCatalogTokensAsStrings(new String[]{this.getUniqueID(), (String)path.get(4)});
                            event4.setSeverity((short)30);
                            this.log(event4);
                            continue;
                        }
                        if (((String)path.get(2)).startsWith("extendedDataElements")) {
                            key = String.valueOf((String)path.get(2)) + (String)path.get(3);
                            ExtendedDataElement ede = (ExtendedDataElement)cache.get(key);
                            if (ede == null) {
                                ede = eventFactory.createExtendedDataElement();
                                cbe.addExtendedDataElement(ede);
                                cache.put(key, ede);
                            }
                            String property = (String)path.get(4);
                            int depth = 4;
                            while (property != null) {
                                if (property.equals("name")) {
                                    ede.setName((String)graphEntry.getValue());
                                    property = null;
                                    continue;
                                }
                                if (property.equals("type")) {
                                    if (ede.getType() == null) {
                                        ede.setType((String)graphEntry.getValue());
                                    }
                                    property = null;
                                    continue;
                                }
                                if (property.equals("values")) {
                                    valueList = ede.getValues();
                                    int valuesLength = 0;
                                    String value3 = (String)graphEntry.getValue();
                                    if (value3 != null && (valuesLength = value3.trim().length()) > 1024) {
                                        ede.setTypeAsInt(16);
                                        int counter = 0;
                                        while (counter < valuesLength) {
                                            valueList.add(value3.substring(counter, Math.min(counter + 1024, valuesLength)));
                                            counter += 1024;
                                        }
                                    } else {
                                        valueList.add(value3);
                                    }
                                    property = null;
                                    continue;
                                }
                                if (property.equals("hexValue")) {
                                    if (ede.getValues() != null) {
                                        event3 = this.getEventFactory().createCommonBaseEvent();
                                        event3.getMsgDataElement().setMsgCatalogId("HyadesGA_CBE_Formatter_Duplicate_ExtendedDataElement_WARN_");
                                        event3.getMsgDataElement().setMsgCatalogTokensAsStrings(new String[]{this.getUniqueID(), property, "values"});
                                        event3.setSeverity((short)30);
                                        this.log(event3);
                                    } else {
                                        ede.setHexValueAsCharArray((char[])graphEntry.getValue());
                                    }
                                    property = null;
                                    continue;
                                }
                                if (property.equals("children")) {
                                    ExtendedDataElement edeTmp;
                                    String edeName = (String)path.get(++depth);
                                    EList edeArr = ede.getChildren();
                                    if (edeArr == null) {
                                        edeTmp = eventFactory.createExtendedDataElement();
                                        edeTmp.setName(edeName);
                                        ede.addChild(edeTmp);
                                        ede = edeTmp;
                                    } else {
                                        edeTmp = null;
                                        int j = 0;
                                        while (j < edeArr.size()) {
                                            if (((ExtendedDataElement)edeArr.get(j)).getName().equals(edeName)) {
                                                edeTmp = (ExtendedDataElement)edeArr.get(j);
                                            }
                                            ++j;
                                        }
                                        if (edeTmp == null) {
                                            edeTmp = eventFactory.createExtendedDataElement();
                                            edeTmp.setName(edeName);
                                            ede.addChild(edeTmp);
                                        }
                                        ede = edeTmp;
                                    }
                                    property = (String)path.get(depth += 2);
                                    continue;
                                }
                                event3 = this.getEventFactory().createCommonBaseEvent();
                                event3.getMsgDataElement().setMsgCatalogId("HyadesGA_CBE_Formatter_Invalid_ExtendedDataElement_WARN_");
                                event3.getMsgDataElement().setMsgCatalogTokensAsStrings(new String[]{this.getUniqueID(), property});
                                event3.setSeverity((short)30);
                                this.log(event3);
                                property = null;
                            }
                            continue;
                        }
                        event2 = this.getEventFactory().createCommonBaseEvent();
                        event2.getMsgDataElement().setMsgCatalogId("HyadesGA_CBE_Formatter_Invalid_CommmonBaseEvent_WARN_");
                        event2.getMsgDataElement().setMsgCatalogTokensAsStrings(new String[]{this.getUniqueID(), (String)path.get(2)});
                        event2.setSeverity((short)30);
                        this.log(event2);
                        continue;
                    }
                    event2 = this.getEventFactory().createCommonBaseEvent();
                    event2.getMsgDataElement().setMsgCatalogId("HyadesGA_CBE_Formatter_Invalid_Property_WARN_");
                    event2.getMsgDataElement().setMsgCatalogTokensAsStrings(new String[]{this.getUniqueID(), (String)path.get(0)});
                    event2.setSeverity((short)30);
                    this.log(event2);
                }
                catch (NumberFormatException numberFormatException) {
                    event2 = this.getEventFactory().createCommonBaseEvent();
                    event2.getMsgDataElement().setMsgCatalogId("HyadesGA_CBE_Formatter_Non_Numeric_Property_WARN_");
                    event2.getMsgDataElement().setMsgCatalogTokensAsStrings(new String[]{this.getUniqueID(), (String)path.get(2)});
                    event2.setSeverity((short)30);
                    this.log(event2);
                }
                catch (Exception e) {
                    event = this.getEventFactory().createCommonBaseEvent();
                    event.setMsg(Messages.getString("HyadesGA_CBE_Formatter_Exception_WARN_", this.getUniqueID(), (String)path.get(2), e.getMessage()));
                    event.setSeverity((short)30);
                    this.log(event);
                }
            }
            boolean validCBE = true;
            if (cbe != null) {
                String errMsg;
                ComponentIdentification srcCompId = cbe.getSourceComponentId();
                sit = cbe.getSituation();
                try {
                    if (!cbe.isSetCreationTime()) {
                        event = this.getEventFactory().createCommonBaseEvent();
                        event.getMsgDataElement().setMsgCatalogId("HyadesGA_CBE_Formatter_Missing_Required_Field_ERROR_");
                        event.getMsgDataElement().setMsgCatalogTokensAsStrings(new String[]{this.getUniqueID(), "creationTime"});
                        event.setSeverity((short)50);
                        this.log(event);
                        validCBE = false;
                    }
                }
                catch (Exception e) {
                    errMsg = e.getMessage();
                    if (errMsg == null || errMsg.length() == 0) {
                        errMsg = e.toString();
                    }
                    CommonBaseEvent event6 = this.getEventFactory().createCommonBaseEvent();
                    event6.getMsgDataElement().setMsgCatalogId("HyadesGA_CBE_Formatter_Invalid_Field_Value_ERROR_");
                    event6.getMsgDataElement().setMsgCatalogTokensAsStrings(new String[]{this.getUniqueID(), "creationTime", cbe.getCreationTime(), errMsg});
                    event6.setSeverity((short)50);
                    this.log(event6);
                    validCBE = false;
                }
                if (validCBE && srcCompId == null) {
                    event = this.getEventFactory().createCommonBaseEvent();
                    event.getMsgDataElement().setMsgCatalogId("HyadesGA_CBE_Formatter_Missing_Required_Field_ERROR_");
                    event.getMsgDataElement().setMsgCatalogTokensAsStrings(new String[]{this.getUniqueID(), "sourceComponentId"});
                    event.setSeverity((short)50);
                    this.log(event);
                    validCBE = false;
                } else if (validCBE && this.testMode) {
                    try {
                        srcCompId.validate();
                    }
                    catch (ValidationException ve) {
                        errMsg = ve.getMessage();
                        if (errMsg == null || errMsg.length() == 0) {
                            errMsg = ve.toString();
                        }
                        CommonBaseEvent event7 = this.getEventFactory().createCommonBaseEvent();
                        event7.getMsgDataElement().setMsgCatalogId("HyadesGA_CBE_Formatter_Invalid_Field_Value_ERROR_");
                        event7.getMsgDataElement().setMsgCatalogTokensAsStrings(new String[]{this.getUniqueID(), "sourceComponentId", "unknown", errMsg});
                        event7.setSeverity((short)50);
                        this.log(event7);
                        validCBE = false;
                    }
                } else if (validCBE && srcCompId.getLocation() == null) {
                    event = this.getEventFactory().createCommonBaseEvent();
                    event.getMsgDataElement().setMsgCatalogId("HyadesGA_CBE_Formatter_Missing_Required_Field_ERROR_");
                    event.getMsgDataElement().setMsgCatalogTokensAsStrings(new String[]{this.getUniqueID(), "location"});
                    event.setSeverity((short)50);
                    this.log(event);
                    validCBE = false;
                } else if (validCBE && srcCompId.getLocationType() == null) {
                    event = this.getEventFactory().createCommonBaseEvent();
                    event.getMsgDataElement().setMsgCatalogId("HyadesGA_CBE_Formatter_Missing_Required_Field_ERROR_");
                    event.getMsgDataElement().setMsgCatalogTokensAsStrings(new String[]{this.getUniqueID(), "locationType"});
                    event.setSeverity((short)50);
                    this.log(event);
                    validCBE = false;
                } else if (validCBE && srcCompId.getComponent() == null) {
                    event = this.getEventFactory().createCommonBaseEvent();
                    event.getMsgDataElement().setMsgCatalogId("HyadesGA_CBE_Formatter_Missing_Required_Field_ERROR_");
                    event.getMsgDataElement().setMsgCatalogTokensAsStrings(new String[]{this.getUniqueID(), "component"});
                    event.setSeverity((short)50);
                    this.log(event);
                    validCBE = false;
                } else if (validCBE && srcCompId.getComponentIdType() == null) {
                    event = this.getEventFactory().createCommonBaseEvent();
                    event.getMsgDataElement().setMsgCatalogId("HyadesGA_CBE_Formatter_Missing_Required_Field_ERROR_");
                    event.getMsgDataElement().setMsgCatalogTokensAsStrings(new String[]{this.getUniqueID(), "componentIdType"});
                    event.setSeverity((short)50);
                    this.log(event);
                    validCBE = false;
                } else if (validCBE && srcCompId.getComponentType() == null) {
                    event = this.getEventFactory().createCommonBaseEvent();
                    event.getMsgDataElement().setMsgCatalogId("HyadesGA_CBE_Formatter_Missing_Required_Field_ERROR_");
                    event.getMsgDataElement().setMsgCatalogTokensAsStrings(new String[]{this.getUniqueID(), "componentType"});
                    event.setSeverity((short)50);
                    this.log(event);
                    validCBE = false;
                } else if (validCBE && srcCompId.getSubComponent() == null) {
                    event = this.getEventFactory().createCommonBaseEvent();
                    event.getMsgDataElement().setMsgCatalogId("HyadesGA_CBE_Formatter_Missing_Required_Field_ERROR_");
                    event.getMsgDataElement().setMsgCatalogTokensAsStrings(new String[]{this.getUniqueID(), "subComponent"});
                    event.setSeverity((short)50);
                    this.log(event);
                    validCBE = false;
                }
                if (validCBE && sit == null) {
                    event = this.getEventFactory().createCommonBaseEvent();
                    event.getMsgDataElement().setMsgCatalogId("HyadesGA_CBE_Formatter_Missing_Required_Field_ERROR_");
                    event.getMsgDataElement().setMsgCatalogTokensAsStrings(new String[]{this.getUniqueID(), "situation"});
                    event.setSeverity((short)50);
                    this.log(event);
                    validCBE = false;
                } else if (validCBE && this.testMode) {
                    try {
                        sit.validate();
                    }
                    catch (ValidationException ve) {
                        errMsg = ve.getMessage();
                        if (errMsg == null || errMsg.length() == 0) {
                            errMsg = ve.toString();
                        }
                        CommonBaseEvent event8 = this.getEventFactory().createCommonBaseEvent();
                        event8.getMsgDataElement().setMsgCatalogId("HyadesGA_CBE_Formatter_Invalid_Field_Value_ERROR_");
                        event8.getMsgDataElement().setMsgCatalogTokensAsStrings(new String[]{this.getUniqueID(), "situation", "unknown", errMsg});
                        event8.setSeverity((short)50);
                        this.log(event8);
                        validCBE = false;
                    }
                } else if (validCBE && sit.getSituationType() == null) {
                    event = this.getEventFactory().createCommonBaseEvent();
                    event.getMsgDataElement().setMsgCatalogId("HyadesGA_CBE_Formatter_Missing_Required_Field_ERROR_");
                    event.getMsgDataElement().setMsgCatalogTokensAsStrings(new String[]{this.getUniqueID(), "situationType"});
                    event.setSeverity((short)50);
                    this.log(event);
                } else if (validCBE && sit.getCategoryName() == null) {
                    event = this.getEventFactory().createCommonBaseEvent();
                    event.getMsgDataElement().setMsgCatalogId("HyadesGA_CBE_Formatter_Missing_Required_Field_ERROR_");
                    event.getMsgDataElement().setMsgCatalogTokensAsStrings(new String[]{this.getUniqueID(), "categoryName"});
                    event.setSeverity((short)50);
                    this.log(event);
                }
            } else {
                validCBE = false;
            }
            if (validCBE || this.testMode) {
                cbes[k] = cbe;
                ++cbesCreatedCount;
            }
            this.incrementItemsProcessedCount();
            ++k;
        }
        this.trace("HyadesGATrace_Component_Processing_End_INFO_", this.getName(), Integer.toString(cbesCreatedCount));
        return cbes;
    }

    public Object[] testProcessEventItems(Object[] msgs) throws AdapterInvalidConfig {
        return this.testProcessDirectedGraphs(msgs);
    }

    private CommonBaseEvent[] testProcessDirectedGraphs(Object[] elements) throws AdapterInvalidConfig {
        if (!(elements[0] instanceof List)) {
            throw new AdapterInvalidConfig("This formatter will only accept arrays of Lists");
        }
        CommonBaseEvent[] eventArray = new CommonBaseEvent[]{eventFactory.createCommonBaseEvent()};
        return eventArray;
    }

    public void update() throws AdapterInvalidConfig {
        super.update();
        Element element = this.getConfiguration();
        if (element.hasAttribute("test")) {
            this.testMode = true;
        }
    }

    private void getLocalHostInfo() {
        try {
            this.localHostId = InetAddress.getLocalHost().getHostAddress();
            this.localHostIdFormat = this.localHostId.indexOf(58) != -1 ? HOST_ID_FORMAT_IPV6 : HOST_ID_FORMAT_IPV4;
        }
        catch (Exception exception) {
            this.localHostId = UNKNOWN_HOST;
            this.localHostIdFormat = NONE;
        }
    }

    private String getLocalHostId() {
        if (this.localHostId == null) {
            this.getLocalHostInfo();
        }
        return this.localHostId;
    }

    private String getLocalHostIdFormat() {
        if (this.localHostIdFormat == null) {
            this.getLocalHostInfo();
        }
        return this.localHostIdFormat;
    }
}

