/*******************************************************************************
 * Copyright (c) 2010 Engineering Group.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Angelo bernabei (Engineering Group)
 *******************************************************************************/
package org.eclipse.ebam.emf.utilities;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.util.Date;
import java.util.HashMap;
import java.util.Hashtable;

import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;

import org.apache.xpath.XPathAPI;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.traversal.NodeIterator;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

/**
 * 
 * @author bernabei
 *
 *  This class implements a simple Cache used to store some information
 *  during the save message process.
 */
public class CacheSingleton implements CacheInterface{
	
	private static CacheInterface instance=null;
	private int timeout=120;  // in second
	private boolean enable=false;
	private final String confFilePath = "/conf/cache.xml";
	private String contentConfig = null;
	private static Logger logger = LoggerFactory.getLogger(CacheSingleton.class);
	private HashMap insieme=new HashMap(); 
	private Document doc;
	private long lastClearTime=0;
	
	private CacheSingleton() {
		super();
		
		URL configFile = ConfigurationReader.getFileURL(confFilePath);
		InputStream is;
		try {
			is = configFile.openStream();
		} catch (IOException e1) {
			logger.error(e1.getMessage(), e1);
			return;
		}
		BufferedReader br = new BufferedReader(new InputStreamReader(is));
		StringBuilder sb = new StringBuilder();
		String line = null;
		
		try {
			while ((line = br.readLine()) != null){
				sb.append(line);
			}
			br.close();
			contentConfig = sb.toString();

			DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
			DocumentBuilder db = dbf.newDocumentBuilder();

			StringBuffer strBufferContent = new StringBuffer(contentConfig);
			ByteArrayInputStream bais = new ByteArrayInputStream(
					strBufferContent.toString().getBytes("UTF-8"));

			InputSource inputSource = new InputSource(bais);

			doc = db.parse(inputSource);
			doc.getDocumentElement().normalize();
			Hashtable properties = new Hashtable<String, String>();
			NodeIterator propertiesNode = XPathAPI.selectNodeIterator(doc,"//cache-configuration/property");
			Node pn=null;

			while ((pn = propertiesNode.nextNode()) != null) {
				properties.put(XPathAPI.eval(pn, "@name").toString(), XPathAPI.eval(pn, "@value").toString());
			}
			String timeout=(String)properties.get("timeout");
			String enable=(String)properties.get("enable");
			
			if (enable !=null && enable.equalsIgnoreCase("true")) this.enable=true;
			if (timeout !=null ) this.timeout=Integer.parseInt(timeout)*1000;
			logger.info("Cache configuration: enable="+enable);
			logger.info("Cache configuration: timeout="+timeout);
			
		} catch (UnsupportedEncodingException e) {
		    logger.error("",e);
		} catch (IOException e) {
		    logger.error("",e);
		} catch (ParserConfigurationException e) {
		    logger.error("",e);
		} catch (SAXException e) {
		    logger.error("",e);
		} catch (TransformerException e) {
			logger.error("",e);
		}
	}


	public synchronized static CacheInterface getInstance() {
		if (instance == null) {
			instance = new CacheSingleton();
		}
		return instance;
	}


	public synchronized Object get(String code, String type) {
		if (enable) {
			long now=(new Date()).getTime();
			if (lastClearTime!=0 &&  now-lastClearTime>timeout){
				// the data in cache are old... we have to delete all data in cache
				insieme=new HashMap(); 
				lastClearTime=(new Date()).getTime();
			}
			HashMap cache = (HashMap) insieme.get(type);
			if (cache == null) {
				return null;
			}
			return cache.get(code);
		} else
			return null;

	}


	public synchronized void put(String code, Object obj, String type) {
		if (enable) {			
			HashMap cache = (HashMap) insieme.get(type);
			if (cache == null) {
				insieme.put(type, new HashMap());
			}
			cache = (HashMap) insieme.get(type);
			cache.put(code, obj);
		}

	}

}
