/*******************************************************************************
 * Copyright (c) 2010 Engineering Group.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Marco Cortella (Engineering Group) - initial API and implementation and/or initial documentation
 *******************************************************************************/
package org.eclipse.ebam.model.entities;

import java.io.Serializable;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Table;


/**
 * The persistent class for the ebam_message_engine database table.
 * 
 */
@Entity
@Table(name="ebam_message_engine")
public class MessageEngine implements Serializable {
	private static final long serialVersionUID = 1L;

	@Id
	@Column(name="MESSAGE_ID", nullable=false,
          insertable=false, updatable=false)	
	private int messageId;
	@Id
	@Column(name="VALUE_ID", nullable=false,
	          insertable=false, updatable=false)
	private int valueId;

	//bi-directional one-to-one association to EbamMessage
	@ManyToOne(fetch=FetchType.LAZY)
	@JoinColumn(name="MESSAGE_ID")
	private Message ebamMessage;
	
	//bi-directional many-to-one association to SbiAlarm
    @ManyToOne(fetch=FetchType.LAZY)
	@JoinColumn(name="VALUE_ID")
	private SbiDomain sbiDomain;

    public MessageEngine() {
    }

	public int getMessageId() {
		return this.messageId;
	}

	public void setMessageId(int messageId) {
		this.messageId = messageId;
	}

	public int getValueId() {
		return this.valueId;
	}

	public void setValueId(int valueId) {
		this.valueId = valueId;
	}

	public Message getEbamMessage() {
		return this.ebamMessage;
	}

	public void setEbamMessage(Message ebamMessage) {
		this.ebamMessage = ebamMessage;
	}

	public SbiDomain getSbiDomain() {
		return sbiDomain;
	}

	public void setSbiDomain(SbiDomain sbiDomain) {
		this.sbiDomain = sbiDomain;
	}
	
	
}