/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ebpm.databasemanager;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.EntityTransaction;
import javax.persistence.NoResultException;
import javax.persistence.Persistence;
import javax.persistence.Query;
import javax.sql.DataSource;
import org.eclipse.ebpm.core.SpagicNode;
import org.eclipse.ebpm.databasemanager.IDatabaseManager;
import org.eclipse.ebpm.metadb.constants.ProcessExecutionStateConstants;
import org.eclipse.ebpm.metadb.model.Component;
import org.eclipse.ebpm.metadb.model.Property;
import org.eclipse.ebpm.metadb.model.PropertyServiceInstance;
import org.eclipse.ebpm.metadb.model.Service;
import org.eclipse.ebpm.metadb.model.ServiceInstance;
import org.eclipse.ebpm.metadb.model.TypeService;
import org.eclipse.ebpm.startup.service.IStartedUpService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DatabaseService
implements IDatabaseManager {
    protected Logger log = LoggerFactory.getLogger(DatabaseService.class);
    public static final String COMPONENT_ID = "idComponent".intern();
    public static final String COMPONENT_NAME = "name".intern();
    public static final String SERVICE_ID = "idService".intern();
    public static final String SERVICE_VERSION = "serviceVersion".intern();
    public static final String SERVICE_INSTANCE_ID = "idServiceInstance".intern();
    public static final String SERVICE_INSTANCE_SERVICE_ID = "id_service".intern();
    public static final String SERVICE_INSTANCE_MESSAGE_ID = "messageId".intern();
    public static final String SERVICE_INSTANCE_CORRELATION_ID = "correlationId".intern();
    public static final String NON_JTA_DATASOURCE = "javax.persistence.nonJtaDataSource";
    public static final String PERSISTENCE_UNIT = "org.eclipse.ebpm.metadb.model";
    private Map<String, DataSource> properties = null;
    private EntityManagerFactory emf = null;
    private EntityManager em = null;

    public void bindMetaDB(DataSource ds) {
        this.log.info("DatabaseService: Metadb Datasource has been bound");
        this.properties = new HashMap<String, DataSource>();
        this.properties.put(NON_JTA_DATASOURCE, ds);
        this.emf = Persistence.createEntityManagerFactory((String)PERSISTENCE_UNIT, this.properties);
        this.em = this.emf.createEntityManager();
        this.registerNodeInfo();
    }

    public void bindStartUpService(IStartedUpService startedUpService) {
        this.log.info("STARTUP SERVICE IS OK -> CAN START PROFILE SERVICE");
    }

    public void unbindStartUpService(IStartedUpService startedUpService) {
    }

    public void unbindMetaDB(DataSource ds) {
        this.log.info("DatabaseService: Metadb Datasource has been unbound");
    }

    public void registerNodeInfo() {
        block6: {
            EntityTransaction tx = null;
            try {
                org.eclipse.ebpm.metadb.model.SpagicNode metaDBSpagicNode = (org.eclipse.ebpm.metadb.model.SpagicNode)this.em.find(org.eclipse.ebpm.metadb.model.SpagicNode.class, (Object)SpagicNode.id());
                boolean alreadyThere = false;
                if (metaDBSpagicNode == null) {
                    metaDBSpagicNode = new org.eclipse.ebpm.metadb.model.SpagicNode();
                    metaDBSpagicNode.setIdNode(SpagicNode.id());
                } else {
                    alreadyThere = true;
                }
                metaDBSpagicNode.setIpAddress(SpagicNode.ipAddress());
                metaDBSpagicNode.setHost(SpagicNode.host());
                metaDBSpagicNode.setAdminPort(SpagicNode.adminPort().intValue());
                metaDBSpagicNode.setSslPort(SpagicNode.sslPort().intValue());
                tx = this.em.getTransaction();
                tx.begin();
                if (alreadyThere) {
                    this.em.merge((Object)metaDBSpagicNode);
                } else {
                    this.em.persist((Object)metaDBSpagicNode);
                }
                this.em.flush();
                tx.commit();
            }
            catch (Throwable ex) {
                this.log.error("Error Saving Node Information", ex);
                System.exit(0);
                if (tx == null || !tx.isActive()) break block6;
                tx.rollback();
            }
        }
    }

    @Override
    public Component getComponentByName(String componentName) {
        try {
            Query query = this.em.createQuery("select c from Component c where c.name = :name");
            query.setParameter(COMPONENT_NAME, (Object)componentName);
            return (Component)query.getSingleResult();
        }
        catch (NoResultException noResultException) {
            return null;
        }
    }

    @Override
    public Service getServiceById(String serviceId) {
        try {
            return (Service)this.em.find(Service.class, (Object)serviceId);
        }
        catch (NoResultException noResultException) {
            return null;
        }
    }

    @Override
    public ServiceInstance getServiceInstance(Long serviceInstanceId) {
        try {
            return (ServiceInstance)this.em.find(ServiceInstance.class, (Object)serviceInstanceId);
        }
        catch (NoResultException noResultException) {
            return null;
        }
    }

    @Override
    public ServiceInstance getServiceInstanceByMessageId(String exchangeID) {
        try {
            Query query = this.em.createQuery("select si from ServiceInstance si where si.messageId = :messageId");
            query.setParameter(SERVICE_INSTANCE_MESSAGE_ID, (Object)exchangeID);
            return (ServiceInstance)query.getSingleResult();
        }
        catch (NoResultException noResultException) {
            return null;
        }
    }

    @Override
    public ServiceInstance getServiceInstanceByCorrelationId(String serviceId, String correlationID) {
        try {
            Query query = this.em.createQuery("select si from ServiceInstance si where si.service.idService = :id_service and si.correlationId = :correlationId");
            query.setParameter(SERVICE_INSTANCE_SERVICE_ID, (Object)serviceId);
            query.setParameter(SERVICE_INSTANCE_CORRELATION_ID, (Object)correlationID);
            return (ServiceInstance)query.getSingleResult();
        }
        catch (NoResultException noResultException) {
            return null;
        }
    }

    @Override
    public ServiceInstance createServiceInstance(String serviceId, String exchangeID, String correlationId, ServiceInstance targetServiceInstance, String request, String response) {
        ServiceInstance serviceInstance;
        block2: {
            EntityTransaction tx = null;
            serviceInstance = null;
            try {
                serviceInstance = new ServiceInstance();
                serviceInstance.setMessageId(exchangeID);
                serviceInstance.setCorrelationId(correlationId);
                serviceInstance.setRequest(request);
                serviceInstance.setResponse(response);
                serviceInstance.setService(this.getServiceById(serviceId));
                serviceInstance.setTargetServiceInstance(targetServiceInstance);
                serviceInstance.setState(0);
                serviceInstance.setStartdate(new Date());
                serviceInstance.setExecutionNode(SpagicNode.id());
                tx = this.em.getTransaction();
                tx.begin();
                this.em.persist((Object)serviceInstance);
                tx.commit();
            }
            catch (Throwable ex) {
                this.log.error("Error creating service instance: " + serviceId + "," + correlationId, ex);
                if (tx == null || !tx.isActive()) break block2;
                tx.rollback();
            }
        }
        return serviceInstance;
    }

    @Override
    public void updateServiceInstance(ServiceInstance serviceInstance) {
        EntityTransaction tx = null;
        try {
            tx = this.em.getTransaction();
            tx.begin();
            serviceInstance = (ServiceInstance)this.em.merge((Object)serviceInstance);
            tx.commit();
        }
        catch (Throwable e) {
            if (tx != null && tx.isActive()) {
                tx.rollback();
            }
            this.log.error("Error updating service instance: " + serviceInstance.getIdServiceInstance(), e);
            this.log.error("Try to create a new ServiceInstance.");
            try {
                tx = this.em.getTransaction();
                tx.begin();
                this.em.persist((Object)serviceInstance);
                tx.commit();
            }
            catch (Throwable throwable) {
                if (tx != null && tx.isActive()) {
                    tx.rollback();
                }
                throw new RuntimeException("ServiceInstance updateServiceInstance failed: " + serviceInstance.getIdServiceInstance());
            }
        }
    }

    @Override
    public Service registerService(String serviceId, String componentName, Map<String, String> properties) {
        Service service;
        block7: {
            service = this.getServiceById(serviceId);
            EntityTransaction tx = null;
            try {
                tx = this.em.getTransaction();
                tx.begin();
                if (service == null) {
                    Component component = this.getComponentByName(componentName);
                    if (component != null) {
                        service = new Service(serviceId, component, ProcessExecutionStateConstants.NORMAL_EXECUTION.intValue(), Boolean.valueOf(true), new Date(), null, null, null);
                        this.em.persist((Object)service);
                        ArrayList<Service> referencedServiceAsList = new ArrayList<Service>();
                        referencedServiceAsList.add(service);
                        String propValue = null;
                        Property metaDBProperty = null;
                        for (String propKey : properties.keySet()) {
                            propValue = properties.get(propKey);
                            metaDBProperty = new Property();
                            metaDBProperty.setCode(propKey);
                            metaDBProperty.setValue(propValue);
                            metaDBProperty.setServices(referencedServiceAsList);
                            this.em.persist((Object)metaDBProperty);
                        }
                        this.checkOrSaveNodeInformationForService(this.em, service);
                    } else {
                        this.log.warn("Component with name [" + componentName + "] is not registered ");
                    }
                } else {
                    this.checkOrSaveNodeInformationForService(this.em, service);
                }
                tx.commit();
            }
            catch (Throwable ex) {
                this.log.error("Error registering component: " + componentName, ex);
                if (tx == null || !tx.isActive()) break block7;
                tx.rollback();
            }
        }
        return service;
    }

    public void checkOrSaveNodeInformationForService(EntityManager em, Service service) {
        org.eclipse.ebpm.metadb.model.SpagicNode node = (org.eclipse.ebpm.metadb.model.SpagicNode)em.find(org.eclipse.ebpm.metadb.model.SpagicNode.class, (Object)SpagicNode.id());
        ArrayList<org.eclipse.ebpm.metadb.model.SpagicNode> nodesForServices = service.getSpagicNodes();
        if (nodesForServices == null) {
            nodesForServices = new ArrayList<org.eclipse.ebpm.metadb.model.SpagicNode>();
        }
        if (!nodesForServices.contains(node)) {
            nodesForServices.add(node);
        }
        em.merge((Object)service);
    }

    @Override
    public Component registerComponent(String componentName, String componentType, Map<String, String> properties) {
        Component component = null;
        EntityTransaction tx = null;
        try {
            component = this.getComponentByName(componentName);
            if (component != null) {
                return component;
            }
            tx = this.em.getTransaction();
            tx.begin();
            TypeService typeService = null;
            if (componentType.equals("CONNECTOR")) {
                typeService = (TypeService)this.em.find(TypeService.class, (Object)7L);
            } else if (componentType.equals("SERVICE")) {
                typeService = (TypeService)this.em.find(TypeService.class, (Object)8L);
            }
            component = new Component(typeService, componentName, ProcessExecutionStateConstants.NORMAL_EXECUTION.intValue(), null, null);
            this.em.persist((Object)component);
            ArrayList<Component> referencedComponentAsList = new ArrayList<Component>();
            referencedComponentAsList.add(component);
            ArrayList<Property> propertiesSet = new ArrayList<Property>(properties.size());
            String propValue = null;
            Property metaDBProperty = null;
            for (String propKey : properties.keySet()) {
                propValue = properties.get(propKey);
                metaDBProperty = new Property();
                metaDBProperty.setCode(propKey);
                metaDBProperty.setValue(propValue);
                metaDBProperty.setComponents(referencedComponentAsList);
                this.em.persist((Object)metaDBProperty);
                propertiesSet.add(metaDBProperty);
            }
            tx.commit();
            return component;
        }
        catch (Throwable ex) {
            this.log.error("Error registering component: " + componentName, ex);
            if (tx != null && tx.isActive()) {
                tx.rollback();
            }
            return component;
        }
    }

    @Override
    public void relateProcessToServiceInstance(String exchangeId, Long processId) {
        block2: {
            EntityTransaction tx = null;
            ServiceInstance serviceInstance = this.getServiceInstanceByMessageId(exchangeId);
            PropertyServiceInstance psi = new PropertyServiceInstance(serviceInstance, "PROCESS_ID", processId.toString());
            try {
                tx = this.em.getTransaction();
                tx.begin();
                this.em.persist((Object)psi);
                tx.commit();
            }
            catch (Throwable e) {
                this.log.error("Error relating process to service instance: " + exchangeId + "," + processId, e);
                if (tx == null || !tx.isActive()) break block2;
                tx.rollback();
            }
        }
    }
}

