/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ebpm.dirwatcher;

import java.io.File;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.ebpm.dirwatcher.AbstractDirectoryPoller;

public abstract class DirectoryPoller
extends AbstractDirectoryPoller {
    private HashMap<File, Long> fileLastModifiedTimeStampHolder = new HashMap();

    public DirectoryPoller(String location) {
        this(location, "");
    }

    public DirectoryPoller(String location, String filter) {
        this(new File(location), new String[]{filter});
    }

    public DirectoryPoller(String location, String[] filters) {
        this(new File(location), filters);
    }

    public DirectoryPoller(File directoryFile, String[] filters) {
        super(directoryFile, filters);
        this.createDirectoryIfNotExist(directoryFile);
        File[] filesInDirectory = this.snapshot(directoryFile, this.dfw);
        int i = 0;
        while (i < filesInDirectory.length) {
            this.fileLastModifiedTimeStampHolder.put(filesInDirectory[i], null);
            ++i;
        }
    }

    protected void checkFile(File f) {
        Long current = this.fileLastModifiedTimeStampHolder.get(f);
        if (current == null) {
            this.fileLastModifiedTimeStampHolder.put(f, new Long(f.lastModified()));
            this.fireEvent(f, "add");
        } else if (current.longValue() != f.lastModified()) {
            this.fileLastModifiedTimeStampHolder.put(f, new Long(f.lastModified()));
            this.fireEvent(f, "modify");
        }
    }

    protected void detectRemovedFiles(HashSet<File> alreadyProcessedFile) {
        Set fileListCopy = ((HashMap)this.fileLastModifiedTimeStampHolder.clone()).keySet();
        fileListCopy.removeAll(alreadyProcessedFile);
        for (File removedFile : fileListCopy) {
            this.fileLastModifiedTimeStampHolder.remove(removedFile);
            this.fireEvent(removedFile, "delete");
        }
    }

    @Override
    public final void run() {
        HashSet<File> processedFiles = new HashSet<File>();
        File[] filesInDirectory = this.snapshot(this.directory, this.dfw);
        int i = 0;
        while (i < filesInDirectory.length) {
            processedFiles.add(filesInDirectory[i]);
            this.checkFile(filesInDirectory[i]);
            ++i;
        }
        this.detectRemovedFiles(processedFiles);
    }
}

