/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ebpm.core;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Dictionary;
import java.util.concurrent.atomic.AtomicReference;
import org.eclipse.ebpm.core.ExchangeUtils;
import org.eclipse.ebpm.core.ISpagicService;
import org.eclipse.ebpm.core.routing.IMessageRouter;
import org.eclipse.ebpm.messaging.api.Exchange;
import org.eclipse.ebpm.messaging.api.Message;
import org.eclipse.ebpm.messaging.api.Pattern;
import org.eclipse.ebpm.messaging.api.Status;
import org.eclipse.ebpm.util.properties.PropertyConfigurator;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractSpagicService
implements ISpagicService,
EventHandler {
    private static Logger logger = LoggerFactory.getLogger(AbstractSpagicService.class);
    protected String spagicId = null;
    protected String target = null;
    protected PropertyConfigurator propertyConfigurator = null;
    private boolean started;
    private final AtomicReference<IMessageRouter> router = new AtomicReference<Object>(null);
    protected ComponentContext context = null;

    protected void activate(ComponentContext componentContext) {
        this.context = componentContext;
        Dictionary propertiesDictionary = componentContext.getProperties();
        this.propertyConfigurator = new PropertyConfigurator(propertiesDictionary);
        this.spagicId = this.propertyConfigurator.getString("spagic.id");
        this.target = this.propertyConfigurator.getString("target", null);
        this.init();
        try {
            this.start();
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
    }

    protected void deactivate(ComponentContext componentContext) {
        this.context = null;
        this.beforeDestroy();
        try {
            this.stop();
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public void beforeDestroy() {
    }

    @Override
    public void init() {
    }

    @Override
    public IMessageRouter getMessageRouter() {
        return this.router.get();
    }

    @Override
    public void unsetMessageRouter(IMessageRouter router) {
        this.router.compareAndSet(router, null);
    }

    @Override
    public String getSpagicId() {
        return this.spagicId;
    }

    @Override
    public void setMessageRouter(IMessageRouter router) {
        this.router.set(router);
    }

    public boolean isSpagicInternalEvent(Event event) {
        return event.getProperty("_IS_INTERNAL_EVENT") != null ? (Boolean)event.getProperty("_IS_INTERNAL_EVENT") : false;
    }

    public void handleInternalEvent(Event event) {
    }

    public void handleEvent(Event event) {
        logger.info("Service[" + this.getSpagicId() + "] -> Received Event " + event);
        if (this.isSpagicInternalEvent(event)) {
            logger.info("****** INTERNAL EVENT -> Service[" + this.getSpagicId() + "] -> Received Event " + event);
            this.handleInternalEvent(event);
            return;
        }
        Exchange exchange = ExchangeUtils.fromEvent(event);
        logger.info("Service[" + this.getSpagicId() + "] -> Received Exchange [" + exchange.getId() + "] [" + exchange.getStatus() + "]");
        try {
            this.process(exchange);
        }
        catch (Throwable e) {
            logger.error("Exception Processing Exchange ");
            logger.error(e.getMessage(), e);
        }
    }

    public void send(Exchange exchange) {
        if (!ExchangeUtils.isSync(exchange)) {
            this.asyncSend(exchange);
        }
    }

    protected void asyncSend(Exchange exchange) {
        try {
            this.getMessageRouter().send(exchange);
        }
        catch (Throwable e) {
            logger.error("Exception Sending Exchange ");
            throw new IllegalStateException(e);
        }
    }

    public void fail(Exchange exchange, Exception error) {
        this.configureForResponse(exchange);
        if (ExchangeUtils.isInOnly(exchange)) {
            exchange.setError(error);
        } else {
            Message fault = exchange.getFault(true);
            if (error.getStackTrace() != null && error.getStackTrace().length > 0) {
                fault.setBody("<error>" + this.getFullException(error) + "</error>");
            } else {
                fault.setBody("<error>" + error.getMessage() + "</error>");
            }
            exchange.setFault(fault);
        }
        this.send(exchange);
    }

    private String getFullException(Exception ex) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        ex.printStackTrace(pw);
        pw.flush();
        return sw.toString();
    }

    public void done(Exchange exchange) {
        this.configureForResponse(exchange);
        exchange.setStatus(Status.Done);
        this.send(exchange);
    }

    public void configureForResponse(Exchange exchange) {
        String originalSender = (String)exchange.getProperty("SPAGIC_SENDER");
        exchange.setProperty("SPAGIC_SENDER", (Object)this.getSpagicId());
        exchange.setProperty("SPAGIC_TARGET", (Object)originalSender);
    }

    public void configureExchangeTarget(Exchange exchange) {
        exchange.setProperty("SPAGIC_SENDER", (Object)this.getSpagicId());
        exchange.setProperty("SPAGIC_TARGET", (Object)this.target);
    }

    protected Exchange createInOnlyExchange() {
        return ExchangeUtils.createExchange(this.getSpagicId(), this.target, Pattern.InOnly);
    }

    protected Exchange createInOutExchange() {
        return ExchangeUtils.createExchange(this.getSpagicId(), this.target, Pattern.InOut);
    }

    @Override
    public boolean isStarted() throws Exception {
        return this.started;
    }

    @Override
    public boolean isStopped() throws Exception {
        return !this.started;
    }

    @Override
    public void start() throws Exception {
        this.started = true;
    }

    @Override
    public void stop() throws Exception {
        this.started = false;
    }
}

