/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ebpm.core;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.ebpm.constants.SpagicConstants;
import org.eclipse.ebpm.messaging.api.Exchange;

public class ProcessContext {
    private Exchange exchange = null;

    public ProcessContext(Exchange exchange) {
        this.exchange = exchange;
    }

    public void setVariables(Map<String, Object> variables) {
        for (String var : variables.keySet()) {
            this.setVariable(var, variables.get(var));
        }
    }

    public Map<String, Object> getVariables() {
        HashMap<String, Object> resultingVariables = new HashMap<String, Object>();
        Map exchangeProperties = this.exchange.getProperties();
        for (String exchangePropertiesKey : exchangeProperties.keySet()) {
            if (!exchangePropertiesKey.startsWith("WF_VARIABLE")) continue;
            String realWfvarName = exchangePropertiesKey.substring("WF_VARIABLE".length() + 1);
            resultingVariables.put(realWfvarName, exchangeProperties.get(exchangePropertiesKey));
        }
        return resultingVariables;
    }

    public Object getVariable(String variableName) {
        String exchangePropForVariable = "WF_VARIABLE." + variableName;
        return this.exchange.getProperty(exchangePropForVariable);
    }

    public void setVariable(String variableName, Object variableValue) {
        String exchangePropForVariable = "WF_VARIABLE." + variableName;
        this.exchange.setProperty(exchangePropForVariable, variableValue);
    }

    public Long getProcessInstanceId() {
        Long processInstanceId = (Long)this.exchange.getProperty(SpagicConstants.WF_PROCESS_INSTANCE_ID_VARIABLE);
        return processInstanceId;
    }
}

