/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ebpm.xmlutil;

import com.sun.xml.internal.stream.XMLInputFactoryImpl;
import com.sun.xml.internal.stream.XMLOutputFactoryImpl;
import java.io.File;
import java.io.IOException;
import java.io.StringReader;
import java.io.StringWriter;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import javax.xml.namespace.NamespaceContext;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.eclipse.ebpm.xmlutil.MapNamespaceContext;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class EXMLUtils {
    private static AtomicReference<DocumentBuilderFactory> documentBuilderFactory = new AtomicReference();
    private static AtomicReference<XPathFactory> xpathFactory = new AtomicReference();
    private static AtomicReference<TransformerFactory> transformerFactory = new AtomicReference();
    private static AtomicReference<XMLInputFactory> xmlInputFactory = new AtomicReference();
    private static AtomicReference<XMLOutputFactory> xmlOutputFactory = new AtomicReference();
    protected NamespaceContext namespaceContext = null;
    protected boolean namespaceaware = true;

    public boolean isNamespaceaware() {
        return this.namespaceaware;
    }

    public void setNamespaceaware(boolean namespaceaware) {
        this.namespaceaware = namespaceaware;
    }

    public EXMLUtils() {
        this(new MapNamespaceContext(), true);
    }

    public EXMLUtils(NamespaceContext namespaceContext) {
        this(namespaceContext, true);
    }

    public EXMLUtils(NamespaceContext namespaceContext, boolean namespaceaware) {
        this.namespaceContext = namespaceContext;
        this.namespaceaware = namespaceaware;
    }

    public Element selectNode(Node node, String xpath) throws XPathExpressionException {
        Node nodeResult = (Node)this.createXPath().evaluate(xpath, node, XPathConstants.NODE);
        return (Element)nodeResult;
    }

    public String valueOf(Node node, String xpath) throws XPathExpressionException {
        String value = (String)this.createXPath().evaluate(xpath, node, XPathConstants.STRING);
        return value;
    }

    public List<Element> selectNodes(Node node, String xpath) {
        NodeList nodes = null;
        try {
            nodes = (NodeList)this.createXPath().evaluate(xpath, node, XPathConstants.NODESET);
        }
        catch (XPathExpressionException e) {
            e.printStackTrace();
            return null;
        }
        ArrayList<Element> result = new ArrayList<Element>(nodes.getLength());
        int i = 0;
        while (i < nodes.getLength()) {
            result.add((Element)nodes.item(i));
            ++i;
        }
        return result;
    }

    public String asXML(Node node, boolean idented) throws TransformerException {
        Transformer transformer = this.createTransformer();
        if (idented) {
            transformer.setOutputProperty("indent", "yes");
        }
        StringWriter buffer = new StringWriter();
        transformer.transform(new DOMSource(node), new StreamResult(buffer));
        return buffer.toString();
    }

    public String asXML(Node node) throws TransformerException {
        return this.asXML(node, false);
    }

    public Document parseText(String xml) throws SAXException, IOException, ParserConfigurationException {
        DocumentBuilder builder = this.createBuilder();
        InputSource source = new InputSource(new StringReader(xml));
        Document document = builder.parse(source);
        return document;
    }

    public Document parseURL(URL url) throws SAXException, IOException, ParserConfigurationException {
        DocumentBuilder builder = this.createBuilder();
        Document document = builder.parse(url.openStream());
        return document;
    }

    public Document parseURL(File f) throws SAXException, IOException, ParserConfigurationException {
        DocumentBuilder builder = this.createBuilder();
        Document document = builder.parse(f);
        return document;
    }

    public XPath createXPath() {
        XPathFactory xpf = EXMLUtils.getXPathFactory();
        XPath xPath = xpf.newXPath();
        xPath.setNamespaceContext(this.namespaceContext);
        return xPath;
    }

    public Transformer createTransformer() throws TransformerConfigurationException {
        TransformerFactory tf = EXMLUtils.getTransformerFactory();
        return tf.newTransformer();
    }

    public DocumentBuilder createBuilder() throws ParserConfigurationException {
        DocumentBuilderFactory dbf = EXMLUtils.getDocumentBuilderFactory();
        return dbf.newDocumentBuilder();
    }

    public static XPathFactory getXPathFactory() {
        XPathFactory xpf = xpathFactory.get();
        if (xpf == null) {
            xpf = XPathFactory.newInstance();
            xpathFactory.set(xpf);
        }
        return xpathFactory.get();
    }

    public static TransformerFactory getTransformerFactory() {
        TransformerFactory tf = transformerFactory.get();
        if (tf == null) {
            tf = TransformerFactory.newInstance();
            transformerFactory.set(tf);
        }
        return transformerFactory.get();
    }

    public static DocumentBuilderFactory getDocumentBuilderFactory() {
        DocumentBuilderFactory dbf = documentBuilderFactory.get();
        if (dbf == null) {
            dbf = DocumentBuilderFactory.newInstance();
            dbf.setNamespaceAware(true);
            documentBuilderFactory.set(dbf);
        }
        return documentBuilderFactory.get();
    }

    public static XMLInputFactory getXMLInputFactory() {
        XMLInputFactory xif = xmlInputFactory.get();
        if (xif == null) {
            xif = new XMLInputFactoryImpl();
            xmlInputFactory.set(xif);
        }
        return xmlInputFactory.get();
    }

    public static XMLOutputFactory getXMLOutputFactory() {
        XMLOutputFactory xof = xmlOutputFactory.get();
        if (xof == null) {
            xof = new XMLOutputFactoryImpl();
            xmlOutputFactory.set(xof);
        }
        return xmlOutputFactory.get();
    }

    public String getText(Node node) {
        if (node.getNodeType() == 1) {
            return node.getTextContent();
        }
        return null;
    }
}

