/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ecf.osgi.services.discovery.local;

import java.util.Collection;
import org.osgi.service.discovery.ServiceEndpointDescription;

public class OneInterfaceSED {
    private static final String LINE_SEPARATOR = System.getProperty("line.separator");
    private String interfaceName = null;
    private String version = null;
    private String endpointInterface = null;

    public void addProperty(String key, Object value) {
        if (key.equals("osgi.remote.service.interfaces")) {
            this.interfaceName = (String)value;
        }
        if (key.equals("osgi.remote.endpoint.interfaces") && !((String)value).startsWith(this.interfaceName)) {
            this.endpointInterface = this.combineValue((String)value);
        }
        if (key.equals("osgi.remote.service.interfaces.version") && !((String)value).startsWith(this.interfaceName)) {
            this.version = this.combineValue((String)value);
        }
    }

    private String combineValue(String value) {
        return String.valueOf(this.interfaceName) + "|" + value;
    }

    public String getInterfaceName() {
        return this.interfaceName;
    }

    public void setInterfaceName(String interfaceName) {
        this.interfaceName = interfaceName;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public String getEndpointInterface() {
        return this.endpointInterface;
    }

    public void setEndpointInterface(String endpointInterface) {
        this.endpointInterface = endpointInterface;
    }

    public boolean equals(Object serviceDescription) {
        if (!(serviceDescription instanceof ServiceEndpointDescription)) {
            return false;
        }
        ServiceEndpointDescription descr = (ServiceEndpointDescription)serviceDescription;
        Collection descrInterfaces = descr.getProvidedInterfaces();
        if (descrInterfaces == null) {
            throw new RuntimeException("The service does not contain requiered parameter interfaces. " + descr);
        }
        if (!descrInterfaces.contains(this.interfaceName)) {
            return false;
        }
        if (this.version != null && !this.version.equals(descr.getVersion(this.interfaceName)) || this.version == null && descr.getVersion(this.interfaceName) != null) {
            return false;
        }
        return (this.endpointInterface == null || this.endpointInterface.equals(descr.getEndpointInterfaceName(this.interfaceName))) && (this.endpointInterface != null || descr.getEndpointInterfaceName(this.interfaceName) == null);
    }

    public int hashCode() {
        int result = 17;
        result = 37 * result + this.interfaceName.hashCode();
        if (this.endpointInterface != null) {
            result = 37 * result + this.endpointInterface.hashCode();
        }
        if (this.version != null) {
            result = 37 * result + this.version.hashCode();
        }
        return result;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("\tinterface=").append(this.interfaceName).append(LINE_SEPARATOR);
        if (this.version != null) {
            sb.append("\tversion=").append(this.version).append(LINE_SEPARATOR);
        }
        if (this.endpointInterface != null) {
            sb.append("\tendpointInterface=").append(this.endpointInterface).append(LINE_SEPARATOR);
        }
        return sb.toString();
    }
}

