/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.eclemma.internal.ui.dialogs;

import org.eclipse.eclemma.internal.ui.ContextHelp;
import org.eclipse.eclemma.internal.ui.EclEmmaUIPlugin;
import org.eclipse.eclemma.internal.ui.UIMessages;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.preference.BooleanFieldEditor;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.preference.FieldEditorPreferencePage;
import org.eclipse.jface.preference.StringFieldEditor;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.dialogs.PreferenceLinkArea;
import org.eclipse.ui.preferences.IWorkbenchPreferenceContainer;

public class CoveragePreferencePage
extends FieldEditorPreferencePage
implements IWorkbenchPreferencePage {
    private static final String DECORATORS_PAGE = "org.eclipse.ui.preferencePages.Decorators";
    private static final String ANNOTATIONS_PAGE = "org.eclipse.ui.editors.preferencePages.Annotations";

    public CoveragePreferencePage() {
        this.setPreferenceStore(EclEmmaUIPlugin.getInstance().getPreferenceStore());
    }

    protected Control createContents(Composite parent) {
        ContextHelp.setHelp((Control)parent, "org.eclipse.eclemma.ui.coverage_preferences_context");
        Composite result = new Composite(parent, 0);
        GridLayoutFactory.swtDefaults().margins(0, 0).applyTo(result);
        this.createSessionManagementGroup(result);
        this.createDefaultScopeGroup(result);
        this.createCoverageRuntimeGroup(result);
        this.createLink(result, UIMessages.CoveragePreferencesDecoratorsLink_label, DECORATORS_PAGE);
        this.createLink(result, UIMessages.CoveragePreferencesAnnotationsLink_label, ANNOTATIONS_PAGE);
        this.initialize();
        this.checkState();
        return result;
    }

    private void createSessionManagementGroup(Composite parent) {
        Group group = this.createGroup(parent, UIMessages.CoverageSessionManagement_titel);
        BooleanFieldEditor editor = new BooleanFieldEditor("org.eclipse.eclemma.ui.show_coverage_view", UIMessages.CoveragePreferencesShowCoverageView_label, (Composite)group);
        this.addField((FieldEditor)editor);
        editor.fillIntoGrid((Composite)group, 2);
        editor = new BooleanFieldEditor("org.eclipse.eclemma.ui.activate_new_sessions", UIMessages.CoveragePreferencesActivateNewSessions_label, (Composite)group);
        this.addField((FieldEditor)editor);
        editor.fillIntoGrid((Composite)group, 2);
        editor = new BooleanFieldEditor("org.eclipse.eclemma.ui.auto_remove_sessions", UIMessages.CoveragePreferencesAutoRemoveSessions_label, (Composite)group);
        this.addField((FieldEditor)editor);
        editor = new BooleanFieldEditor("org.eclipse.eclemma.ui.reset_on_dump", UIMessages.CoveragePreferencesResetOnDump_label, (Composite)group);
        this.addField((FieldEditor)editor);
        editor.fillIntoGrid((Composite)group, 2);
        this.adjustGroupLayout(group);
    }

    private void createDefaultScopeGroup(Composite parent) {
        Group group = this.createGroup(parent, UIMessages.CoveragePreferencesDefaultScope_title);
        BooleanFieldEditor editor = new BooleanFieldEditor("org.eclipse.eclemma.ui.default_scope_source_folders_only", UIMessages.CoveragePreferencesSourceFoldersOnly_label, (Composite)group);
        this.addField((FieldEditor)editor);
        editor.fillIntoGrid((Composite)group, 2);
        editor = new BooleanFieldEditor("org.eclipse.eclemma.ui.default_scope_same_project_only", UIMessages.CoveragePreferencesSameProjectOnly_label, (Composite)group);
        this.addField((FieldEditor)editor);
        editor.fillIntoGrid((Composite)group, 2);
        editor = new StringFieldEditor("org.eclipse.eclemma.ui.default_scope_filter", UIMessages.CoveragePreferencesClasspathFilter_label, (Composite)group);
        this.addField((FieldEditor)editor);
        editor.fillIntoGrid((Composite)group, 2);
        this.adjustGroupLayout(group);
    }

    private void createCoverageRuntimeGroup(Composite parent) {
        Group group = this.createGroup(parent, UIMessages.CoveragePreferencesCoverageRuntime_title);
        StringFieldEditor editor = new StringFieldEditor("org.eclipse.eclemma.ui.agent_includes", UIMessages.CoveragePreferencesIncludes_label, (Composite)group);
        this.addField((FieldEditor)editor);
        editor.fillIntoGrid((Composite)group, 2);
        editor = new StringFieldEditor("org.eclipse.eclemma.ui.agent_excludes", UIMessages.CoveragePreferencesExcludes_label, (Composite)group);
        this.addField((FieldEditor)editor);
        editor.fillIntoGrid((Composite)group, 2);
        editor = new StringFieldEditor("org.eclipse.eclemma.ui.agent_exclclassloader", UIMessages.CoveragePreferencesExcludeClassloaders_label, (Composite)group);
        this.addField((FieldEditor)editor);
        editor.fillIntoGrid((Composite)group, 2);
        Label hint = new Label((Composite)group, 64);
        GridDataFactory.fillDefaults().span(2, 1).applyTo((Control)hint);
        hint.setText(UIMessages.CoveragePreferencesCoverageRuntime_message);
        this.adjustGroupLayout(group);
    }

    private Group createGroup(Composite parent, String text) {
        Group group = new Group(parent, 0);
        group.setText(text);
        group.setFont(parent.getFont());
        GridDataFactory.fillDefaults().applyTo((Control)group);
        group.setLayoutData((Object)new GridData(768));
        return group;
    }

    private void adjustGroupLayout(Group group) {
        GridLayout layout = (GridLayout)group.getLayout();
        layout.marginWidth = 5;
        layout.marginHeight = 5;
    }

    private void createLink(Composite parent, String text, String target) {
        PreferenceLinkArea link = new PreferenceLinkArea(parent, 0, target, text, (IWorkbenchPreferenceContainer)this.getContainer(), null);
        link.getControl().setLayoutData((Object)new GridData());
    }

    public void init(IWorkbench workbench) {
    }

    protected void createFieldEditors() {
    }
}

