/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.edapt.declaration.merge;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EModelElement;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.edapt.common.MetamodelFactory;
import org.eclipse.emf.edapt.common.TypeUtils;
import org.eclipse.emf.edapt.declaration.EdaptConstraint;
import org.eclipse.emf.edapt.declaration.EdaptOperation;
import org.eclipse.emf.edapt.declaration.EdaptParameter;
import org.eclipse.emf.edapt.declaration.OperationImplementation;
import org.eclipse.emf.edapt.migration.Instance;
import org.eclipse.emf.edapt.migration.Metamodel;
import org.eclipse.emf.edapt.migration.Model;

@EdaptOperation(identifier="uniteReferences", label="Unite References", description="In the metamodel, a number of references are united into a single reference which obtains their common super type as type. In the model, their values have to be moved accordingly.")
public class UniteReferences
extends OperationImplementation {
    @EdaptParameter(main=true, description="The references which are united")
    public List<EReference> references;
    @EdaptParameter(description="The name of the single reference which unites all the references")
    public String unitedReferenceName;

    @EdaptConstraint(description="The references must be all either cross or containment references")
    public boolean checkReferencesSameContainment() {
        return this.hasSameValue(this.references, (EStructuralFeature)EcorePackage.Literals.EREFERENCE__CONTAINMENT);
    }

    @EdaptConstraint(description="The references have to belong to the same class")
    public boolean checkReferencesSameClass() {
        return this.hasSameValue(this.references, (EStructuralFeature)EcorePackage.eINSTANCE.getEStructuralFeature_EContainingClass());
    }

    public void execute(Metamodel metamodel, Model model) {
        EReference mainReference = this.references.get(0);
        EClass contextClass = mainReference.getEContainingClass();
        ArrayList<EClass> referenceTypes = new ArrayList<EClass>();
        for (EReference reference : this.references) {
            referenceTypes.add(reference.getEReferenceType());
            metamodel.delete((EModelElement)reference);
        }
        EClass type = TypeUtils.leastCommonAncestor(referenceTypes);
        EReference unitedReference = MetamodelFactory.newEReference((EClass)contextClass, (String)this.unitedReferenceName, (EClass)type, (int)0, (int)-1, (boolean)mainReference.isContainment());
        for (Instance contextElement : model.getAllInstances(contextClass)) {
            for (EReference reference : this.references) {
                if (reference.isMany()) {
                    List values = (List)contextElement.unset((EStructuralFeature)reference);
                    ((List)contextElement.get((EStructuralFeature)unitedReference)).addAll(values);
                    continue;
                }
                Instance value = (Instance)contextElement.unset((EStructuralFeature)reference);
                if (value == null) continue;
                contextElement.add((EStructuralFeature)unitedReference, (Object)value);
            }
        }
    }
}

