/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.edapt.migration.impl;

import java.util.Map;
import org.eclipse.emf.common.util.BasicDiagnostic;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.DiagnosticChain;
import org.eclipse.emf.ecore.EAnnotation;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.plugin.EcorePlugin;
import org.eclipse.emf.ecore.util.EObjectValidator;
import org.eclipse.emf.edapt.migration.Instance;
import org.eclipse.emf.edapt.migration.Model;
import org.eclipse.ocl.EnvironmentFactory;
import org.eclipse.ocl.OCL;
import org.eclipse.ocl.ParserException;
import org.eclipse.ocl.Query;
import org.eclipse.ocl.ecore.Constraint;
import org.eclipse.ocl.ecore.EcoreEnvironmentFactory;
import org.eclipse.ocl.expressions.OCLExpression;
import org.eclipse.ocl.helper.OCLHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ModelValidator
extends EObjectValidator {
    private static final String OCL_SOURCE_URI = "http://www.eclipse.org/ocl/examples/OCL";
    private final OCL<?, EClassifier, ?, ?, ?, ?, ?, ?, ?, Constraint, EClass, EObject> ocl = OCL.newInstance((EnvironmentFactory)EcoreEnvironmentFactory.INSTANCE);

    public ModelValidator(Model model) {
        this.ocl.setExtentMap(model.createExtentMap());
    }

    public boolean validate_EveryDefaultConstraint(EObject object, DiagnosticChain diagnostics, Map<Object, Object> context) {
        boolean result = super.validate_EveryDefaultConstraint(object, diagnostics, context);
        if (object instanceof Instance && (result || diagnostics != null)) {
            result &= this.validate_EveryInvariant((Instance)object, diagnostics, context);
        }
        return result;
    }

    private boolean validate_EveryInvariant(Instance instance, DiagnosticChain diagnostics, Map<Object, Object> context) {
        EClass eClass = instance.getEClass();
        EAnnotation annotation = eClass.getEAnnotation(OCL_SOURCE_URI);
        if (annotation != null) {
            for (Map.Entry entry : annotation.getDetails()) {
                try {
                    String expression = (String)entry.getValue();
                    if (((Boolean)this.evaluate(instance, expression)).booleanValue()) continue;
                    if (diagnostics != null) {
                        diagnostics.add((Diagnostic)new BasicDiagnostic(4, "org.eclipse.emf.ecore", 0, EcorePlugin.INSTANCE.getString("_UI_GenericConstraint_diagnostic", new Object[]{entry.getKey(), ModelValidator.getObjectLabel((EObject)((EObject)instance), context)}), new Object[]{instance}));
                    }
                    return false;
                }
                catch (ParserException e) {
                    System.out.println((Object)e);
                }
            }
        }
        return true;
    }

    private Object evaluate(Instance instance, String expression) throws ParserException {
        OCLHelper helper = this.ocl.createOCLHelper();
        helper.setContext((Object)((EObject)instance).eClass());
        OCLExpression query = helper.createQuery(expression);
        Query queryEval = this.ocl.createQuery(query);
        Object result = queryEval.evaluate((Object)instance);
        return result;
    }
}

