/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.deployment.services.internal.testserver;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.ProjectScope;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.edt.ide.core.EDTCoreIDEPlugin;
import org.eclipse.edt.ide.deployment.services.internal.testserver.ServicesContribution;
import org.eclipse.edt.ide.testserver.TestServerConfiguration;
import org.osgi.service.prefs.Preferences;

public class DDResourceChangeListener
implements IResourceChangeListener {
    private final ServicesContribution contrib;
    private final Object syncObj;
    private Map<IProject, DefaultDDPreferenceListener> listenerMap;

    public DDResourceChangeListener(ServicesContribution contrib) {
        IProject[] projects;
        this.contrib = contrib;
        this.syncObj = new Object();
        this.listenerMap = new HashMap<IProject, DefaultDDPreferenceListener>();
        IProject[] iProjectArray = projects = ResourcesPlugin.getWorkspace().getRoot().getProjects();
        int n = projects.length;
        int n2 = 0;
        while (n2 < n) {
            IProject project = iProjectArray[n2];
            if (project.isAccessible()) {
                this.addDDListener(project);
            }
            ++n2;
        }
        ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)this, 7);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        ResourcesPlugin.getWorkspace().removeResourceChangeListener((IResourceChangeListener)this);
        Object object = this.syncObj;
        synchronized (object) {
            for (DefaultDDPreferenceListener listener : this.listenerMap.values()) {
                this.removeDDListener(listener);
            }
            this.listenerMap = null;
        }
    }

    public void resourceChanged(IResourceChangeEvent event) {
        switch (event.getType()) {
            case 1: {
                if (event.getDelta() == null) break;
                IResourceDelta[] iResourceDeltaArray = event.getDelta().getAffectedChildren();
                int n = iResourceDeltaArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IResource resource;
                    IResourceDelta child = iResourceDeltaArray[n2];
                    if ((child.getFlags() & 0x4000) != 0) {
                        resource = child.getResource();
                        if (resource.getType() == 4) {
                            this.addDDListener(resource.getProject());
                        }
                    } else if (child.getKind() == 4 && (resource = child.getResource()).getType() == 4) {
                        this.addDDListener(resource.getProject());
                    }
                    ++n2;
                }
                break;
            }
            case 2: 
            case 4: {
                IResource resource = event.getResource();
                if (resource == null || resource.getType() != 4) break;
                this.removeDDListener(resource.getProject());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addDDListener(IProject project) {
        Object object = this.syncObj;
        synchronized (object) {
            if (this.listenerMap == null || this.listenerMap.containsKey(project)) {
                return;
            }
            Preferences prefs = new ProjectScope(project).getNode(EDTCoreIDEPlugin.PLUGIN_ID).node("DefaultDeploymentDescriptorPath");
            if (prefs instanceof IEclipsePreferences) {
                DefaultDDPreferenceListener listener = new DefaultDDPreferenceListener(project);
                ((IEclipsePreferences)prefs).addPreferenceChangeListener((IEclipsePreferences.IPreferenceChangeListener)listener);
                this.listenerMap.put(project, listener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeDDListener(IProject project) {
        DefaultDDPreferenceListener listener;
        Object object = this.syncObj;
        synchronized (object) {
            if (this.listenerMap == null) {
                return;
            }
            listener = this.listenerMap.remove(project);
        }
        if (listener != null) {
            this.removeDDListener(listener);
        }
    }

    private void removeDDListener(DefaultDDPreferenceListener listener) {
        Preferences prefs = new ProjectScope(listener.project).getNode(EDTCoreIDEPlugin.PLUGIN_ID).node("DefaultDeploymentDescriptorPath");
        if (prefs instanceof IEclipsePreferences) {
            ((IEclipsePreferences)prefs).removePreferenceChangeListener((IEclipsePreferences.IPreferenceChangeListener)listener);
        }
    }

    private class DefaultDDPreferenceListener
    implements IEclipsePreferences.IPreferenceChangeListener {
        private final IProject project;

        DefaultDDPreferenceListener(IProject project) {
            this.project = project;
        }

        public void preferenceChange(IEclipsePreferences.PreferenceChangeEvent event) {
            for (TestServerConfiguration config : DDResourceChangeListener.this.contrib.getRunningConfigurationsCopy()) {
                if (!config.isOnEGLPath(this.project)) continue;
                DDResourceChangeListener.this.contrib.updateDDSettingsOnServer(config);
            }
        }
    }
}

