/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.debug.internal.ui.actions;

import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.debug.internal.ui.actions.breakpoints.RulerEnableDisableBreakpointAction;
import org.eclipse.edt.compiler.core.ast.Statement;
import org.eclipse.edt.debug.internal.ui.actions.BreakpointUtils;
import org.eclipse.edt.ide.core.model.IEGLElement;
import org.eclipse.edt.ide.ui.editor.IEGLEditor;
import org.eclipse.jface.text.source.IVerticalRulerInfo;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IStorageEditorInput;
import org.eclipse.ui.texteditor.ITextEditor;

public class EGLRulerEnableDisableBreakpointAction
extends RulerEnableDisableBreakpointAction {
    public EGLRulerEnableDisableBreakpointAction(ITextEditor editor, IVerticalRulerInfo info) {
        super(editor, info);
    }

    protected IBreakpoint getBreakpoint() {
        IBreakpoint bp = super.getBreakpoint();
        if (bp == null) {
            Statement stmt;
            int line;
            ITextEditor editor = this.getEditor();
            IEGLEditor eglEditor = editor == null ? null : (IEGLEditor)editor.getAdapter(IEGLEditor.class);
            IEditorInput input = editor.getEditorInput();
            if (eglEditor != null && input instanceof IStorageEditorInput && (line = this.getVerticalRulerInfo().getLineOfLastMouseButtonActivity()) != -1 && (stmt = BreakpointUtils.getStatementNode(eglEditor, line)) != null) {
                line = eglEditor.getLineAtOffset(stmt.getOffset()) + 1;
                try {
                    String typeName;
                    IEGLElement element;
                    IStorage storage = ((IStorageEditorInput)input).getStorage();
                    if (storage instanceof IResource && (element = BreakpointUtils.getElement((IResource)storage)) != null && (typeName = BreakpointUtils.getTypeName(element)).length() > 0) {
                        IResource resource = BreakpointUtils.getResource(element);
                        bp = BreakpointUtils.eglLineBreakpointExists(resource, typeName, line);
                    }
                }
                catch (CoreException coreException) {}
            }
        }
        return bp;
    }
}

