/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.core.ast;

import org.eclipse.edt.compiler.core.ast.AbstractASTNodeVisitor;
import org.eclipse.edt.compiler.core.ast.Name;
import org.eclipse.edt.compiler.core.ast.Node;
import org.eclipse.edt.compiler.core.ast.QualifiedName;

public class GetNodeAtOffsetVisitor
extends AbstractASTNodeVisitor {
    private Node targetNode;
    private int targetOffset;
    private int targetLength;

    public GetNodeAtOffsetVisitor(int offset) {
        this.targetOffset = offset;
        this.targetLength = 0;
    }

    public GetNodeAtOffsetVisitor(int offset, int length) {
        this.targetOffset = offset;
        this.targetLength = length;
    }

    public Node getNode() {
        return this.targetNode;
    }

    protected boolean isNodeAtOffset(Node node) {
        if (node.getOffset() <= this.targetOffset && this.targetOffset < node.getOffset() + node.getLength()) {
            Name qualifier;
            this.targetNode = node;
            return !(node.getOffset() == this.targetOffset ? node.getOffset() + node.getLength() == this.targetOffset + this.targetLength && node instanceof Name : node instanceof QualifiedName && (qualifier = ((QualifiedName)node).getQualifier()).getOffset() + qualifier.getLength() + 1 == this.targetOffset && this.targetOffset + this.targetLength == node.getOffset() + node.getLength());
        }
        return false;
    }

    public boolean visitNode(Node node) {
        return this.isNodeAtOffset(node);
    }

    public void endVisitNode(Node node) {
    }
}

