/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.core.internal.dependency;

import java.util.HashMap;
import org.eclipse.core.resources.IProject;
import org.eclipse.edt.ide.core.internal.dependency.DependencyGraph;

public class DependencyGraphManager {
    private static final DependencyGraphManager INSTANCE = new DependencyGraphManager();
    private HashMap projectMap = new HashMap();

    private DependencyGraphManager() {
    }

    public static DependencyGraphManager getInstance() {
        return INSTANCE;
    }

    public DependencyGraph getDependencyGraph(IProject project) {
        DependencyGraph graph = (DependencyGraph)this.projectMap.get(project);
        if (graph == null) {
            graph = new DependencyGraph(project);
            this.projectMap.put(project, graph);
        }
        return graph;
    }

    public void clear(IProject project) {
        DependencyGraph graph = this.getDependencyGraph(project);
        if (graph != null) {
            graph.clear();
        }
    }

    public void remove(IProject project) {
        this.projectMap.remove(project);
    }

    public void clearAll() {
        this.projectMap.clear();
    }

    public int getCount() {
        return this.projectMap.size();
    }
}

