/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.core.internal.model;

import org.eclipse.edt.ide.core.internal.model.BinaryPart;
import org.eclipse.edt.ide.core.internal.model.SourceFunctionElementInfo;
import org.eclipse.edt.ide.core.model.EGLModelException;
import org.eclipse.edt.ide.core.model.IFunction;
import org.eclipse.edt.ide.core.model.IPart;

public class BinaryFunction
extends BinaryPart
implements IFunction {
    protected String[] fParameterTypes;
    protected static final String[] fgEmptyList = new String[0];

    protected BinaryFunction(IPart parent, String name, String[] parameterTypes) {
        super(10, parent, name);
        this.fParameterTypes = parameterTypes == null ? fgEmptyList : parameterTypes;
    }

    @Override
    public int getNumberOfParameters() {
        return this.fParameterTypes == null ? 0 : this.fParameterTypes.length;
    }

    @Override
    public String[] getParameterNames() throws EGLModelException {
        SourceFunctionElementInfo info = (SourceFunctionElementInfo)this.getElementInfo();
        char[][] names = info.getArgumentNames();
        if (names == null || names.length == 0) {
            return fgEmptyList;
        }
        String[] strings = new String[names.length];
        int i = 0;
        while (i < names.length) {
            strings[i] = new String(names[i]);
            ++i;
        }
        return strings;
    }

    @Override
    public String[] getParameterTypes() {
        return this.fParameterTypes;
    }

    @Override
    public String getReturnTypeName() throws EGLModelException {
        SourceFunctionElementInfo info = (SourceFunctionElementInfo)this.getElementInfo();
        return String.valueOf(info.getReturnTypeName());
    }

    @Override
    public String getSignature() throws EGLModelException {
        SourceFunctionElementInfo info = (SourceFunctionElementInfo)this.getElementInfo();
        return info.getSignature();
    }

    @Override
    public boolean isSimilar(IFunction function) {
        return false;
    }

    @Override
    public String getElementName() {
        return this.fName;
    }

    @Override
    public String[] getUseTypes() throws EGLModelException {
        SourceFunctionElementInfo info = (SourceFunctionElementInfo)this.getElementInfo();
        char[][] useTypes = info.getUseTypes();
        if (useTypes == null || useTypes.length == 0) {
            return fgEmptyList;
        }
        String[] strings = new String[useTypes.length];
        int i = 0;
        while (i < useTypes.length) {
            strings[i] = new String(useTypes[i]);
            ++i;
        }
        return strings;
    }

    @Override
    public boolean[] getNullable() throws EGLModelException {
        SourceFunctionElementInfo info = (SourceFunctionElementInfo)this.getElementInfo();
        boolean[] areNullable = info.getAreNullable();
        return areNullable;
    }

    @Override
    public String[] getParameterPackages() throws EGLModelException {
        SourceFunctionElementInfo info = (SourceFunctionElementInfo)this.getElementInfo();
        char[][] parameterPkgs = info.getArgumentPackages();
        if (parameterPkgs == null) {
            return null;
        }
        if (parameterPkgs.length == 0) {
            return fgEmptyList;
        }
        String[] strings = new String[parameterPkgs.length];
        int i = 0;
        while (i < parameterPkgs.length) {
            if (parameterPkgs[i] != null) {
                strings[i] = new String(parameterPkgs[i]);
            }
            ++i;
        }
        return strings;
    }

    @Override
    public String getReturnTypePackage() throws EGLModelException {
        SourceFunctionElementInfo info = (SourceFunctionElementInfo)this.getElementInfo();
        char[] returnTypePkgs = info.getReturnTypePkg();
        if (returnTypePkgs == null) {
            return null;
        }
        if (returnTypePkgs.length == 0) {
            return "";
        }
        String string = String.valueOf(returnTypePkgs);
        return string;
    }
}

