/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.core.internal.model;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.edt.compiler.internal.core.utils.CharOperation;
import org.eclipse.edt.ide.core.internal.model.EGLModel;
import org.eclipse.edt.ide.core.internal.model.EGLModelManager;
import org.eclipse.edt.ide.core.internal.model.PackageFragment;
import org.eclipse.edt.ide.core.internal.model.SourceRange;
import org.eclipse.edt.ide.core.internal.model.Util;
import org.eclipse.edt.ide.core.model.EGLModelException;
import org.eclipse.edt.ide.core.model.IPart;

public class SourceMapper {
    protected ArrayList rootPaths;
    protected IPath sourcePath;
    protected String rootPath = "";
    protected HashMap parameterNames;
    protected HashMap sourceRanges;
    protected HashMap categories;
    public static final SourceRange UNKNOWN_RANGE = new SourceRange(-1, 0);
    protected int[] memberDeclarationStart;
    protected SourceRange[] memberNameRange;
    protected String[] memberName;
    protected char[][][] methodParameterNames;
    protected char[][][] methodParameterTypes;
    private HashMap importsTable;
    private HashMap importsCounterTable;
    int[] typeDeclarationStarts;
    SourceRange[] typeNameRanges;
    int[] typeModifiers;
    int typeDepth;
    int anonymousCounter;
    int anonymousClassName;
    String encoding;
    Map options;
    private boolean areRootPathsComputed = false;
    public static final int FROM_ZIP = 1;
    public static final int FROM_SOURCE = 2;
    private int sourceFrom = 1;

    public SourceMapper() {
    }

    public SourceMapper(IPath sourcePath, String rootPath, Map options, int sourceFrom) {
        this(sourcePath, rootPath, options);
        this.sourceFrom = sourceFrom;
    }

    public SourceMapper(IPath sourcePath, String rootPath, Map options) {
        this.options = options;
        try {
            this.encoding = ResourcesPlugin.getWorkspace().getRoot().getDefaultCharset();
        }
        catch (CoreException coreException) {}
        if (rootPath != null) {
            this.rootPaths = new ArrayList();
            this.rootPaths.add(rootPath);
        }
        this.sourcePath = sourcePath;
        this.sourceRanges = new HashMap();
        this.parameterNames = new HashMap();
        this.importsTable = new HashMap();
        this.importsCounterTable = new HashMap();
    }

    public int getSourceFrom() {
        return this.sourceFrom;
    }

    public char[] findSource(String fullName) {
        char[] source = null;
        Object target = EGLModel.getTarget((IContainer)ResourcesPlugin.getWorkspace().getRoot(), this.sourcePath, true);
        if (target instanceof IContainer) {
            IResource res = ((IContainer)target).findMember(fullName);
            if (res instanceof IFile) {
                try {
                    source = Util.getResourceContentsAsCharArray((IFile)res);
                }
                catch (EGLModelException e) {
                    e.printStackTrace();
                }
            }
        } else if (target instanceof IFile && !this.isZipFile(target)) {
            try {
                source = Util.getResourceContentsAsCharArray((IFile)target);
            }
            catch (EGLModelException e) {
                e.printStackTrace();
            }
        } else if (target instanceof File && !this.isZipFile(target)) {
            BufferedInputStream stream = null;
            try {
                stream = new BufferedInputStream(new FileInputStream((File)target));
                source = org.eclipse.edt.ide.core.internal.model.util.Util.getInputStreamAsCharArray(stream, -1, null);
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        } else {
            ZipEntry entry = null;
            ZipFile zip = null;
            EGLModelManager manager = EGLModelManager.getEGLModelManager();
            try {
                zip = manager.getZipFile(this.sourcePath);
                entry = zip.getEntry(fullName);
                if (entry != null) {
                    source = this.readSource(entry, zip);
                }
            }
            catch (CoreException coreException) {
                manager.closeZipFile(zip);
                return null;
            }
            catch (Exception exception) {
                try {
                    manager.closeZipFile(zip);
                    return null;
                }
                catch (Throwable throwable) {
                    manager.closeZipFile(zip);
                    throw throwable;
                }
            }
            manager.closeZipFile(zip);
        }
        return source;
    }

    public char[] findSource(IPart part, String simpleSourceFileName, String[] caseSensitivePackageName) {
        char[] source;
        block8: {
            String name;
            if (caseSensitivePackageName == null) {
                PackageFragment pkgFrag = (PackageFragment)part.getPackageFragment();
                name = CharOperation.concatWith((String[])pkgFrag.names, (String)simpleSourceFileName, (char)'/');
            } else {
                name = CharOperation.concatWith((String[])caseSensitivePackageName, (String)simpleSourceFileName, (char)'/');
            }
            source = null;
            if (this.sourcePath == null) {
                return source;
            }
            EGLModelManager eglModelManager = EGLModelManager.getEGLModelManager();
            try {
                eglModelManager.cacheZipFiles(this);
                if (this.rootPath != null) {
                    source = this.getSourceForRootPath(this.rootPath, name);
                }
                if (source != null || this.rootPaths == null) break block8;
                for (String currentRootPath : this.rootPaths) {
                    if (currentRootPath.equals(this.rootPath) || (source = this.getSourceForRootPath(currentRootPath, name)) == null) continue;
                    this.rootPath = currentRootPath;
                    break;
                }
            }
            finally {
                eglModelManager.flushZipFiles(this);
            }
        }
        return source;
    }

    private char[] getSourceForRootPath(String currentRootPath, String name) {
        String newFullName = !currentRootPath.equals("") ? (currentRootPath.endsWith("/") ? String.valueOf(currentRootPath) + name : String.valueOf(currentRootPath) + '/' + name) : name;
        return this.findSource(newFullName);
    }

    private char[] readSource(ZipEntry entry, ZipFile zip) {
        try {
            byte[] bytes = Util.getZipEntryByteContent(entry, zip);
            if (bytes != null) {
                return org.eclipse.edt.ide.core.internal.model.util.Util.bytesToChar(bytes, this.encoding);
            }
        }
        catch (IOException iOException) {}
        return null;
    }

    private boolean isZipFile(Object target) {
        int index;
        File file;
        String fileName = null;
        if (target instanceof File) {
            file = (File)target;
            if (file.isFile()) {
                fileName = file.getName();
            }
        } else if (target instanceof IFile) {
            file = (IFile)target;
            fileName = file.getName();
        }
        if ((index = fileName.lastIndexOf(".")) == -1) {
            return false;
        }
        String ext = fileName.substring(index);
        return ext.equalsIgnoreCase(".zip");
    }

    public IPath getSourcePath() {
        return this.sourcePath;
    }
}

