/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.rui.actions;

import java.net.URL;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.edt.ide.rui.internal.nls.RUINlsStrings;
import org.eclipse.edt.ide.rui.utils.Util;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.program.Program;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.browser.IWebBrowser;
import org.eclipse.ui.internal.browser.WorkbenchBrowserSupport;

public class ActionLaunchDefaultBrowser
extends Action {
    protected String _strUrl;

    public ActionLaunchDefaultBrowser(String strUrl) {
        super("");
        this._strUrl = strUrl.replaceAll(" ", "%20");
    }

    public void run() {
        if (this._strUrl == null || this._strUrl.length() == 0) {
            MessageDialog.openInformation((Shell)Util.getShell(), (String)RUINlsStrings.NoWebContent_Title, (String)RUINlsStrings.NoPreviewContent_Msg);
            return;
        }
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                boolean launched;
                try {
                    IWebBrowser browser = WorkbenchBrowserSupport.getInstance().createBrowser(6, null, null, null);
                    browser.openURL(new URL(ActionLaunchDefaultBrowser.this._strUrl));
                    launched = true;
                }
                catch (Exception exception) {
                    launched = ActionLaunchDefaultBrowser.this.launchSystemBrowser(ActionLaunchDefaultBrowser.this._strUrl);
                }
                if (!launched) {
                    ErrorDialog.openError(null, (String)RUINlsStrings.NoBrowserDialog_Title, (String)RUINlsStrings.NoDefaultBrowserDialog_Msg, (IStatus)new Status(4, "org.eclipse.edt.ide.rui", RUINlsStrings.NoDefaultBrowserDialog_Msg));
                }
            }
        });
    }

    private boolean launchSystemBrowser(String url) {
        return Program.launch((String)url);
    }
}

