/*
 * Decompiled with CFR 0.152.
 */
package eglx.http;

import eglx.http.Base64;
import eglx.http.HttpMethod;
import eglx.http.Request;
import eglx.http.Response;
import eglx.lang.AnyException;
import eglx.lang.InvalidArgumentException;
import eglx.services.Encoding;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.edt.javart.services.ServiceUtilities;
import org.eclipse.edt.javart.services.servlet.ServiceInvoker;

public class HttpUtilities {
    public static final int HTTP_STATUS_FAILED = 500;
    public static final String HTTP_STATUS_MSG_FAILED = "FAILED";
    public static final int HTTP_STATUS_OK = 200;
    public static final String HTTP_STATUS_MSG_OK = "OK";
    private static final String HTTP_AUTHENTICATION_ID = "Authorization";
    private static final String HTTP_AUTHENTICATION_USER_ID = "egl_user";
    private static final String HTTP_AUTHENTICATION_PWD_ID = "egl_pwd";
    private static final String CONTENT_TYPE_VALUE_TEXT_HTML = "text/html";
    private static final String CONTENT_TYPE_VALUE_CHARSET_UTF8 = "; charset=UTF-8";
    private static final String HTTP_METHOD_GET = "GET";
    public static final String HTTP_METHOD_POST = "POST";
    public static final String HTTP_METHOD_PUT = "PUT";
    private static final String HTTP_METHOD_DELETE = "DELETE";
    public static final String HTTP_RESPONSE_TIMEOUT = "edt.proxy.invocation.timeout";
    private static final String EGL_PRIVATE_CALL = "EGLDEDICATED";
    private static final String CONTENT_TYPE_VALUE_TEXT_PLAIN = "text/plain";
    public static final String CONTENT_TEXT_KEY = "text";
    public static final String CONTENT_TYPE_KEY = "Content-Type";
    private static final String CONTENT_TYPE_VALUE_APPLICATION_JSON = "application/json";
    private static final String CONTENT_TYPE_VALUE_APPLICATION_XML = "application/xml";
    private static final String CONTENT_TYPE_VALUE_APPLICATION_FORMDATA = "application/x-www-form-urlencoded";
    static Map<String, String> contentTypes = new HashMap<String, String>();

    static {
        contentTypes.put(CONTENT_TEXT_KEY, "text/plain; charset=UTF-8");
        contentTypes.put("txt", "text/plain; charset=UTF-8");
        contentTypes.put("zip", "application/zip");
        contentTypes.put("snd", "audio/basic");
        contentTypes.put("au", "audio/basic");
        contentTypes.put("wav", "audio/x-wav");
        contentTypes.put("gif", "image/gif");
        contentTypes.put("png", "image/png");
        contentTypes.put("jpg", "image/jpeg");
        contentTypes.put("jpeg", "image/jpeg");
        contentTypes.put("css", "text/css");
        contentTypes.put("egl", "text/html; charset=UTF-8");
        contentTypes.put("htm", "text/html; charset=UTF-8");
        contentTypes.put("html", "text/html; charset=UTF-8");
    }

    private HttpUtilities() {
    }

    public static void addContentType(Response response, Encoding encoding, String charset) {
        StringBuilder contentType = new StringBuilder();
        if (Encoding._FORM == encoding) {
            contentType.append(CONTENT_TYPE_VALUE_APPLICATION_FORMDATA);
        } else if (Encoding.XML == encoding) {
            contentType.append(CONTENT_TYPE_VALUE_APPLICATION_XML);
        } else if (Encoding.JSON == encoding) {
            contentType.append(CONTENT_TYPE_VALUE_APPLICATION_JSON);
        } else {
            contentType.append(CONTENT_TYPE_VALUE_TEXT_HTML);
        }
        contentType.append("; charset=");
        if (charset == null || charset.isEmpty()) {
            charset = "UTF-8";
        }
        contentType.append(charset);
        response.addHeader(CONTENT_TYPE_KEY, contentType.toString());
    }

    public static String getContentType(String key) {
        return contentTypes.get(key);
    }

    public static void assignBody(Response response, AnyException jrte) {
    }

    static void setAuthentication(ServiceInvoker invoker, Map headers) {
        if (!HttpUtilities.setAuthenticationFromEgl(invoker, headers)) {
            HttpUtilities.setAuthenticationFromHttpAuthentication(invoker, headers);
        }
    }

    private static boolean setAuthenticationFromEgl(ServiceInvoker invoker, Map headers) {
        boolean set = false;
        String encodedUser = (String)headers.get(HTTP_AUTHENTICATION_USER_ID);
        String encodedPassword = (String)headers.get(HTTP_AUTHENTICATION_PWD_ID);
        if (encodedUser != null && encodedUser.length() > 0) {
            String user = Base64.decode(encodedUser);
            String password = Base64.decode(encodedPassword);
            invoker.setUserId(user);
            invoker.setPassword(password);
            set = true;
        }
        return set;
    }

    private static boolean setAuthenticationFromHttpAuthentication(ServiceInvoker invoker, Map headers) {
        int idx;
        boolean set = false;
        String credentials = (String)headers.get(HTTP_AUTHENTICATION_ID);
        if (credentials == null) {
            credentials = (String)headers.get(HTTP_AUTHENTICATION_ID.toLowerCase());
        }
        if (credentials != null && (idx = credentials.toLowerCase().indexOf("basic ")) > -1) {
            credentials = credentials.substring(idx + "basic ".length());
            idx = (credentials = Base64.decode(credentials)).indexOf(58);
            if (idx > -1) {
                String user = credentials.substring(0, idx);
                String password = credentials.substring(idx + 1);
                invoker.setUserId(user);
                invoker.setPassword(password);
                set = true;
            }
        }
        return set;
    }

    static void setAuthenticationFromHttpAuthentication(String user, String password, Map headers) {
        if (user != null && user.length() > 0 && password != null && password.length() > 0) {
            StringBuilder authentication = new StringBuilder(user).append(':').append(password);
            headers.put(HTTP_AUTHENTICATION_ID, "Basic " + Base64.encode(authentication.toString()));
        }
    }

    public static void validateUrl(Request restRequest) throws IOException, AnyException {
        String urlStr = restRequest.uri;
        if (urlStr == null || urlStr.trim().length() == 0) {
            InvalidArgumentException ex = new InvalidArgumentException();
            throw ex.fillInMessage("EGL0004E", new Object[]{urlStr});
        }
        if (urlStr.trim().toLowerCase().indexOf("http") == -1) {
            InvalidArgumentException ex = new InvalidArgumentException();
            throw ex.fillInMessage("EGL0002E", new Object[]{urlStr});
        }
        try {
            new URL(urlStr);
        }
        catch (MalformedURLException mfue) {
            InvalidArgumentException ex = new InvalidArgumentException();
            throw ex.fillInMessage("EGL0003E", new Object[]{urlStr, ServiceUtilities.getMessage(mfue)});
        }
    }

    static String urlEncode(Map<String, String> parameters, boolean isQueryParameters) throws UnsupportedEncodingException {
        if (parameters.size() == 0) {
            return "";
        }
        StringBuilder retVal = new StringBuilder();
        if (isQueryParameters) {
            retVal.append('?');
        }
        Iterator<String> iter = parameters.keySet().iterator();
        while (iter.hasNext()) {
            String key = URLEncoder.encode(iter.next(), ServiceUtilities.UTF8);
            String value = URLEncoder.encode(parameters.get(key), ServiceUtilities.UTF8);
            retVal.append(key);
            retVal.append('=');
            retVal.append(value);
            if (!iter.hasNext()) continue;
            retVal.append('&');
        }
        return retVal.toString();
    }

    static String unescape(String msg) {
        try {
            return URLDecoder.decode(msg, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            return msg;
        }
    }

    public static String httpMethodToString(HttpMethod method) {
        if (HttpMethod._DELETE.equals((Object)method)) {
            return HTTP_METHOD_DELETE;
        }
        if (HttpMethod._GET.equals((Object)method)) {
            return HTTP_METHOD_GET;
        }
        if (HttpMethod.POST.equals((Object)method)) {
            return HTTP_METHOD_POST;
        }
        if (HttpMethod.PUT.equals((Object)method)) {
            return HTTP_METHOD_PUT;
        }
        return "";
    }

    public static HttpMethod convert(String method) {
        if (HTTP_METHOD_DELETE.equalsIgnoreCase(method)) {
            return HttpMethod._DELETE;
        }
        if (HTTP_METHOD_GET.equalsIgnoreCase(method)) {
            return HttpMethod._GET;
        }
        if (HTTP_METHOD_POST.equalsIgnoreCase(method)) {
            return HttpMethod.POST;
        }
        if (HTTP_METHOD_PUT.equalsIgnoreCase(method)) {
            return HttpMethod.PUT;
        }
        return null;
    }

    public static HttpMethod convert(int method) {
        if (HttpMethod._DELETE.getValue() == method) {
            return HttpMethod._DELETE;
        }
        if (HttpMethod._GET.getValue() == method) {
            return HttpMethod._GET;
        }
        if (HttpMethod.POST.getValue() == method) {
            return HttpMethod.POST;
        }
        if (HttpMethod.PUT.getValue() == method) {
            return HttpMethod.PUT;
        }
        return null;
    }
}

