/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.gen.eunit;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.eclipse.edt.gen.eunit.XMLPrintHandler;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.helpers.DefaultHandler;

public class GenPartsXMLFile {
    Document doc;
    private File file;
    private static String ELEMENT_TAR_FOLDER = "partsGroup";
    private static String ELEMENT_PART = "part";
    private static String ATTR_PART_NAME = "name";

    public GenPartsXMLFile(String fullPath) {
        this.setPath(fullPath);
        this.initialize();
    }

    private void setPath(String filePath) {
        this.file = new File(filePath);
        if (!this.file.exists()) {
            try {
                this.file.createNewFile();
            }
            catch (IOException e) {
                System.out.println("GenPartsXMLFile::setPath(), IOException");
                e.printStackTrace();
            }
        }
    }

    private void initialize() {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        try {
            this.doc = factory.newDocumentBuilder().newDocument();
        }
        catch (ParserConfigurationException e) {
            System.out.println("GenPartsXMLFile::initialize(), ParserConfigurationException");
            e.printStackTrace();
        }
    }

    public void saveGenerationEntries(String targetFolder, List<String> entries) throws IOException {
        if (entries == null || entries.isEmpty()) {
            return;
        }
        Element root = this.doc.createElement(ELEMENT_TAR_FOLDER);
        for (String entry : entries) {
            Element element = this.doc.createElement(ELEMENT_PART);
            element.setAttribute(ATTR_PART_NAME, entry);
            root.appendChild(element);
        }
        this.doc.appendChild(root);
        XMLPrintHandler.writeFile(this.doc, this.file);
    }

    public List<String> getGenerationEntries() {
        ArrayList<String> entries = new ArrayList<String>();
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder documentBuilder = factory.newDocumentBuilder();
            documentBuilder.setErrorHandler(new DefaultHandler());
            this.doc = documentBuilder.parse(this.file);
            Element root = this.doc.getDocumentElement();
            if (root != null) {
                NodeList list = root.getChildNodes();
                int i = 0;
                while (i < list.getLength()) {
                    Element xmlEntry;
                    if (list.item(i).getNodeType() == 1 && (xmlEntry = (Element)list.item(i)).hasAttribute(ATTR_PART_NAME)) {
                        entries.add(xmlEntry.getAttribute(ATTR_PART_NAME));
                    }
                    ++i;
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return entries;
    }
}

