/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.testserver;

import java.util.ArrayList;
import java.util.HashMap;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugException;
import org.eclipse.edt.ide.internal.testserver.UpdateErrorDialog;
import org.eclipse.edt.ide.testserver.ClasspathUtil;
import org.eclipse.edt.ide.testserver.TestServerConfiguration;
import org.eclipse.edt.ide.testserver.TestServerMessages;
import org.eclipse.edt.ide.testserver.TestServerPlugin;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class TestServerManager
implements TestServerConfiguration.TerminationListener,
IResourceChangeListener {
    private static TestServerManager INSTANCE;
    private final Object syncObj = new Object();
    private final HashMap<IProject, TestServerConfiguration> serverConfigMap = new HashMap();

    public static synchronized TestServerManager getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new TestServerManager();
        }
        return INSTANCE;
    }

    private TestServerManager() {
        ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)this, 7);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reset() {
        Object object = this.syncObj;
        synchronized (object) {
            for (TestServerConfiguration config : this.serverConfigMap.values()) {
                try {
                    config.terminate();
                }
                catch (DebugException debugException) {}
            }
            this.serverConfigMap.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TestServerConfiguration getServerConfiguration(IProject project, boolean debugMode) {
        Object object = this.syncObj;
        synchronized (object) {
            TestServerConfiguration config = this.serverConfigMap.get(project);
            if (config == null) {
                config = new TestServerConfiguration(project, debugMode);
                config.addTerminationListener(this);
                this.serverConfigMap.put(project, config);
            }
            return config;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TestServerConfiguration lookupConfiguration(IProject project) {
        Object object = this.syncObj;
        synchronized (object) {
            return this.serverConfigMap.get(project);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeServerConfiguration(IProject project) {
        Object object = this.syncObj;
        synchronized (object) {
            this.serverConfigMap.remove(project);
        }
    }

    @Override
    public void terminated(TestServerConfiguration config) {
        this.removeServerConfiguration(config.getProject());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resourceChanged(IResourceChangeEvent event) {
        switch (event.getType()) {
            case 1: {
                class CheckClasspath
                extends RuntimeException {
                    private static final long serialVersionUID = 1L;

                    CheckClasspath() {
                    }
                }
                int mapSize;
                if (event.getDelta() == null) break;
                Object object = this.syncObj;
                synchronized (object) {
                    mapSize = this.serverConfigMap.size();
                }
                if (mapSize <= 0) break;
                try {
                    event.getDelta().accept(new IResourceDeltaVisitor(){

                        public boolean visit(IResourceDelta delta) throws CoreException {
                            if (delta == null) {
                                return false;
                            }
                            switch (delta.getKind()) {
                                case 4: {
                                    if ((delta.getFlags() & 0x100) == 0 && (delta.getFlags() & 0x100000) == 0) {
                                        return true;
                                    }
                                }
                                case 1: 
                                case 2: {
                                    if (!ClasspathUtil.canAffectClasspath(delta.getFullPath().lastSegment())) break;
                                    throw new CheckClasspath();
                                }
                            }
                            return true;
                        }
                    });
                }
                catch (CoreException ce) {
                    TestServerPlugin.getDefault().log(ce.getMessage(), (Exception)((Object)ce));
                }
                catch (CheckClasspath checkClasspath) {
                    this.handleClasspathChanged();
                }
                break;
            }
            case 2: 
            case 4: {
                IResource resource = event.getResource();
                if (resource == null || resource.getType() != 4) break;
                TestServerConfiguration config = null;
                Object object = this.syncObj;
                synchronized (object) {
                    config = this.serverConfigMap.remove(resource);
                }
                if (config == null) break;
                try {
                    config.terminate();
                }
                catch (DebugException debugException) {}
                config.dispose();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleClasspathChanged() {
        HashMap mapClone;
        final ArrayList<TestServerConfiguration> configsWithChanges = new ArrayList<TestServerConfiguration>();
        Object object = this.syncObj;
        synchronized (object) {
            mapClone = (HashMap)this.serverConfigMap.clone();
        }
        if (mapClone != null) {
            for (final TestServerConfiguration config : mapClone.values()) {
                if (!config.hasClasspathChanged()) continue;
                configsWithChanges.add(config);
            }
        }
        if (configsWithChanges.size() > 0) {
            switch (TestServerPlugin.getDefault().getPreferenceStore().getInt("org.eclipse.edt.ide.testserver.ClasspathChanged")) {
                case 2: {
                    break;
                }
                case 1: {
                    for (final TestServerConfiguration config : configsWithChanges) {
                        try {
                            config.terminate();
                        }
                        catch (DebugException e) {
                            Display display = TestServerPlugin.getDisplay();
                            display.asyncExec(new Runnable(){

                                @Override
                                public void run() {
                                    ErrorDialog.openError((Shell)TestServerPlugin.getShell(), (String)TestServerMessages.TerminateFailedTitle, (String)NLS.bind((String)TestServerMessages.TerminateFailedMsg, (Object)config.getProject().getName()), (IStatus)e.getStatus());
                                }
                            });
                        }
                    }
                    break;
                }
                default: {
                    final Display display = TestServerPlugin.getDisplay();
                    display.asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            if (display.isDisposed()) {
                                return;
                            }
                            StringBuilder projectsInsert = new StringBuilder(20 * configsWithChanges.size());
                            for (TestServerConfiguration config : configsWithChanges) {
                                if (projectsInsert.length() != 0) {
                                    projectsInsert.append('\n');
                                }
                                projectsInsert.append(config.getProject().getName());
                            }
                            UpdateErrorDialog dialog = new UpdateErrorDialog(TestServerPlugin.getShell(), TestServerMessages.ClasspathChangedTitle, null, (IStatus)new Status(2, "org.eclipse.edt.ide.testserver", String.valueOf(NLS.bind((String)TestServerMessages.ClasspathChangedMsg, (Object)projectsInsert)) + "\n\n" + (configsWithChanges.size() > 1 ? TestServerMessages.ErrorDialogTerminatePluralMsg : TestServerMessages.ErrorDialogTerminateMsg)), TestServerPlugin.getDefault().getPreferenceStore(), "org.eclipse.edt.ide.testserver.ClasspathChanged", configsWithChanges.toArray(new TestServerConfiguration[configsWithChanges.size()]));
                            dialog.open();
                        }
                    });
                }
            }
        }
    }
}

