/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.ui.internal.contentassist;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.edt.ide.core.internal.errors.ParseNode;
import org.eclipse.edt.ide.core.internal.errors.ParseStack;
import org.eclipse.edt.ide.core.internal.errors.TerminalNode;
import org.eclipse.edt.ide.core.internal.errors.TokenStream;
import org.eclipse.edt.ide.ui.internal.UINlsStrings;
import org.eclipse.edt.ide.ui.internal.contentassist.EGLCompletionProposal;
import org.eclipse.jface.text.ITextViewer;

public class EGLKeywordCompletion {
    private int terminalType;
    private String keyword;

    public EGLKeywordCompletion(int terminalType, String keyword) {
        this.terminalType = terminalType;
        this.keyword = keyword;
    }

    public List computeCompletionProposals(ParseStack parseStack, List prefixNodes, ITextViewer viewer, int documentOffset, boolean loose) {
        ArrayList<EGLCompletionProposal> result = new ArrayList<EGLCompletionProposal>();
        int i = 0;
        while (i < prefixNodes.size() - 1) {
            ParseNode node = (ParseNode)prefixNodes.get(i);
            if (node.isNonTerminal() || !node.isWhiteSpace()) {
                return result;
            }
            ++i;
        }
        String prefix = "";
        if (prefixNodes.size() > 0) {
            TerminalNode prefixNode = (TerminalNode)prefixNodes.get(prefixNodes.size() - 1);
            if (TokenStream.isExtensibleTerminal((int)prefixNode.terminalType)) {
                prefix = prefixNode.getText();
                if (this.isKeywordAllowed(this.terminalType, parseStack) && this.keyword.equals("PRIMITIVE")) {
                    return result;
                }
                if (!this.keyword.toUpperCase().startsWith(prefix.toUpperCase())) {
                    return result;
                }
            }
        }
        if (!this.isKeywordAllowed(this.terminalType, parseStack)) {
            return result;
        }
        if (!this.keyword.equals("PRIMITIVE")) {
            result.add(new EGLCompletionProposal(viewer, null, this.keyword, UINlsStrings.CAProposal_EGLKeyword, documentOffset - prefix.length(), prefix.length(), this.keyword.length(), 70, ""));
        }
        return result;
    }

    private boolean isKeywordAllowed(int type, ParseStack parseStack) {
        return parseStack.isTerminalShiftable(type);
    }
}

