/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.ui.internal.deployment.ui;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.edt.ide.ui.internal.IUIHelpConstants;
import org.eclipse.edt.ide.ui.internal.deployment.DeploymentFactory;
import org.eclipse.edt.ide.ui.internal.deployment.DeploymentProject;
import org.eclipse.edt.ide.ui.internal.deployment.DeploymentTarget;
import org.eclipse.edt.ide.ui.internal.deployment.EGLDeploymentRoot;
import org.eclipse.edt.ide.ui.internal.deployment.ui.EGLDDBaseFormPage;
import org.eclipse.edt.ide.ui.internal.deployment.ui.EGLDDBindingBlock;
import org.eclipse.edt.ide.ui.internal.deployment.ui.EGLDDImportsFormPage;
import org.eclipse.edt.ide.ui.internal.deployment.ui.EGLDDRootHelper;
import org.eclipse.edt.ide.ui.internal.deployment.ui.EGLDDWebServicesBlock;
import org.eclipse.edt.ide.ui.internal.deployment.ui.EGLDeploymentDescriptorEditor;
import org.eclipse.edt.ide.ui.internal.deployment.ui.IEGLDDContributionPageProvider;
import org.eclipse.edt.ide.ui.internal.deployment.ui.SOAMessages;
import org.eclipse.edt.ide.ui.internal.wizards.CopyEGLDDWizard;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.jst.j2ee.project.JavaEEProjectUtilities;
import org.eclipse.jst.j2ee.project.facet.IJ2EEFacetConstants;
import org.eclipse.jst.servlet.ui.project.facet.WebProjectFirstPage;
import org.eclipse.jst.servlet.ui.project.facet.WebProjectWizard;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.editor.FormEditor;
import org.eclipse.ui.forms.editor.IFormPage;
import org.eclipse.ui.forms.widgets.FormText;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ScrolledForm;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.wst.common.project.facet.core.runtime.IRuntime;

public class EGLDDOverviewFormPage
extends EGLDDBaseFormPage {
    private Combo fTargetCombo;
    private Button fTargetButton;
    private TableViewer fClientBindingsTV;
    private TableViewer fWSTV;
    private Button browseBtn;
    private Button clearBtn;
    private Label fTargetProjectText;
    private TableViewer fImportsTV;
    private List contributedTableViewers = new ArrayList();
    private boolean fProjectSelected = false;
    private static final String VALIDATION_KEY_TARGET = "target";
    private static final Integer VALIDATION_KEY_RUNTIME = 999;

    public EGLDDOverviewFormPage(FormEditor editor, String id, String title) {
        super(editor, id, title);
    }

    public void setActive(boolean active) {
        super.setActive(active);
        if (active) {
            this.refreshTables();
        }
    }

    private void refreshTables() {
        this.fClientBindingsTV.refresh();
        this.fWSTV.refresh();
        this.fImportsTV.refresh();
        int size = this.contributedTableViewers.size();
        int i = 0;
        while (i < size) {
            ((TableViewer)this.contributedTableViewers.get(i)).refresh();
            ++i;
        }
    }

    @Override
    protected void createFormContent(IManagedForm managedForm) {
        super.createFormContent(managedForm);
        ScrolledForm form = managedForm.getForm();
        FormToolkit toolkit = managedForm.getToolkit();
        form.setText(SOAMessages.OverviewFormTitle);
        EGLDeploymentRoot eglDDRoot = this.getModelRoot();
        managedForm.setInput((Object)eglDDRoot);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        form.getBody().setLayout((Layout)layout);
        this.createEGLDDSection(form, toolkit, eglDDRoot);
        this.createTargetSection(form, toolkit, SOAMessages.TargetsMainSectionTitle, SOAMessages.TargetsMainSectionDesc);
        this.addTableContributions(form, toolkit);
        this.fWSTV = this.createTableSection(form, toolkit, SOAMessages.WSMainSectionTitle, SOAMessages.WSMainSectionDescription, (IContentProvider)new EGLDDWebServicesBlock.WSListContentProvider(), (IBaseLabelProvider)new EGLDDWebServicesBlock.WSListLabelProvider(), eglDDRoot, "page.eglbind.webservices", IUIHelpConstants.EGLDD_EDITOR_OVERVIEWPAGE_WS);
        this.fClientBindingsTV = this.createBindingTableSection(form, toolkit, SOAMessages.BindingMainSectionTitle, SOAMessages.BindingMainSectionDescription, (IContentProvider)new EGLDDBindingBlock.ServiceBindingContentProvider(), (IBaseLabelProvider)new EGLDDBindingBlock.ServiceBindingLabelProvider(), eglDDRoot, "page.eglbind.bindings", IUIHelpConstants.EGLDD_EDITOR_OVERVIEWPAGE_SERVICEBINDINGS);
        this.fImportsTV = this.createTableSection(form, toolkit, SOAMessages.ImportsSectionTitle, SOAMessages.ImportsSectionDescription, (IContentProvider)new EGLDDImportsFormPage.IncludeListContentProvider(), (IBaseLabelProvider)new EGLDDImportsFormPage.IncludeListLabelProvider(), eglDDRoot, "page.eglbind.imports", IUIHelpConstants.EGLDD_EDITOR_OVERVIEWPAGE_IMPORTS);
        managedForm.reflow(true);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)form.getBody(), this.getHelpID());
    }

    private void addTableContributions(ScrolledForm form, FormToolkit toolkit) {
        EGLDeploymentRoot eglDDRoot = this.getModelRoot();
        IEGLDDContributionPageProvider[] providers = EGLDeploymentDescriptorEditor.getEditorProviders();
        int i = 0;
        while (i < providers.length) {
            Table table;
            Composite client = EGLDDBaseFormPage.createExpandableSection(form, toolkit, providers[i].getOverviewTitle(), providers[i].getOverviewDescription(), 2, 1, true);
            if (client != null && (table = providers[i].createTable(client, toolkit)) != null) {
                this.contributedTableViewers.add(this.createTableSection(form, toolkit, providers[i].getOverviewTitle(), providers[i].getOverviewDescription(), client, table, providers[i].getTableContentProvider(this.getEditorProject()), (IBaseLabelProvider)providers[i].getTableLabelProvider(), eglDDRoot, providers[i].getDetailPageId(), providers[i].getHelpId()));
            }
            ++i;
        }
    }

    private void createEGLDDSection(ScrolledForm form, FormToolkit toolkit, EGLDeploymentRoot serviceBindingRoot) {
        String sectionTitle = SOAMessages.EGLDDSectionTitle;
        IEditorInput editorInput = this.getEditorInput();
        if (editorInput instanceof FileEditorInput) {
            FileEditorInput fileinput = (FileEditorInput)editorInput;
            String fullName = fileinput.getFile().getName();
            String name = fullName.substring(0, fullName.indexOf(46));
            sectionTitle = String.valueOf(sectionTitle) + " - " + name;
        }
        Composite client = EGLDDOverviewFormPage.createNonExpandableSectionWithoutDesc(form, toolkit, sectionTitle, 4);
        FormText text = toolkit.createFormText(client, false);
        text.setText(SOAMessages.OverviewInformationalMessage, true, false);
        GridData gd = new GridData();
        gd.horizontalSpan = 4;
        text.setLayoutData((Object)gd);
        gd = new GridData();
        gd.horizontalSpan = 4;
        toolkit.createLabel(client, "").setLayoutData((Object)gd);
        toolkit.paintBordersFor(client);
    }

    private void createTargetSection(ScrolledForm form, FormToolkit toolkit, String title, String description) {
        Composite client = EGLDDOverviewFormPage.createExpandableSection(form, toolkit, title, description, 1, 1, true);
        this.createTargetSection(toolkit, client);
    }

    private void createTargetSection(FormToolkit toolkit, Composite client) {
        GridData gd = new GridData(1808);
        gd.heightHint = 200;
        gd.widthHint = 100;
        Group grp = new Group(client, 0);
        toolkit.adapt((Composite)grp);
        GridLayout g1 = new GridLayout(4, false);
        grp.setLayout((Layout)g1);
        grp.setLayoutData((Object)gd);
        this.fTargetProjectText = toolkit.createLabel((Composite)grp, SOAMessages.TargetWebProjectLabel);
        this.fTargetCombo = new Combo((Composite)grp, 2056);
        gd = new GridData(768);
        gd.widthHint = 200;
        this.fTargetCombo.setLayoutData((Object)gd);
        this.fTargetCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                String project = EGLDDOverviewFormPage.this.fTargetCombo.getItems()[EGLDDOverviewFormPage.this.fTargetCombo.getSelectionIndex()].trim();
                if (project.length() == 0) {
                    EGLDDRootHelper.removeTarget(EGLDDOverviewFormPage.this.getModelRoot());
                    EGLDDOverviewFormPage.this.projectDeselected();
                } else {
                    DeploymentProject target = DeploymentFactory.eINSTANCE.createDeploymentProject();
                    target.setName(project);
                    EGLDDRootHelper.setTarget((DeploymentTarget)target, EGLDDOverviewFormPage.this.getModelRoot());
                    EGLDDOverviewFormPage.this.projectSelected();
                }
            }
        });
        this.fTargetButton = toolkit.createButton((Composite)grp, SOAMessages.NewLabel, 8);
        gd = new GridData();
        gd.horizontalAlignment = 4;
        this.fTargetButton.setLayoutData((Object)gd);
        this.fTargetButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                WebProjectWizard wizard = new WebProjectWizard(){

                    protected IWizardPage createFirstPage() {
                        this.model.setProperty("IJ2EEFacetProjectCreationDataModelProperties.ADD_TO_EAR", (Object)Boolean.FALSE);
                        this.model.setProperty("IJ2EEFacetProjectCreationDataModelProperties.EAR_PROJECT_NAME", (Object)"");
                        WebProjectFirstPage page = new WebProjectFirstPage(this.model, "first.page"){

                            protected void validatePage(boolean showMessage) {
                                this.setOKStatus(VALIDATION_KEY_RUNTIME);
                                if (showMessage) {
                                    Object runtime = this.model.getProperty("IFacetProjectCreationDataModelProperties.FACET_RUNTIME");
                                    if (this.serverTargetCombo.isEnabled() && !(runtime instanceof IRuntime)) {
                                        this.setErrorStatus(VALIDATION_KEY_RUNTIME, SOAMessages.NewWebProjectNoRuntimeError);
                                    }
                                    if (runtime instanceof IRuntime && ((IRuntime)runtime).supports(IJ2EEFacetConstants.ENTERPRISE_APPLICATION_FACET) && !this.model.getBooleanProperty("IJ2EEFacetProjectCreationDataModelProperties.ADD_TO_EAR")) {
                                        this.setErrorStatus(VALIDATION_KEY_RUNTIME, SOAMessages.NewWebProjectNoEARWarning);
                                    }
                                }
                                super.validatePage(showMessage);
                            }

                            protected Composite createTopLevelComposite(Composite parent) {
                                Composite composite = super.createTopLevelComposite(parent);
                                if (this.earPanel != null) {
                                    this.projectNameGroup.projectNameField.addModifyListener(new ModifyListener(){

                                        public void modifyText(ModifyEvent e) {
                                            model.setProperty("IJ2EEFacetProjectCreationDataModelProperties.EAR_PROJECT_NAME", (Object)(String.valueOf(((Text)e.widget).getText()) + "EAR"));
                                        }
                                    });
                                }
                                return composite;
                            }
                        };
                        return page;
                    }

                    protected String getFinalPerspectiveID() {
                        return null;
                    }
                };
                WizardDialog dialog = new WizardDialog(EGLDDOverviewFormPage.this.getEditorSite().getShell(), (IWizard)wizard);
                dialog.create();
                if (dialog.open() == 0) {
                    DeploymentProject project = DeploymentFactory.eINSTANCE.createDeploymentProject();
                    project.setName(wizard.getProjectName());
                    EGLDDRootHelper.setTarget((DeploymentTarget)project, EGLDDOverviewFormPage.this.getModelRoot());
                    EGLDDOverviewFormPage.this.initTargets();
                }
            }
        });
        Label spacer = toolkit.createLabel((Composite)grp, "");
        gd = new GridData(512);
        spacer.setLayoutData((Object)gd);
        this.projectDeselected();
        this.initTargets();
    }

    private void projectSelected() {
        this.fProjectSelected = true;
    }

    private void projectDeselected() {
        this.fProjectSelected = false;
    }

    public void initTargets() {
        DeploymentTarget target = EGLDDRootHelper.getDeploymentTarget(this.getModelRoot());
        IProject[] iprojects = ResourcesPlugin.getWorkspace().getRoot().getProjects();
        ArrayList<String> webProjects = new ArrayList<String>(iprojects.length);
        webProjects.add("");
        int i = 0;
        while (i < iprojects.length) {
            if (JavaEEProjectUtilities.isDynamicWebProject((IProject)iprojects[i])) {
                webProjects.add(iprojects[i].getName());
            }
            ++i;
        }
        String[] projectArray = webProjects.toArray(new String[webProjects.size()]);
        this.fTargetCombo.setItems(projectArray);
        if (target instanceof DeploymentProject) {
            String projectToSelect = ((DeploymentProject)target).getName();
            if (webProjects.size() > 0) {
                int selectIndex = 0;
                if (projectToSelect != null) {
                    int i2 = 0;
                    while (i2 < projectArray.length) {
                        if (projectToSelect.equals(projectArray[i2])) {
                            selectIndex = i2;
                            break;
                        }
                        ++i2;
                    }
                }
                this.fTargetCombo.select(selectIndex);
                if (selectIndex > 0) {
                    this.projectSelected();
                }
            }
        }
    }

    protected void CopyFromAnotherEGLDD() {
        CopyEGLDDWizard wizard = new CopyEGLDDWizard();
        EGLDeploymentDescriptorEditor eglDDEditor = (EGLDeploymentDescriptorEditor)this.getEditor();
        wizard.init(this.getModelRoot(), ((IFileEditorInput)this.getEditorInput()).getFile(), eglDDEditor.getProject());
        this.openWizard((IWizard)wizard);
        this.refreshTables();
    }

    private TableViewer createTableSection(ScrolledForm form, FormToolkit toolkit, String title, String description, IContentProvider contentProvider, IBaseLabelProvider labelProvider, Object input, String detailPageId, String helpId) {
        Composite client = EGLDDOverviewFormPage.createExpandableSection(form, toolkit, title, description, 2, 1, true);
        Table t = toolkit.createTable(client, 0);
        return this.createTableSection(form, toolkit, title, description, client, t, contentProvider, labelProvider, input, detailPageId, helpId);
    }

    private TableViewer createBindingTableSection(ScrolledForm form, FormToolkit toolkit, String title, String description, IContentProvider contentProvider, IBaseLabelProvider labelProvider, Object input, String detailPageId, String helpId) {
        Composite client = EGLDDOverviewFormPage.createExpandableSection(form, toolkit, title, description, 2, 1, true);
        Table t = EGLDDBindingBlock.createTableControl(toolkit, client);
        return this.createTableSection(form, toolkit, title, description, client, t, contentProvider, labelProvider, input, detailPageId, helpId);
    }

    private TableViewer createTableSection(ScrolledForm form, FormToolkit toolkit, String title, String description, Composite client, Table t, IContentProvider contentProvider, IBaseLabelProvider labelProvider, Object input, final String detailPageId, String helpId) {
        GridData gd = new GridData(1808);
        gd.heightHint = 200;
        gd.widthHint = 100;
        t.setLayoutData((Object)gd);
        toolkit.paintBordersFor(client);
        final TableViewer tableviewer = new TableViewer(t);
        if (contentProvider != null) {
            tableviewer.setContentProvider(contentProvider);
        }
        if (labelProvider != null) {
            tableviewer.setLabelProvider(labelProvider);
        }
        tableviewer.setSorter(new ViewerSorter());
        tableviewer.setInput(input);
        t.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetDefaultSelected(SelectionEvent e) {
                EGLDDOverviewFormPage.this.selectAndRevealDetail(detailPageId, tableviewer);
            }
        });
        Button b = toolkit.createButton(client, SOAMessages.DetailLabel, 8);
        gd = new GridData(2);
        b.setLayoutData((Object)gd);
        b.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                EGLDDOverviewFormPage.this.selectAndRevealDetail(detailPageId, tableviewer);
            }
        });
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)client, helpId);
        return tableviewer;
    }

    private void selectAndRevealDetail(String detailPageId, TableViewer tableviewer) {
        IFormPage activePage = this.getEditor().setActivePage(detailPageId);
        ISelection sel = tableviewer.getSelection();
        if (!sel.isEmpty() && activePage instanceof EGLDDBaseFormPage) {
            EGLDDBaseFormPage basePage = (EGLDDBaseFormPage)activePage;
            basePage.selectReveal(sel);
        }
    }

    public void setFocus() {
        if (this.fTargetCombo != null) {
            this.fTargetCombo.setFocus();
        }
    }

    @Override
    protected String getHelpID() {
        return IUIHelpConstants.EGLDD_EDITOR_OVERVIEWPAGE;
    }
}

