/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.ui.internal.deployment.ui;

import org.eclipse.edt.ide.core.model.IPart;
import org.eclipse.edt.ide.ui.internal.PluginImages;
import org.eclipse.edt.ide.ui.internal.deployment.Binding;
import org.eclipse.edt.ide.ui.internal.deployment.ui.EGLDDBindingBaseDetailPage;
import org.eclipse.edt.ide.ui.internal.deployment.ui.EGLDDBindingFormPage;
import org.eclipse.edt.ide.ui.internal.deployment.ui.EGLDeploymentDescriptorEditor;
import org.eclipse.edt.ide.ui.internal.deployment.ui.SOAMessages;
import org.eclipse.edt.ide.ui.internal.dialogs.EGLPartSelectionDialog;
import org.eclipse.edt.ide.ui.internal.dialogs.PartSelectionDialog;
import org.eclipse.edt.ide.ui.internal.wizards.NewWizardMessages;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.forms.IDetailsPage;
import org.eclipse.ui.forms.IFormPart;
import org.eclipse.ui.forms.editor.FormPage;
import org.eclipse.ui.forms.events.HyperlinkAdapter;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ImageHyperlink;

public class WebBindingDetailPage
extends EGLDDBindingBaseDetailPage
implements IDetailsPage {
    protected Text fInterfaceOrService;
    private Binding fWebBinding;
    private Text fWSDLFileLocation;
    private Text fWSDLPort;
    private Text fWSDLService;
    private Text fWSDLUri;
    protected Button fGenBtn;

    public WebBindingDetailPage() {
        this.nColumnSpan = 3;
    }

    @Override
    protected Composite createDetailSection(Composite parent, FormToolkit toolkit, int sectionStyle, int columnSpan) {
        return this.createSection(parent, toolkit, SOAMessages.WebBindingDetailSectionTitle, SOAMessages.WebBindingDetailSectionDescription, sectionStyle, columnSpan);
    }

    @Override
    protected void createControlsInTopSection(FormToolkit toolkit, Composite parent) {
        super.createControlsInTopSection(toolkit, parent);
        this.createSpacer(toolkit, parent, this.nColumnSpan);
        this.createDetailControls(toolkit, parent);
        toolkit.paintBordersFor(parent);
    }

    protected void createDetailControls(FormToolkit toolkit, Composite parent) {
        this.createEGLInterfaceControl(toolkit, parent, SOAMessages.InterfaceLabel, 1);
        this.createWSDLControl(toolkit, parent);
    }

    protected void createEGLInterfaceControl(FormToolkit toolkit, Composite parent, String btnLabel, int textColSpan) {
        ImageHyperlink interfaceLink = toolkit.createImageHyperlink(parent, 0);
        interfaceLink.setText(btnLabel);
        interfaceLink.setImage(PluginImages.DESC_OBJS_INTERFACE.createImage());
        interfaceLink.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

            public void linkActivated(HyperlinkEvent e) {
                EGLDeploymentDescriptorEditor serviceBindingEditor = WebBindingDetailPage.this.getEGLServiceBindingEditor();
                WebBindingDetailPage.try2OpenPartInEGLEditor(serviceBindingEditor, WebBindingDetailPage.this.fInterfaceOrService.getText());
            }
        });
        this.fInterfaceOrService = toolkit.createText(parent, "", 4);
        this.fInterfaceOrService.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                WebBindingDetailPage.this.HandleInterfaceChanged();
            }
        });
        GridData gd = new GridData(772);
        this.fInterfaceOrService.setLayoutData((Object)gd);
        Button browseInterface = toolkit.createButton(parent, "...", 8);
        browseInterface.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                WebBindingDetailPage.this.HandleBrowseInterfacePressed();
            }
        });
        gd = new GridData(4);
        gd.horizontalSpan = textColSpan;
        browseInterface.setLayoutData((Object)gd);
    }

    @Override
    protected void HandleNameChanged() {
        this.fWebBinding.setName(this.fNameText.getText());
        this.refreshMainTableViewer();
    }

    private void createWSDLControl(FormToolkit toolkit, Composite parent) {
        this.createWSDLLocationControl(toolkit, parent);
        this.createWSDLPort(toolkit, parent);
        this.createWSDLService(toolkit, parent);
        this.createWSDLUri(toolkit, parent);
        this.createEnableGenerateControl(toolkit, parent);
    }

    protected void createEnableGenerateControl(FormToolkit toolkit, Composite parent) {
        this.fGenBtn = toolkit.createButton(parent, SOAMessages.EnableGenerateLabel, 32);
        this.fGenBtn.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                WebBindingDetailPage.this.HandleGenCheckChanged();
            }
        });
    }

    protected void HandleGenCheckChanged() {
    }

    private void createWSDLUri(FormToolkit toolkit, Composite parent) {
        toolkit.createLabel(parent, SOAMessages.WSDLURILabel);
        this.fWSDLUri = this.createTextControl(toolkit, parent);
        this.fWSDLUri.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                WebBindingDetailPage.this.HandleWSDLUriChanged();
            }
        });
    }

    protected void HandleWSDLUriChanged() {
        this.fWebBinding.setUri(this.fWSDLUri.getText());
    }

    private void createWSDLService(FormToolkit toolkit, Composite parent) {
        toolkit.createLabel(parent, SOAMessages.WSDLServiceLabel);
        this.fWSDLService = this.createTextControl(toolkit, parent);
        this.fWSDLService.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                WebBindingDetailPage.this.HandleWSDLServiceChanged();
            }
        });
    }

    protected void HandleWSDLServiceChanged() {
    }

    protected Text createTextControl(FormToolkit toolkit, Composite parent) {
        Text textControl = toolkit.createText(parent, "", 4);
        GridData gd = new GridData(770);
        gd.widthHint = 10;
        gd.horizontalSpan = this.nColumnSpan - 1;
        textControl.setLayoutData((Object)gd);
        return textControl;
    }

    private void createWSDLPort(FormToolkit toolkit, Composite parent) {
        toolkit.createLabel(parent, SOAMessages.WSDLPortLabel);
        this.fWSDLPort = this.createReadOnlyTextControl(toolkit, parent);
    }

    private Text createReadOnlyTextControl(FormToolkit toolkit, Composite parent) {
        Text readonlyTextControl = toolkit.createText(parent, "", 12);
        readonlyTextControl.setEditable(false);
        readonlyTextControl.setBackground(READONLY_BACKGROUNDCOLOR);
        GridData gd = new GridData(770);
        gd.widthHint = 10;
        gd.horizontalSpan = this.nColumnSpan - 1;
        readonlyTextControl.setLayoutData((Object)gd);
        return readonlyTextControl;
    }

    private void createWSDLLocationControl(FormToolkit toolkit, Composite parent) {
        toolkit.createLabel(parent, SOAMessages.WSDLFileLabel);
        this.fWSDLFileLocation = this.createTextControl(toolkit, parent);
        this.fWSDLFileLocation.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                WebBindingDetailPage.this.HandleWSDLLocationChanged();
            }
        });
    }

    protected void HandleWSDLLocationChanged() {
    }

    protected void HandleInterfaceChanged() {
    }

    protected void HandleBrowseInterfacePressed() {
        this.HandleBrowseInterfacePressed(3072);
    }

    protected void HandleBrowseInterfacePressed(int elemKind) {
        Object[] results;
        EGLDDBindingFormPage serviceBindFormPage;
        EGLPartSelectionDialog dialog;
        FormPage formPage = this.getContainerFormPage();
        if (formPage instanceof EGLDDBindingFormPage && ((PartSelectionDialog)(dialog = (serviceBindFormPage = (EGLDDBindingFormPage)formPage).getEGLPartSelectionDialog(elemKind, NewWizardMessages.NewTypeWizardPageInterfaceDialogTitle, NewWizardMessages.NewTypeWizardPageInterfaceDialogLabel, null))).open() == 0 && (results = dialog.getResult()).length > 0) {
            IPart interfacePart = (IPart)results[0];
            this.fInterfaceOrService.setText(interfacePart.getFullyQualifiedName());
        }
    }

    public void commit(boolean onSave) {
    }

    public void dispose() {
    }

    public boolean isDirty() {
        return false;
    }

    public boolean isStale() {
        return false;
    }

    public void refresh() {
    }

    public void setFocus() {
        this.update();
    }

    public boolean setFormInput(Object input) {
        return false;
    }

    public void selectionChanged(IFormPart part, ISelection selection) {
        IStructuredSelection ssel = (IStructuredSelection)selection;
        this.fWebBinding = ssel.size() == 1 ? (Binding)ssel.getFirstElement() : null;
        this.update();
    }

    protected void update() {
    }
}

