/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.ui.internal.quickfix.proposals;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.edt.ide.core.ast.rewrite.ASTRewrite;
import org.eclipse.edt.ide.core.model.IEGLFile;
import org.eclipse.edt.ide.core.model.document.IEGLDocument;
import org.eclipse.edt.ide.ui.EDTUIPlugin;
import org.eclipse.edt.ide.ui.internal.EGLUI;
import org.eclipse.edt.ide.ui.internal.EGLUIStatus;
import org.eclipse.edt.ide.ui.internal.quickfix.proposals.EGLFileCorrectionProposal;
import org.eclipse.jface.text.IDocument;
import org.eclipse.swt.graphics.Image;
import org.eclipse.text.edits.TextEdit;
import org.eclipse.ui.IEditorPart;

public abstract class ASTRewriteCorrectionProposal
extends EGLFileCorrectionProposal {
    private IEGLFile modelFile;

    public ASTRewriteCorrectionProposal(String name, IEGLFile eglFile, int relevance, Image image, IEGLDocument document) {
        super(name, eglFile, relevance, image, document);
        this.modelFile = eglFile;
    }

    @Override
    protected void addEdits(IDocument document, TextEdit editRoot) throws CoreException {
        super.addEdits(document, editRoot);
        ASTRewrite rewrite = this.getRewrite();
        if (rewrite != null) {
            try {
                TextEdit edit = rewrite.rewriteAST(document);
                editRoot.addChild(edit);
            }
            catch (IllegalArgumentException e) {
                throw new CoreException(EGLUIStatus.createError(4, e));
            }
        }
    }

    @Override
    protected void performChange(IEditorPart part, IDocument document) throws CoreException {
        ASTRewrite fRewrite = this.getRewrite();
        if (fRewrite != null) {
            try {
                IEGLFile sharedWorkingCopy = (IEGLFile)this.modelFile.getSharedWorkingCopy(null, EGLUI.getBufferFactory(), null);
                sharedWorkingCopy.open(null);
                sharedWorkingCopy.reconcile(false, null);
                try {
                    try {
                        TextEdit edit = fRewrite.rewriteAST(document);
                        edit.apply(document);
                    }
                    catch (Exception e) {
                        EDTUIPlugin.log((IStatus)new Status(4, "org.eclipse.edt.ide.ui", "AST Rewrite for quick fix error ", (Throwable)e));
                        sharedWorkingCopy.destroy();
                    }
                }
                finally {
                    sharedWorkingCopy.destroy();
                }
            }
            catch (Exception e) {
                EDTUIPlugin.log((IStatus)new Status(4, "org.eclipse.edt.ide.ui", "AST Rewrite for quick fix error ", (Throwable)e));
            }
        }
    }

    protected abstract ASTRewrite getRewrite();
}

