/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.ui.templates.parts;

import org.eclipse.edt.ide.ui.templates.parts.Type;

public class DecimalType
extends Type {
    int length = 31;
    int decimals = 0;

    public int getLength() {
        return this.length;
    }

    public void setLength(int length) {
        this.length = length;
    }

    public int getDecimals() {
        return this.decimals;
    }

    public void setDecimals(int decimals) {
        this.decimals = decimals;
    }

    @Override
    public String getName() {
        int tempLength = this.getLength();
        int tempDecimals = this.getDecimals();
        if (tempLength > 32) {
            tempLength = 32;
            if ((tempDecimals -= this.getLength() - tempLength) < 0) {
                tempDecimals = 0;
            }
        }
        return "decimal(" + tempLength + (tempDecimals > 0 ? "," + tempDecimals : "") + ")";
    }

    @Override
    public Type compareTo(Type type) {
        if (type instanceof DecimalType) {
            DecimalType you = (DecimalType)type;
            int maxSig = this.getMax(this.getSig(), you.getSig());
            int maxDec = this.getMax(this.getDecimals(), you.getDecimals());
            DecimalType dec = new DecimalType();
            dec.setDecimals(maxDec);
            dec.setLength(maxSig + maxDec);
            return dec;
        }
        return super.compareTo(type);
    }

    private int getSig() {
        return this.getLength() - this.getDecimals();
    }

    private int getMax(int i, int j) {
        if (i > j) {
            return i;
        }
        return j;
    }

    @Override
    public Object clone() {
        DecimalType type = new DecimalType();
        type.length = this.length;
        type.decimals = this.decimals;
        type.name = this.name;
        type.isNullable = this.isNullable;
        type.setAnnotations(this.getAnnotations());
        return type;
    }
}

