/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.ui.internal;

import java.util.Map;
import org.eclipse.edt.compiler.core.ast.ISyntaxErrorRequestor;
import org.eclipse.edt.ide.ui.editor.CodeFormatter;
import org.eclipse.edt.ide.ui.internal.formatting.EGLCodeFormatter;
import org.eclipse.edt.ide.ui.internal.formatting.ui.ProfileManager;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.TextUtilities;
import org.eclipse.text.edits.TextEdit;

public class CodeFormatterUtil {
    public static int getTabWidth(IJavaProject project) {
        String key = "space".equals(CodeFormatterUtil.getCoreOption(project, "org.eclipse.jdt.core.formatter.tabulation.char")) ? "org.eclipse.jdt.core.formatter.indentation.size" : "org.eclipse.jdt.core.formatter.tabulation.size";
        return CodeFormatterUtil.getCoreOption(project, key, 4);
    }

    public static int getIndentWidth(IJavaProject project) {
        String key = "mixed".equals(CodeFormatterUtil.getCoreOption(project, "org.eclipse.jdt.core.formatter.tabulation.char")) ? "org.eclipse.jdt.core.formatter.indentation.size" : "org.eclipse.jdt.core.formatter.tabulation.size";
        return CodeFormatterUtil.getCoreOption(project, key, 4);
    }

    private static String getCoreOption(IJavaProject project, String key) {
        if (project == null) {
            return JavaCore.getOption((String)key);
        }
        return project.getOption(key, true);
    }

    private static int getCoreOption(IJavaProject project, String key, int def) {
        try {
            return Integer.parseInt(CodeFormatterUtil.getCoreOption(project, key));
        }
        catch (NumberFormatException numberFormatException) {
            return def;
        }
    }

    public static Map getFormattingOptionMapByProfileName(String formatProfileName, ProfileManager profileMgr) {
        if (formatProfileName != null && formatProfileName.length() > 0) {
            EObject profile = profileMgr.getProfileByName(formatProfileName, true);
            profileMgr.setSelectedProfile(profile);
        }
        return profileMgr.getCurrentPreferenceSettingMap();
    }

    private static TextEdit format(IDocument document, int offset, int length, int indentationLevel, String lineSeprator, Map options, ISyntaxErrorRequestor syntaxErrRequestor) {
        EGLCodeFormatter eglCodeFormatter = new EGLCodeFormatter(options);
        return ((CodeFormatter)eglCodeFormatter).format(document, offset, length, indentationLevel, lineSeprator, syntaxErrRequestor);
    }

    public static TextEdit format(IDocument document, int offset, int length, Map options, ISyntaxErrorRequestor syntaxErrRequestor) {
        int indentationLevel = 0;
        String lineSeprator = TextUtilities.getDefaultLineDelimiter((IDocument)document);
        return CodeFormatterUtil.format(document, offset, length, indentationLevel, lineSeprator, options, syntaxErrRequestor);
    }
}

