/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.ui.internal.deployment.ui;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.eclipse.edt.ide.ui.internal.deployment.Service;
import org.eclipse.edt.ide.ui.internal.deployment.ui.EGLDDBaseDetailPage;
import org.eclipse.edt.ide.ui.internal.deployment.ui.EGLDDRootHelper;
import org.eclipse.edt.ide.ui.internal.deployment.ui.EGLDDWebServicesBlock;
import org.eclipse.edt.ide.ui.internal.deployment.ui.SOAMessages;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.forms.IFormPart;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;

public class WebServicesDetailPage
extends EGLDDBaseDetailPage {
    private Service fWebService;
    private Service fRestService;
    private Button fUseExistingBtn;
    private Button fBrowseBtn;
    private Label fLabelStyle;
    private Label fLabelWSDLFile;
    private Label fLabelService;
    private Label fLabelPort;
    private Label fRestUriLabel;
    private Text fWSDLFileText;
    private Text fRestUri;
    private CCombo fComboStyle;
    private CCombo fComboService;
    private CCombo fComboPort;
    private Color fComboEnabledColor;
    private Text fCICSURIText;
    private List fRESTServiceSectionControls;
    private List fSOAPServiceSectionControls;
    private List fPlatformSectionControls;
    private List fSOAPWSDLControls;
    private static final String WSDL_EXTENSION = "wsdl";

    @Override
    protected Composite createDetailSection(Composite parent, FormToolkit toolkit, int sectionStyle, int columnSpan) {
        return this.createSection(parent, toolkit, SOAMessages.WSDetailSectionTitle, SOAMessages.WSDetailSectionDescription, sectionStyle, columnSpan);
    }

    @Override
    protected void createControlsInTopSection(FormToolkit toolkit, Composite parent) {
        this.createSpacer(toolkit, parent, this.nColumnSpan);
        this.createDetailControls(toolkit, parent);
        toolkit.paintBordersFor(parent);
    }

    protected void createDetailControls(FormToolkit toolkit, Composite parent) {
        this.createSOAPServicePropertiesSection(toolkit, parent);
        this.createRESTServicePropertiesSection(toolkit, parent);
        this.createPlatformSpecificSection(toolkit, parent);
    }

    protected void createRESTServicePropertiesSection(FormToolkit toolkit, Composite parent) {
        this.fRESTServiceSectionControls = new ArrayList();
        Section section = toolkit.createSection(parent, 66);
        section.setText(SOAMessages.TitleSectionRestService);
        GridData gd = new GridData(1808);
        gd.horizontalSpan = 3;
        section.setLayoutData((Object)gd);
        Composite separator = toolkit.createCompositeSeparator((Composite)section);
        gd = new GridData(1808);
        gd.heightHint = 3;
        separator.setLayoutData((Object)gd);
        Composite client = toolkit.createComposite((Composite)section, 64);
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        layout.marginWidth = 2;
        layout.marginHeight = 2;
        client.setLayout((Layout)layout);
        Composite fieldComposite = toolkit.createComposite(client);
        int layoutColumn = 3;
        layout = new GridLayout(layoutColumn, false);
        gd = new GridData(768);
        fieldComposite.setLayout((Layout)layout);
        fieldComposite.setLayoutData((Object)gd);
        this.fRestUriLabel = toolkit.createLabel(fieldComposite, SOAMessages.LabelURI);
        this.fRESTServiceSectionControls.add(this.fRestUriLabel);
        this.fRestUri = toolkit.createText(fieldComposite, "", 4);
        gd = new GridData(768);
        gd.horizontalSpan = layoutColumn - 1;
        this.fRestUri.setLayoutData((Object)gd);
        this.fRestUri.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                WebServicesDetailPage.this.HandleRestURIModified();
            }
        });
        this.fRESTServiceSectionControls.add(this.fRestUri);
        this.createSpacer(toolkit, fieldComposite, layoutColumn);
        toolkit.paintBordersFor(fieldComposite);
        section.setClient((Control)client);
    }

    private void updateControlState(List controls, boolean enabled) {
        for (Control control : controls) {
            control.setEnabled(enabled);
            if (!(control instanceof Text) && !(control instanceof CCombo)) continue;
            control.setBackground(enabled ? this.fComboEnabledColor : READONLY_BACKGROUNDCOLOR);
        }
    }

    protected void createSOAPServicePropertiesSection(FormToolkit toolkit, Composite parent) {
        this.fSOAPServiceSectionControls = new ArrayList();
        this.fSOAPWSDLControls = new ArrayList();
        Section section = toolkit.createSection(parent, 66);
        section.setText(SOAMessages.WebServiceProp);
        GridData gd = new GridData(1808);
        gd.horizontalSpan = 3;
        section.setLayoutData((Object)gd);
        Composite separator = toolkit.createCompositeSeparator((Composite)section);
        gd = new GridData(1808);
        gd.heightHint = 3;
        separator.setLayoutData((Object)gd);
        Composite client = toolkit.createComposite((Composite)section, 64);
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        layout.marginWidth = 2;
        layout.marginHeight = 2;
        client.setLayout((Layout)layout);
        Composite fieldComposite = toolkit.createComposite(client);
        int layoutColumn = 3;
        layout = new GridLayout(layoutColumn, false);
        gd = new GridData(768);
        fieldComposite.setLayout((Layout)layout);
        fieldComposite.setLayoutData((Object)gd);
        this.fUseExistingBtn = toolkit.createButton(fieldComposite, SOAMessages.UseExistingWSDL, 32);
        gd = new GridData(800);
        gd.horizontalSpan = layoutColumn;
        this.fUseExistingBtn.setLayoutData((Object)gd);
        this.fUseExistingBtn.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                WebServicesDetailPage.this.HandleUseExistingPressed();
            }
        });
        this.fSOAPServiceSectionControls.add(this.fUseExistingBtn);
        this.fLabelStyle = toolkit.createLabel(fieldComposite, SOAMessages.StyleLabel);
        this.fSOAPServiceSectionControls.add(this.fLabelStyle);
        this.fComboStyle = new CCombo(fieldComposite, 0x80000C);
        toolkit.adapt((Control)this.fComboStyle, true, true);
        this.fComboStyle.setData("FormWidgetFactory.drawBorder", (Object)"textBorder");
        gd = new GridData(768);
        gd.horizontalSpan = this.nColumnSpan - 1;
        this.fComboStyle.setLayoutData((Object)gd);
        this.fComboStyle.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                WebServicesDetailPage.this.HandleStyleComboSelectionChanged();
            }
        });
        this.fComboStyle.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusGained(FocusEvent e) {
                WebServicesDetailPage.this.initStyleComboItems();
            }
        });
        this.fSOAPServiceSectionControls.add(this.fComboStyle);
        this.fLabelWSDLFile = toolkit.createLabel(fieldComposite, SOAMessages.WSDLFileLabel);
        this.fSOAPServiceSectionControls.add(this.fLabelWSDLFile);
        this.fSOAPWSDLControls.add(this.fLabelWSDLFile);
        this.fWSDLFileText = toolkit.createText(fieldComposite, "", 8);
        gd = new GridData(768);
        this.fWSDLFileText.setLayoutData((Object)gd);
        this.fSOAPServiceSectionControls.add(this.fWSDLFileText);
        this.fSOAPWSDLControls.add(this.fWSDLFileText);
        this.fBrowseBtn = toolkit.createButton(fieldComposite, "...", 8);
        gd = new GridData();
        this.fBrowseBtn.setLayoutData((Object)gd);
        this.fBrowseBtn.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                WebServicesDetailPage.this.HandleBrowsePressed();
            }
        });
        this.fSOAPServiceSectionControls.add(this.fBrowseBtn);
        this.fSOAPWSDLControls.add(this.fBrowseBtn);
        this.fLabelService = toolkit.createLabel(fieldComposite, SOAMessages.WSDLServiceLabel);
        this.fSOAPServiceSectionControls.add(this.fLabelService);
        this.fSOAPWSDLControls.add(this.fLabelService);
        this.fComboService = new CCombo(fieldComposite, 0x80000C);
        toolkit.adapt((Control)this.fComboService, true, true);
        this.fComboService.setData("FormWidgetFactory.drawBorder", (Object)"textBorder");
        gd = new GridData(768);
        gd.horizontalSpan = layoutColumn - 1;
        this.fComboService.setLayoutData((Object)gd);
        this.fComboService.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                WebServicesDetailPage.this.HandleServiceComboSelectionChanged();
            }
        });
        this.fSOAPServiceSectionControls.add(this.fComboService);
        this.fSOAPWSDLControls.add(this.fComboService);
        this.fLabelPort = toolkit.createLabel(fieldComposite, SOAMessages.WSDLPortLabel);
        this.fSOAPServiceSectionControls.add(this.fLabelPort);
        this.fSOAPWSDLControls.add(this.fLabelPort);
        this.fComboPort = new CCombo(fieldComposite, 0x80000C);
        toolkit.adapt((Control)this.fComboPort, true, true);
        this.fComboPort.setData("FormWidgetFactory.drawBorder", (Object)"textBorder");
        gd = new GridData(768);
        gd.horizontalSpan = layoutColumn - 1;
        this.fComboPort.setLayoutData((Object)gd);
        this.fComboPort.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                WebServicesDetailPage.this.HandlePortComboSelectionChanged();
            }
        });
        this.fSOAPServiceSectionControls.add(this.fComboPort);
        this.fSOAPWSDLControls.add(this.fComboPort);
        this.createSpacer(toolkit, fieldComposite, layoutColumn);
        toolkit.paintBordersFor(fieldComposite);
        section.setClient((Control)client);
        section.setExpanded(false);
        section.setVisible(false);
    }

    private void createPlatformSpecificSection(FormToolkit toolkit, Composite parent) {
        this.fPlatformSectionControls = new ArrayList();
        Section section = toolkit.createSection(parent, 66);
        GridData gd = new GridData(1808);
        gd.horizontalSpan = 3;
        section.setText(SOAMessages.PlatformSpecificPropLabel);
        section.setLayoutData((Object)gd);
        Composite separator = toolkit.createCompositeSeparator((Composite)section);
        gd = new GridData(1808);
        gd.heightHint = 3;
        separator.setLayoutData((Object)gd);
        Composite client = toolkit.createComposite((Composite)section, 64);
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        layout.marginWidth = 2;
        layout.marginHeight = 2;
        client.setLayout((Layout)layout);
        Composite fieldComposite = toolkit.createComposite(client);
        layout = new GridLayout(2, false);
        gd = new GridData(768);
        fieldComposite.setLayout((Layout)layout);
        fieldComposite.setLayoutData((Object)gd);
        Label cicsUriLabel = toolkit.createLabel(fieldComposite, SOAMessages.CICSURILabel);
        this.fPlatformSectionControls.add(cicsUriLabel);
        this.fCICSURIText = toolkit.createText(fieldComposite, "", 4);
        gd = new GridData(768);
        this.fCICSURIText.setLayoutData((Object)gd);
        this.fCICSURIText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                WebServicesDetailPage.this.HandleCICSURIModified();
            }
        });
        this.fPlatformSectionControls.add(this.fCICSURIText);
        this.fSOAPServiceSectionControls.add(this.fCICSURIText);
        toolkit.paintBordersFor(fieldComposite);
        section.setClient((Control)client);
        section.setExpanded(false);
        section.setVisible(false);
    }

    private void HandleUseExistingPressed() {
        boolean selectionState = this.fUseExistingBtn.getSelection();
        this.updateServiceControlState(selectionState);
    }

    private void HandleRestURIModified() {
        String newURI = this.fRestUri.getText();
        if (newURI == null) {
            newURI = "";
        }
        EGLDDRootHelper.addOrUpdateParameter(EGLDDRootHelper.getParameters(this.fRestService), "uriFragment", newURI);
    }

    private void HandleBrowsePressed() {
        throw new RuntimeException("this function is to be added later");
    }

    private void HandleStyleComboSelectionChanged() {
    }

    private void HandleServiceComboSelectionChanged() {
        this.initPortComboItems();
    }

    private void initPortComboItems() {
        Object serviceData;
        String serviceRef = this.fComboService.getText();
        if (serviceRef != null && serviceRef.trim().length() > 0 && (serviceData = this.fComboService.getData()) != null && serviceData instanceof HashMap) {
            HashMap itemMap = (HashMap)serviceData;
            List portList = (List)itemMap.get(serviceRef);
            if (portList == null) {
                this.fComboPort.setItems(new String[0]);
            } else {
                this.fComboPort.setItems(portList.toArray(new String[0]));
                this.fComboPort.select(0);
                this.HandlePortComboSelectionChanged();
            }
        }
    }

    private void HandlePortComboSelectionChanged() {
    }

    private void HandleCICSURIModified() {
    }

    public void commit(boolean onSave) {
    }

    public void dispose() {
    }

    public boolean isDirty() {
        return false;
    }

    public boolean isStale() {
        return false;
    }

    public void refresh() {
    }

    public void setFocus() {
    }

    public boolean setFormInput(Object input) {
        return false;
    }

    public void selectionChanged(IFormPart part, ISelection selection) {
        IStructuredSelection ssel = (IStructuredSelection)selection;
        if (ssel.size() == 1) {
            EGLDDWebServicesBlock.RowItem rowitem = (EGLDDWebServicesBlock.RowItem)ssel.getFirstElement();
            this.fWebService = rowitem.webservice;
            this.fRestService = rowitem.restservice;
        } else {
            this.fWebService = null;
            this.fRestService = null;
        }
        this.update();
    }

    protected void update() {
        if (this.fRestService != null) {
            this.updateRESTControls();
            this.updateControlState(this.fRESTServiceSectionControls, EGLDDRootHelper.getBooleanParameterValue(this.fRestService.getParameters(), "enableGeneration"));
            if (this.fWebService == null) {
                this.updateControlState(this.fSOAPServiceSectionControls, false);
            }
        }
    }

    private void updateRESTControls() {
        String uri = null;
        if (this.fRestService.getParameters() != null) {
            uri = EGLDDRootHelper.getParameterValue(this.fRestService.getParameters(), "uriFragment");
        }
        this.fRestUri.setText(uri == null ? "" : uri);
    }

    private void initStyleComboItems() {
    }

    private static int getComboIndex(CCombo combo, String item) {
        String[] items = combo.getItems();
        int i = 0;
        while (i < items.length) {
            if (items[i].equals(item)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    private void updateServiceControlState(boolean controlState) {
        this.fLabelStyle.setEnabled(!controlState);
        this.fComboStyle.setEnabled(!controlState);
        this.fComboStyle.setBackground(controlState ? READONLY_BACKGROUNDCOLOR : this.fComboEnabledColor);
        this.updateControlState(this.fSOAPWSDLControls, controlState);
    }
}

