/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.ui.internal.editor.folding;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.edt.ide.ui.EDTUIPlugin;
import org.eclipse.edt.ide.ui.editor.IFoldingPreferenceBlock;
import org.eclipse.edt.ide.ui.internal.editor.folding.FoldingMessages;
import org.eclipse.edt.ide.ui.internal.preferences.OverlayPreferenceStore;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class FoldingPreferenceBlock
implements IFoldingPreferenceBlock {
    private IPreferenceStore fStore;
    private OverlayPreferenceStore fOverlayStore;
    private OverlayPreferenceStore.OverlayKey[] fKeys;
    private Map fCheckBoxes = new HashMap();
    private Text fThreshold;
    private SelectionListener fCheckBoxListener = new SelectionListener(){

        public void widgetDefaultSelected(SelectionEvent e) {
        }

        public void widgetSelected(SelectionEvent e) {
            Button button = (Button)e.widget;
            FoldingPreferenceBlock.this.fOverlayStore.setValue((String)FoldingPreferenceBlock.this.fCheckBoxes.get(button), button.getSelection());
        }
    };
    private ModifyListener fThresholdListener = new ModifyListener(){

        public void modifyText(ModifyEvent e) {
            Text text = (Text)e.widget;
            String str = text.getText();
            try {
                int threshold = Integer.parseInt(str);
                FoldingPreferenceBlock.this.fOverlayStore.setValue("editor_folding_propertiesblocks_threshold", threshold);
            }
            catch (NumberFormatException numberFormatException) {
                FoldingPreferenceBlock.this.fOverlayStore.setValue("editor_folding_propertiesblocks_threshold", 1);
            }
        }
    };

    public FoldingPreferenceBlock() {
        this.fStore = EDTUIPlugin.getDefault().getPreferenceStore();
        this.fKeys = this.createKeys();
        this.fOverlayStore = new OverlayPreferenceStore(this.fStore, this.fKeys);
    }

    private OverlayPreferenceStore.OverlayKey[] createKeys() {
        ArrayList<OverlayPreferenceStore.OverlayKey> overlayKeys = new ArrayList<OverlayPreferenceStore.OverlayKey>();
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "editor_folding_comments"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "editor_folding_parts"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "editor_folding_functions"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "editor_folding_imports"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "editor_folding_partitions"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "editor_folding_propertiesblocks"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.INT, "editor_folding_propertiesblocks_threshold"));
        return overlayKeys.toArray(new OverlayPreferenceStore.OverlayKey[overlayKeys.size()]);
    }

    @Override
    public Control createControl(Composite composite) {
        this.fOverlayStore.load();
        this.fOverlayStore.start();
        Composite inner = new Composite(composite, 0);
        GridLayout layout = new GridLayout(1, true);
        layout.verticalSpacing = 3;
        layout.marginWidth = 0;
        inner.setLayout((Layout)layout);
        Composite prop1 = new Composite(inner, 0);
        GridLayout layoutp = new GridLayout(3, false);
        layoutp.verticalSpacing = 0;
        layoutp.horizontalSpacing = 0;
        layoutp.marginWidth = 0;
        prop1.setLayout((Layout)layoutp);
        Label labelThreshold = new Label(prop1, 0);
        labelThreshold.setText("     " + FoldingMessages.EGLFoldingPreferenceBlock_propertiesBlockThreshold);
        this.addTextBox(prop1, "editor_folding_propertiesblocks_threshold", 0);
        Label label = new Label(inner, 16384);
        label.setText(FoldingMessages.EGLFoldingPreferenceBlock_title);
        this.addCheckBox(inner, FoldingMessages.EGLFoldingPreferenceBlock_comments, "editor_folding_comments", 0);
        this.addCheckBox(inner, FoldingMessages.EGLFoldingPreferenceBlock_parts, "editor_folding_parts", 0);
        this.addCheckBox(inner, FoldingMessages.EGLFoldingPreferenceBlock_functions, "editor_folding_functions", 0);
        this.addCheckBox(inner, FoldingMessages.EGLFoldingPreferenceBlock_imports, "editor_folding_imports", 0);
        this.addCheckBox(inner, FoldingMessages.EGLFoldingPreferenceBlock_partitions, "editor_folding_partitions", 0);
        this.addCheckBox(inner, FoldingMessages.EGLFoldingPreferenceBlock_propertiesBlock, "editor_folding_propertiesblocks", 0);
        return inner;
    }

    private Text addTextBox(Composite parent, String key, int indentation) {
        this.fThreshold = new Text(parent, 2052);
        GridData gd = new GridData(512);
        gd.horizontalIndent = indentation;
        gd.horizontalSpan = 1;
        gd.grabExcessVerticalSpace = false;
        gd.grabExcessHorizontalSpace = false;
        gd.widthHint = 50;
        this.fThreshold.setLayoutData((Object)gd);
        this.fThreshold.addModifyListener(this.fThresholdListener);
        return this.fThreshold;
    }

    private Button addCheckBox(Composite parent, String label, String key, int indentation) {
        Button checkBox = new Button(parent, 32);
        checkBox.setText(label);
        GridData gd = new GridData(32);
        gd.horizontalIndent = indentation;
        gd.horizontalSpan = 1;
        gd.grabExcessVerticalSpace = false;
        checkBox.setLayoutData((Object)gd);
        checkBox.addSelectionListener(this.fCheckBoxListener);
        this.fCheckBoxes.put(checkBox, key);
        return checkBox;
    }

    private void initializeFields() {
        for (Button b : this.fCheckBoxes.keySet()) {
            String key = (String)this.fCheckBoxes.get(b);
            b.setSelection(this.fOverlayStore.getBoolean(key));
        }
        int threshold = this.fOverlayStore.getInt("editor_folding_propertiesblocks_threshold");
        this.fThreshold.setText(String.valueOf(threshold));
    }

    @Override
    public void performOk() {
        this.fOverlayStore.propagate();
    }

    @Override
    public void initialize() {
        this.initializeFields();
    }

    @Override
    public void performDefaults() {
        this.fOverlayStore.loadDefaults();
        this.initializeFields();
    }

    @Override
    public void dispose() {
        this.fOverlayStore.stop();
    }
}

