/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.ui.internal.externaltype.wizards.javatype;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.edt.gen.AbstractGeneratorCommand;
import org.eclipse.edt.gen.generator.eglsource.EglSourceContext;
import org.eclipse.edt.gen.generator.eglsource.EglSourceGenerator;
import org.eclipse.edt.ide.ui.EDTUIPlugin;
import org.eclipse.edt.ide.ui.internal.externaltype.NewExternalTypeWizard;
import org.eclipse.edt.ide.ui.internal.externaltype.conversion.javatype.JavaObjectsToEglSource;
import org.eclipse.edt.ide.ui.internal.externaltype.util.ReflectionUtil;
import org.eclipse.edt.ide.ui.internal.externaltype.wizards.javatype.ExternalTypeFromJavaPage;
import org.eclipse.edt.ide.ui.internal.externaltype.wizards.javatype.ExternalTypeFromJavaWizardConfiguration;
import org.eclipse.edt.ide.ui.internal.externaltype.wizards.javatype.ExternalTypeSummaryPage;
import org.eclipse.edt.ide.ui.internal.externaltype.wizards.javatype.JavaType;
import org.eclipse.edt.ide.ui.internal.record.conversion.IMessageHandler;
import org.eclipse.edt.ide.ui.templates.wizards.TemplateWizard;
import org.eclipse.jface.dialogs.IPageChangingListener;
import org.eclipse.jface.dialogs.PageChangingEvent;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardContainer;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchWizard;

public class ExternalTypeFromJavaWizard
extends TemplateWizard
implements IWorkbenchWizard,
IPageChangingListener,
IMessageHandler {
    private ExternalTypeFromJavaWizardConfiguration config;
    protected List<String> messages = new ArrayList<String>();
    protected IStructuredSelection selection;
    protected ExternalTypeFromJavaPage javaTypeSelectionPage;
    protected ExternalTypeSummaryPage summaryPage;

    public ExternalTypeFromJavaWizard() {
        this.setNeedsProgressMonitor(true);
        this.setDialogSettings(EDTUIPlugin.getDefault().getDialogSettings());
        this.config = new ExternalTypeFromJavaWizardConfiguration();
        this.javaTypeSelectionPage = new ExternalTypeFromJavaPage(this.config);
        this.summaryPage = new ExternalTypeSummaryPage((ISelection)this.selection);
    }

    public void addPages() {
        this.addPage((IWizardPage)this.javaTypeSelectionPage);
        this.addPage((IWizardPage)this.summaryPage);
    }

    public void init(IWorkbench arg0, IStructuredSelection selection) {
        this.selection = selection;
    }

    public void setContainer(IWizardContainer wizardContainer) {
        super.setContainer(wizardContainer);
        if (wizardContainer != null) {
            ((WizardDialog)wizardContainer).addPageChangingListener((IPageChangingListener)this);
        }
    }

    @Override
    public boolean performFinish() {
        try {
            this.getContainer().run(true, true, this.createFinishOperation());
        }
        catch (InterruptedException interruptedException) {
            return false;
        }
        catch (Exception exception) {}
        return true;
    }

    protected IRunnableWithProgress createFinishOperation() {
        return new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                String results = ExternalTypeFromJavaWizard.this.generateExternalTypes(monitor, true);
                ((NewExternalTypeWizard)ExternalTypeFromJavaWizard.this.getParentWizard()).setContentObj(results);
            }
        };
    }

    public void handlePageChanging(PageChangingEvent event) {
        if (event.getTargetPage() == this.summaryPage) {
            IRunnableWithProgress op = this.createPreviewOperation();
            try {
                this.getContainer().run(true, true, op);
            }
            catch (InterruptedException interruptedException) {
                event.doit = false;
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    protected IRunnableWithProgress createPreviewOperation() {
        return new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                if (ExternalTypeFromJavaWizard.this.messages != null) {
                    ExternalTypeFromJavaWizard.this.messages.clear();
                }
                final String results = ExternalTypeFromJavaWizard.this.generateExternalTypes(monitor, false);
                Display.getDefault().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        (this).ExternalTypeFromJavaWizard.this.summaryPage.setContent(results);
                        List<String> messages = ExternalTypeFromJavaWizard.this.getMessages();
                        if (messages != null && messages.size() > 0) {
                            (this).ExternalTypeFromJavaWizard.this.summaryPage.setMessages(messages);
                        }
                    }
                });
            }
        };
    }

    protected String generateExternalTypes(IProgressMonitor monitor, boolean isFinished) throws InterruptedException {
        StringBuilder buffer = new StringBuilder(200);
        JavaObjectsToEglSource d = new JavaObjectsToEglSource();
        JavaType selectedJavaType = this.config.getToBeGenerated().get(this.config.getSelectedClazz());
        this.config.getToBeGenerated().clear();
        this.config.getToBeGenerated().put(this.config.getSelectedClazz(), selectedJavaType);
        ReflectionUtil.getInnerTypes(this.config.getSelectedClazz(), this.config.getToBeGenerated());
        HashMap<Object, JavaType> tempMap = new HashMap<Object, JavaType>(20);
        if (this.config.isAllSuperTypesGenerated) {
            for (Map.Entry<Class<?>, JavaType> entry : this.config.getToBeGenerated().entrySet()) {
                if (entry.getValue().getSource() != 0) continue;
                Set<Class<?>> superTypes = ReflectionUtil.getAllSuperTypes(entry.getKey());
                for (Class<?> superType : superTypes) {
                    if (tempMap.containsKey(superType)) continue;
                    tempMap.put(superType, JavaType.DUMMY_REFERENCED_JAVATYPE);
                }
            }
            for (Map.Entry entry : tempMap.entrySet()) {
                if (this.config.getToBeGenerated().containsKey(entry.getKey())) continue;
                this.config.getToBeGenerated().put((Class)entry.getKey(), (JavaType)entry.getValue());
            }
            tempMap.clear();
        }
        if (this.config.isAllReferencedTypesGenerated) {
            for (Map.Entry<Class<?>, JavaType> entry : this.config.getToBeGenerated().entrySet()) {
                List<Method> methods;
                List<Constructor<?>> constructors;
                if (entry.getValue().getSource() != 0 || (selectedJavaType = entry.getValue()) == null) continue;
                HashSet hashSet = new HashSet(30);
                List<Field> fields = selectedJavaType.getFields();
                if (fields.size() > 0) {
                    hashSet.addAll(ReflectionUtil.getFieldReferencedTypes(fields));
                }
                if ((constructors = selectedJavaType.getConstructors()).size() > 0) {
                    hashSet.addAll(ReflectionUtil.getConReferencedTypes(constructors));
                }
                if ((methods = selectedJavaType.getMethods()).size() > 0) {
                    hashSet.addAll(ReflectionUtil.getMethodReferencedTypes(methods));
                }
                for (Class refType : hashSet) {
                    if (tempMap.containsKey(refType)) continue;
                    tempMap.put(refType, JavaType.DUMMY_REFERENCED_JAVATYPE);
                }
            }
            for (Map.Entry entry : tempMap.entrySet()) {
                if (this.config.getToBeGenerated().containsKey(entry.getKey())) continue;
                this.config.getToBeGenerated().put((Class)entry.getKey(), (JavaType)entry.getValue());
            }
            tempMap = null;
        }
        monitor.beginTask("Generating external type parts", this.config.getToBeGenerated().size());
        buffer.append("import eglx.java.*;\n");
        for (Map.Entry<Class<?>, JavaType> entry : this.config.getToBeGenerated().entrySet()) {
            if (monitor.isCanceled()) break;
            EglSourceGenerator eglSourceGenerator = new EglSourceGenerator((AbstractGeneratorCommand)d);
            EglSourceContext context = eglSourceGenerator.makeContext((AbstractGeneratorCommand)d);
            context.put((Object)"toBeGeneratedType", (Object)entry.getValue());
            context.put((Object)"eglPackage", (Object)((NewExternalTypeWizard)this.getParentWizard()).getConfiguration().getFPackage());
            context.put((Object)"allClassMeta", this.config.getToBeGenerated().keySet());
            Class<?> clazz = entry.getKey();
            monitor.subTask(clazz.getName());
            d.generate(clazz, eglSourceGenerator, null);
            buffer.append(context.getTabbedWriterContent());
            monitor.worked(1);
        }
        if (monitor.isCanceled()) {
            throw new InterruptedException();
        }
        return buffer.toString();
    }

    @Override
    public void addMessage(String message) {
        if (this.messages == null) {
            this.messages = new ArrayList<String>();
        }
        this.messages.add(message);
    }

    @Override
    public List<String> getMessages() {
        return this.messages;
    }
}

