/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.ui.internal.formatting.ui;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Observable;
import java.util.Observer;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.edt.ide.ui.EDTUIPlugin;
import org.eclipse.edt.ide.ui.internal.formatting.CodeFormatterConstants;
import org.eclipse.edt.ide.ui.internal.formatting.profile.Category;
import org.eclipse.edt.ide.ui.internal.formatting.profile.CheckControl;
import org.eclipse.edt.ide.ui.internal.formatting.profile.ComboControl;
import org.eclipse.edt.ide.ui.internal.formatting.profile.DefaultProfile;
import org.eclipse.edt.ide.ui.internal.formatting.profile.Preference;
import org.eclipse.edt.ide.ui.internal.formatting.profile.Preview;
import org.eclipse.edt.ide.ui.internal.formatting.profile.RadioControl;
import org.eclipse.edt.ide.ui.internal.formatting.profile.ReferenceControl;
import org.eclipse.edt.ide.ui.internal.formatting.profile.TextControl;
import org.eclipse.edt.ide.ui.internal.formatting.profile.TreeControl;
import org.eclipse.edt.ide.ui.internal.formatting.ui.EGLPreview;
import org.eclipse.edt.ide.ui.internal.formatting.ui.FormatProfileRootHelper;
import org.eclipse.edt.ide.ui.internal.formatting.ui.ModifyDialog;
import org.eclipse.edt.ide.ui.internal.formatting.ui.ProfileManager;
import org.eclipse.edt.ide.ui.internal.util.PixelConverter;
import org.eclipse.edt.ide.ui.internal.wizards.NewWizardMessages;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class ModifyDialogTabPage {
    protected final Observer fUpdater = new Observer(){

        @Override
        public void update(Observable o, Object arg) {
            ModifyDialogTabPage.this.doUpdatePreview();
            ModifyDialogTabPage.this.notifyValuesModified();
        }
    };
    protected final DefaultFocusManager fDefaultFocusManager;
    protected PixelConverter fPixelConverter;
    private final ModifyDialog fModifyDialog;
    private Map fAllPreferenceSettings;
    protected EGLPreview fPreview;
    private DefaultProfile fDefaultProfile;
    protected Category fCategory;

    public ModifyDialogTabPage(ModifyDialog modifyDialog, DefaultProfile defaultProfile, Category category, Map allPreferenceSettings) {
        this.fModifyDialog = modifyDialog;
        this.fDefaultProfile = defaultProfile;
        this.fCategory = category;
        this.fAllPreferenceSettings = allPreferenceSettings;
        this.fDefaultFocusManager = new DefaultFocusManager();
    }

    public final Composite createContents(Composite parent) {
        if (this.fPixelConverter == null) {
            this.fPixelConverter = new PixelConverter((Control)parent);
        }
        SashForm fSashForm = new SashForm(parent, 256);
        fSashForm.setFont(parent.getFont());
        Composite settingsPane = new Composite((Composite)fSashForm, 0);
        settingsPane.setFont(fSashForm.getFont());
        GridLayout layout = new GridLayout(4, false);
        layout.verticalSpacing = (int)(1.5 * (double)this.fPixelConverter.convertVerticalDLUsToPixels(4));
        layout.horizontalSpacing = this.fPixelConverter.convertHorizontalDLUsToPixels(4);
        layout.marginHeight = this.fPixelConverter.convertVerticalDLUsToPixels(7);
        layout.marginWidth = this.fPixelConverter.convertHorizontalDLUsToPixels(7);
        settingsPane.setLayout((Layout)layout);
        this.doCreatePreferences(settingsPane, 4);
        Composite previewPane = new Composite((Composite)fSashForm, 0);
        previewPane.setLayout((Layout)this.createGridLayout(4, true));
        previewPane.setFont(fSashForm.getFont());
        this.doCreatePreviewPane(previewPane, 4);
        this.initializePage();
        fSashForm.setWeights(new int[]{3, 3});
        return fSashForm;
    }

    protected void initializePage() {
        String previewCode = "";
        Preview preview = this.fCategory.getPreview();
        if (preview != null) {
            previewCode = preview.getCode();
        }
        this.fPreview.setPreviewText(previewCode);
    }

    public void dispose() {
        if (this.fPreview != null) {
            this.fPreview.dispose();
            this.fPreview = null;
        }
    }

    protected void doCreatePreferences(Composite composite, int numColumns) {
        EList groups = this.fCategory.getGroup();
        String categoryID = this.fCategory.getId();
        for (org.eclipse.edt.ide.ui.internal.formatting.profile.Group group : groups) {
            String grpTitle = FormatProfileRootHelper.getFormattingProfileNLSString(group.getDisplay());
            Composite grpComposite = composite;
            if (grpTitle != null && grpTitle.length() > 0) {
                grpComposite = this.createGroup(numColumns, composite, grpTitle);
            }
            EList prefs = group.getPref();
            for (Preference pref : prefs) {
                org.eclipse.edt.ide.ui.internal.formatting.profile.Control control;
                org.eclipse.edt.ide.ui.internal.formatting.profile.Control controlInstance = control = pref.getControl();
                if (control instanceof ReferenceControl) {
                    ReferenceControl refControl = (ReferenceControl)control;
                    controlInstance = FormatProfileRootHelper.getReferencedControl(this.fDefaultProfile, refControl);
                }
                String labelText = FormatProfileRootHelper.getFormattingProfileNLSString(pref.getDisplay(), ".");
                String prefID = pref.getId();
                Preview preview = pref.getPreview();
                String previewTextPerPreference = preview != null ? preview.getCode() : null;
                boolean isVisible = pref.isVisible();
                if (!isVisible) continue;
                if (controlInstance instanceof TextControl) {
                    this.createNumberPref(grpComposite, numColumns, labelText, categoryID, prefID, 0, 255, previewTextPerPreference);
                    continue;
                }
                if (controlInstance instanceof ComboControl) {
                    ComboControl comboControl = (ComboControl)controlInstance;
                    String[] displayItems = FormatProfileRootHelper.parseChoices(FormatProfileRootHelper.getFormattingProfileNLSString(comboControl.getChoices(), ","));
                    this.createComboPref(grpComposite, numColumns, labelText, categoryID, prefID, displayItems, displayItems, previewTextPerPreference);
                    continue;
                }
                if (controlInstance instanceof CheckControl) {
                    this.createCheckboxPref(grpComposite, numColumns, labelText, categoryID, prefID, previewTextPerPreference);
                    continue;
                }
                if (controlInstance instanceof RadioControl || !(controlInstance instanceof TreeControl)) continue;
                this.createTreePref(pref);
            }
        }
    }

    protected String getCurrentValue(String key) {
        Object valObj = this.fAllPreferenceSettings.get(key);
        if (valObj != null) {
            return ((ProfileManager.PreferenceSettingValue)valObj).getCurrentValue();
        }
        return "";
    }

    protected void setCurrentValue(String key, String currValue) {
        Object obj = this.fAllPreferenceSettings.get(key);
        if (obj != null) {
            ProfileManager.PreferenceSettingValue settingValue = (ProfileManager.PreferenceSettingValue)obj;
            settingValue.setCurrValue(currValue);
        }
    }

    protected Composite doCreatePreviewPane(Composite composite, int numColumns) {
        ModifyDialogTabPage.createLabel(numColumns, composite, NewWizardMessages.Preview);
        EGLPreview preview = this.doCreateEGLPreview(composite);
        this.fDefaultFocusManager.add(preview.getControl());
        GridData gd = ModifyDialogTabPage.createGridData(numColumns, 1808, 0);
        gd.widthHint = 0;
        gd.heightHint = 0;
        preview.getControl().setLayoutData((Object)gd);
        return composite;
    }

    protected EGLPreview doCreateEGLPreview(Composite parent) {
        this.fPreview = new EGLPreview(parent, this.fAllPreferenceSettings);
        return this.fPreview;
    }

    public final void makeVisible() {
        this.fDefaultFocusManager.resetFocus();
        this.doUpdatePreview();
    }

    protected void doUpdatePreview() {
        this.fPreview.update();
    }

    protected void notifyValuesModified() {
        this.fModifyDialog.valuesModified();
    }

    public void setInitialFocus() {
        if (this.fDefaultFocusManager.isUsed()) {
            this.fDefaultFocusManager.restoreFocus();
        }
    }

    protected void updateStatus(IStatus status) {
        this.fModifyDialog.updateStatus(status);
    }

    protected GridLayout createGridLayout(int numColumns, boolean margins) {
        GridLayout layout = new GridLayout(numColumns, false);
        layout.verticalSpacing = this.fPixelConverter.convertVerticalDLUsToPixels(4);
        layout.horizontalSpacing = this.fPixelConverter.convertHorizontalDLUsToPixels(4);
        if (margins) {
            layout.marginHeight = this.fPixelConverter.convertVerticalDLUsToPixels(7);
            layout.marginWidth = this.fPixelConverter.convertHorizontalDLUsToPixels(7);
        } else {
            layout.marginHeight = 0;
            layout.marginWidth = 0;
        }
        return layout;
    }

    protected static GridData createGridData(int numColumns, int style, int widthHint) {
        GridData gd = new GridData(style);
        gd.horizontalSpan = numColumns;
        gd.widthHint = widthHint;
        return gd;
    }

    protected static Label createLabel(int numColumns, Composite parent, String text) {
        return ModifyDialogTabPage.createLabel(numColumns, parent, text, 768);
    }

    protected static Label createLabel(int numColumns, Composite parent, String text, int gridDataStyle) {
        Label label = new Label(parent, 64);
        label.setFont(parent.getFont());
        label.setText(text);
        label.setLayoutData((Object)ModifyDialogTabPage.createGridData(numColumns, gridDataStyle, -1));
        return label;
    }

    protected Group createGroup(int numColumns, Composite parent, String text) {
        Group group = new Group(parent, 0);
        group.setFont(parent.getFont());
        group.setLayoutData((Object)ModifyDialogTabPage.createGridData(numColumns, 768, -1));
        GridLayout layout = new GridLayout(numColumns, false);
        layout.verticalSpacing = this.fPixelConverter.convertVerticalDLUsToPixels(4);
        layout.horizontalSpacing = this.fPixelConverter.convertHorizontalDLUsToPixels(4);
        layout.marginHeight = this.fPixelConverter.convertVerticalDLUsToPixels(4);
        group.setLayout((Layout)layout);
        group.setText(text);
        return group;
    }

    protected NumberPreference createNumberPref(Composite composite, int numColumns, String labelText, String categoryID, String prefID, int minValue, int maxValue, String previewTextPerPreference) {
        NumberPreference pref = new NumberPreference(composite, numColumns, categoryID, prefID, minValue, maxValue, labelText, previewTextPerPreference);
        this.fDefaultFocusManager.add(pref);
        pref.addObserver(this.fUpdater);
        return pref;
    }

    protected ComboPreference createComboPref(Composite composite, int numColumns, String labelText, String categoryID, String prefID, String[] values, String[] items, String previewTextPerPreference) {
        ComboPreference pref = new ComboPreference(composite, numColumns, categoryID, prefID, values, labelText, items, previewTextPerPreference);
        this.fDefaultFocusManager.add(pref);
        pref.addObserver(this.fUpdater);
        return pref;
    }

    protected CheckboxPreference createCheckboxPref(Composite composite, int numColumns, String labelText, String categoryID, String prefID, String previewTextPerPreference) {
        CheckboxPreference pref = new CheckboxPreference(composite, numColumns, categoryID, prefID, labelText, previewTextPerPreference);
        this.fDefaultFocusManager.add(pref);
        pref.addObserver(this.fUpdater);
        return pref;
    }

    protected void createTreePref(Preference pref) {
    }

    protected final class CheckboxPreference
    extends PreferenceWidget {
        private final Button fCheckbox;

        public CheckboxPreference(Composite composite, int numColumns, String categoryID, String prefID, String labelText, String previewTextPerPreference) {
            super(categoryID, prefID, previewTextPerPreference);
            this.fCheckbox = new Button(composite, 32);
            this.fCheckbox.setText(labelText);
            this.fCheckbox.setLayoutData((Object)ModifyDialogTabPage.createGridData(numColumns, 768, -1));
            this.fCheckbox.setFont(composite.getFont());
            this.updateWidget();
            this.fCheckbox.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    CheckboxPreference.this.checkboxChecked(((Button)e.widget).getSelection());
                }
            });
        }

        protected void checkboxChecked(boolean state) {
            ModifyDialogTabPage.this.setCurrentValue(this.getKey(), String.valueOf(state));
            this.setChanged();
            this.notifyObservers();
        }

        @Override
        protected void updateWidget() {
            String key = this.getKey();
            if (key != null) {
                this.fCheckbox.setEnabled(this.getEnabled());
                this.fCheckbox.setSelection(Boolean.parseBoolean(ModifyDialogTabPage.this.getCurrentValue(key)));
            } else {
                this.fCheckbox.setSelection(false);
                this.fCheckbox.setEnabled(false);
            }
        }

        @Override
        public Control getControl() {
            return this.fCheckbox;
        }
    }

    protected final class ComboPreference
    extends PreferenceWidget {
        private Label fLabel;
        private final Combo fCombo;

        public ComboPreference(Composite composite, int numColumns, String categoryID, String prefID, String[] values, String labelText, String[] displayItems, String previewTextPerPreference) {
            super(categoryID, prefID, previewTextPerPreference);
            if (values == null || displayItems == null || labelText == null) {
                throw new IllegalArgumentException(NewWizardMessages.ArgsNotAssigned);
            }
            this.fLabel = ModifyDialogTabPage.createLabel(numColumns - 1, composite, labelText);
            this.fCombo = new Combo(composite, 12);
            this.fCombo.setFont(composite.getFont());
            this.fCombo.setItems(displayItems);
            int max = 0;
            int i = 0;
            while (i < displayItems.length) {
                if (displayItems[i].length() > max) {
                    max = displayItems[i].length();
                }
                ++i;
            }
            this.fCombo.setLayoutData((Object)ModifyDialogTabPage.createGridData(1, 256, this.fCombo.computeSize((int)-1, (int)-1).x));
            this.updateWidget();
            this.fCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    ComboPreference.this.comboSelected(((Combo)e.widget).getSelectionIndex());
                }
            });
        }

        protected void comboSelected(int index) {
            ModifyDialogTabPage.this.setCurrentValue(this.getKey(), String.valueOf(index));
            this.setChanged();
            this.notifyObservers(new Integer(index));
        }

        @Override
        protected void updateWidget() {
            String key = this.getKey();
            if (key != null) {
                this.fCombo.setEnabled(this.getEnabled());
                int selIndex = Integer.parseInt(ModifyDialogTabPage.this.getCurrentValue(key));
                this.fCombo.select(selIndex);
            } else {
                this.fCombo.setText("");
                this.fCombo.setEnabled(false);
            }
        }

        @Override
        public Control getControl() {
            return this.fCombo;
        }

        public Label getLabel() {
            return this.fLabel;
        }
    }

    protected static final class DefaultFocusManager
    extends FocusAdapter {
        private static final String PREF_LAST_FOCUS_INDEX = "org.eclipse.edt.ide.uiformatter_page.modify_dialog_tab_page.last_focus_index";
        private final IDialogSettings fDialogSettings = EDTUIPlugin.getDefault().getDialogSettings();
        private final Map fItemMap = new HashMap();
        private final List fItemList = new ArrayList();
        private int fIndex = 0;

        public void focusGained(FocusEvent e) {
            this.fDialogSettings.put(PREF_LAST_FOCUS_INDEX, ((Integer)this.fItemMap.get(e.widget)).intValue());
        }

        public void add(Control control) {
            control.addFocusListener((FocusListener)this);
            this.fItemList.add(this.fIndex, control);
            this.fItemMap.put(control, new Integer(this.fIndex++));
        }

        public void add(PreferenceWidget preferenceWidget) {
            Control control = preferenceWidget.getControl();
            if (control != null) {
                this.add(control);
            }
        }

        public boolean isUsed() {
            return this.fIndex != 0;
        }

        public void restoreFocus() {
            int index = 0;
            try {
                index = this.fDialogSettings.getInt(PREF_LAST_FOCUS_INDEX);
                if (index >= 0 && index <= this.fItemList.size() - 1) {
                    ((Control)this.fItemList.get(index)).setFocus();
                }
            }
            catch (NumberFormatException numberFormatException) {}
        }

        public void resetFocus() {
            this.fDialogSettings.put(PREF_LAST_FOCUS_INDEX, -1);
        }
    }

    protected final class NumberPreference
    extends PreferenceWidget {
        private final int fMinValue;
        private final int fMaxValue;
        private final Label fNumberLabel;
        private final Text fNumberText;
        protected int fSelected;
        protected int fOldSelected;

        public NumberPreference(Composite composite, int numColumns, String categoryID, String prefID, int minValue, int maxValue, String labelText, String previewTextPerPreference) {
            super(categoryID, prefID, previewTextPerPreference);
            this.fNumberLabel = ModifyDialogTabPage.createLabel(numColumns - 1, composite, labelText, 768);
            this.fNumberText = new Text(composite, 133124);
            this.fNumberText.setFont(composite.getFont());
            int length = Integer.toString(maxValue).length() + 3;
            this.fNumberText.setLayoutData((Object)ModifyDialogTabPage.createGridData(1, 128, ModifyDialogTabPage.this.fPixelConverter.convertWidthInCharsToPixels(length)));
            this.fMinValue = minValue;
            this.fMaxValue = maxValue;
            this.updateWidget();
            this.fNumberText.addFocusListener(new FocusListener(){

                public void focusGained(FocusEvent e) {
                    NumberPreference.this.focusGained();
                }

                public void focusLost(FocusEvent e) {
                    NumberPreference.this.focusLost();
                }
            });
            this.fNumberText.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    NumberPreference.this.fieldModified();
                }
            });
        }

        private IStatus createErrorStatus() {
            return new Status(4, EDTUIPlugin.getPluginId(), 0, NewWizardMessages.bind((String)NewWizardMessages.InvalidNumber, (Object[])new String[]{Integer.toString(this.fMinValue), Integer.toString(this.fMaxValue)}), null);
        }

        protected void focusGained() {
            this.fOldSelected = this.fSelected;
            this.fNumberText.setSelection(0, this.fNumberText.getCharCount());
        }

        protected void focusLost() {
            ModifyDialogTabPage.this.updateStatus(null);
            String input = this.fNumberText.getText();
            this.fSelected = !this.validInput(input) ? this.fOldSelected : Integer.parseInt(input);
            if (this.fSelected != this.fOldSelected) {
                this.saveSelected();
            }
            this.fNumberText.setText(Integer.toString(this.fSelected));
        }

        protected void fieldModified() {
            int number;
            String trimInput = this.fNumberText.getText().trim();
            boolean valid = this.validInput(trimInput);
            ModifyDialogTabPage.this.updateStatus(valid ? null : this.createErrorStatus());
            if (valid && this.fSelected != (number = Integer.parseInt(trimInput))) {
                this.fSelected = number;
                this.saveSelected();
            }
        }

        private boolean validInput(String trimInput) {
            int number;
            try {
                number = Integer.parseInt(trimInput);
            }
            catch (NumberFormatException numberFormatException) {
                return false;
            }
            if (number < this.fMinValue) {
                return false;
            }
            return number <= this.fMaxValue;
        }

        private void saveSelected() {
            this.fOldSelected = this.fSelected;
            ModifyDialogTabPage.this.setCurrentValue(this.getKey(), String.valueOf(this.fSelected));
            this.setChanged();
            this.notifyObservers();
        }

        @Override
        protected void updateWidget() {
            String key = this.getKey();
            boolean hasKey = key != null;
            this.fNumberLabel.setEnabled(hasKey && this.getEnabled());
            this.fNumberText.setEnabled(hasKey && this.getEnabled());
            if (hasKey) {
                String s = ModifyDialogTabPage.this.getCurrentValue(key);
                try {
                    this.fSelected = Integer.parseInt(s);
                }
                catch (NumberFormatException e) {
                    String message = NewWizardMessages.bind((String)NewWizardMessages.InvalidIntergerValue, (Object)this.getKey());
                    EDTUIPlugin.log((IStatus)new Status(4, EDTUIPlugin.getPluginId(), 0, message, (Throwable)e));
                    s = "";
                }
                this.fNumberText.setText(s);
            } else {
                this.fNumberText.setText("");
            }
        }

        @Override
        public Control getControl() {
            return this.fNumberText;
        }
    }

    protected static class OptionLeafNode
    implements Comparable {
        Object fParent;
        String fPreferenceKey = "";
        String fDisplay = "";
        String fPreviewText = "";
        private String fResolvedRef = "";

        public OptionLeafNode(String display, Object parent) {
            this.fDisplay = display;
            this.fParent = parent;
        }

        public int compareTo(Object arg0) {
            OptionLeafNode other = (OptionLeafNode)arg0;
            return this.fDisplay.compareTo(other.fDisplay);
        }

        public boolean isPreviewAReference() {
            return this.fResolvedRef != null && this.fResolvedRef.length() > 0;
        }

        public String getResolvedPreviewRef() {
            return this.fResolvedRef;
        }

        public void setResolvedPreviewRef(String ref) {
            this.fResolvedRef = ref;
        }
    }

    protected static class OptionTreeContentProvider
    implements ITreeContentProvider {
        public Object[] getChildren(Object parentElement) {
            ArrayList children = new ArrayList();
            if (parentElement instanceof Collection) {
                children.addAll((Collection)parentElement);
            } else if (parentElement instanceof OptionTreeNode) {
                OptionTreeNode wsnode = (OptionTreeNode)parentElement;
                children.addAll(wsnode.getChildren().values());
            }
            return children.toArray();
        }

        public Object getParent(Object element) {
            if (element instanceof OptionLeafNode) {
                return ((OptionLeafNode)element).fParent;
            }
            if (element instanceof OptionTreeNode) {
                return ((OptionTreeNode)element).getParent();
            }
            return null;
        }

        public boolean hasChildren(Object element) {
            return this.getChildren(element).length > 0;
        }

        public Object[] getElements(Object inputElement) {
            return this.getChildren(inputElement);
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }

    protected static class OptionTreeLabelProvider
    extends LabelProvider {
        protected OptionTreeLabelProvider() {
        }

        public String getText(Object element) {
            if (element instanceof OptionTreeNode) {
                return ((OptionTreeNode)element).getDisplay();
            }
            if (element instanceof OptionLeafNode) {
                return ((OptionLeafNode)element).fDisplay;
            }
            return super.getText(element);
        }
    }

    protected static class OptionTreeNode {
        private String fDisplay;
        private SortedMap fChildren = new TreeMap();
        private OptionTreeNode fParent;

        public OptionTreeNode(String display, OptionTreeNode parent) {
            this.fDisplay = display;
            this.fParent = parent;
        }

        public String getDisplay() {
            return this.fDisplay;
        }

        public OptionTreeNode getParent() {
            return this.fParent;
        }

        public Map getChildren() {
            return this.fChildren;
        }

        public boolean hasChildren() {
            return !this.fChildren.isEmpty();
        }

        public OptionTreeNode addChild(String display) {
            OptionTreeNode addedChild = null;
            Object obj = this.fChildren.get(display);
            if (obj == null) {
                OptionTreeNode newWSNode = new OptionTreeNode(display, this);
                this.fChildren.put(display, newWSNode);
                addedChild = newWSNode;
            } else if (obj instanceof OptionTreeNode) {
                addedChild = (OptionTreeNode)obj;
            }
            return addedChild;
        }

        public OptionLeafNode addChild(String display, String preferenceKey, Preference pref) {
            Object obj = this.fChildren.get(display);
            OptionLeafNode optionLeafNode = null;
            if (obj == null) {
                optionLeafNode = new OptionLeafNode(display, this);
                this.fChildren.put(display, optionLeafNode);
            } else if (obj instanceof OptionLeafNode) {
                optionLeafNode = (OptionLeafNode)obj;
            }
            optionLeafNode.fDisplay = display;
            optionLeafNode.fParent = this;
            optionLeafNode.fPreferenceKey = preferenceKey;
            this.setPreviewForOptionLeafNode(optionLeafNode, pref);
            return optionLeafNode;
        }

        private void setPreviewForOptionLeafNode(OptionLeafNode optionLeafNode, Preference pref) {
            Preview preview = pref.getPreview();
            if (preview != null) {
                String previewRef = preview.getRef();
                if (previewRef != null && previewRef.length() > 0) {
                    optionLeafNode.setResolvedPreviewRef(previewRef);
                    EObject parentNode = pref.eContainer();
                    while (parentNode != null && !(parentNode instanceof DefaultProfile)) {
                        parentNode = parentNode.eContainer();
                    }
                    if (parentNode instanceof DefaultProfile) {
                        DefaultProfile defaultProfile = (DefaultProfile)parentNode;
                        String[] ids = CodeFormatterConstants.getCategoryIDnPrefID(previewRef);
                        Preference refedPref = FormatProfileRootHelper.getPreferenceByID(defaultProfile, ids[0], ids[1]);
                        this.setPreviewForOptionLeafNode(optionLeafNode, refedPref);
                    }
                } else {
                    String previewCode = preview.getCode();
                    if (previewCode != null) {
                        optionLeafNode.fPreviewText = previewCode;
                    }
                }
            }
        }
    }

    protected abstract class PreferenceWidget
    extends Observable {
        private boolean fEnabled = true;
        private String fCategoryID;
        private String fPrefID;
        protected String fPrefPreviewCode;

        public PreferenceWidget(String catID, String prefID, String previewTextPerPreference) {
            this.fCategoryID = catID;
            this.fPrefID = prefID;
            this.fPrefPreviewCode = previewTextPerPreference;
        }

        public final void setEnabled(boolean enabled) {
            this.fEnabled = enabled;
            this.updateWidget();
        }

        public final boolean getEnabled() {
            return this.fEnabled;
        }

        protected final String getKey() {
            return CodeFormatterConstants.getPreferenceSettingKey(this.fCategoryID, this.fPrefID);
        }

        public abstract Control getControl();

        protected abstract void updateWidget();
    }

    protected abstract class TreeControlPreference
    implements ISelectionChangedListener,
    IDoubleClickListener {
        protected Object fLastSelected = null;
        private final List fIndexedNodeList;
        private IDialogSettings fDialogSettings;
        private String fDialogSettingKey;
        protected TreeViewer fTreeViewer;
        protected SortedMap fOptionNodePreferenceTreeMap;

        protected TreeControlPreference(IDialogSettings dlgSetting, String dlgSettingKey) {
            this.fDialogSettings = dlgSetting;
            this.fDialogSettingKey = dlgSettingKey;
            this.fIndexedNodeList = new ArrayList();
            this.fOptionNodePreferenceTreeMap = new TreeMap();
        }

        protected abstract TreeViewer createTreeViewer(Composite var1, int var2);

        protected String getPreviewText(Object selectedTreeObj) {
            HashSet previewSet = new HashSet();
            return this.getNodePreviewText(selectedTreeObj, previewSet);
        }

        protected String getNodePreviewText(Object selectedTreeObj, Set set) {
            String delimiter = ModifyDialogTabPage.this.fPreview.getDefaultLineDelimiter();
            if (selectedTreeObj instanceof OptionTreeNode) {
                OptionTreeNode selNode = (OptionTreeNode)selectedTreeObj;
                StringBuffer buffer = new StringBuffer();
                for (Object val : selNode.getChildren().values()) {
                    this.addPreviewText2Buffer(buffer, delimiter, val, set);
                }
                return buffer.toString();
            }
            if (selectedTreeObj instanceof OptionLeafNode) {
                String prefKey2Check;
                OptionLeafNode optionLeafNode = (OptionLeafNode)selectedTreeObj;
                String string = prefKey2Check = optionLeafNode.isPreviewAReference() ? optionLeafNode.getResolvedPreviewRef() : optionLeafNode.fPreferenceKey;
                if (!set.contains(prefKey2Check)) {
                    set.add(prefKey2Check);
                    return optionLeafNode.fPreviewText;
                }
            }
            return "";
        }

        public void initialize() {
            this.fTreeViewer.addSelectionChangedListener((ISelectionChangedListener)this);
            this.fTreeViewer.addDoubleClickListener((IDoubleClickListener)this);
            this.fTreeViewer.setInput(this.fOptionNodePreferenceTreeMap.values());
            this.restoreSelection();
        }

        protected void createContents(int numColumns, Composite parent) {
            this.fTreeViewer = this.createTreeViewer(parent, numColumns);
            this.fTreeViewer.setContentProvider((IContentProvider)new OptionTreeContentProvider());
            this.fTreeViewer.setLabelProvider((IBaseLabelProvider)new OptionTreeLabelProvider());
            this.fTreeViewer.getControl().setLayoutData((Object)ModifyDialogTabPage.createGridData(numColumns, 1808, -1));
            ModifyDialogTabPage.this.fDefaultFocusManager.add(this.fTreeViewer.getControl());
            this.makeIndexedNodeList(this.fOptionNodePreferenceTreeMap);
        }

        protected void makeIndexedNodeList(Map map) {
            for (Object obj : map.values()) {
                this.fIndexedNodeList.add(obj);
                if (!(obj instanceof OptionTreeNode)) continue;
                OptionTreeNode wsnode = (OptionTreeNode)obj;
                this.makeIndexedNodeList(wsnode.getChildren());
            }
        }

        protected int getNodeIndex(Object node) {
            int index = 0;
            Iterator it = this.fIndexedNodeList.iterator();
            while (it.hasNext()) {
                if (node.equals(it.next())) {
                    return index;
                }
                ++index;
            }
            return -1;
        }

        protected void restoreSelection() {
            Object node;
            int index;
            try {
                index = this.fDialogSettings.getInt(this.fDialogSettingKey);
            }
            catch (NumberFormatException numberFormatException) {
                index = -1;
            }
            if (index < 0 || index > this.fIndexedNodeList.size() - 1) {
                index = 0;
            }
            if (!this.fIndexedNodeList.isEmpty() && (node = this.fIndexedNodeList.get(index)) != null) {
                this.fTreeViewer.expandToLevel(node, 0);
                this.fTreeViewer.setSelection((ISelection)new StructuredSelection(new Object[]{node}));
                this.fLastSelected = node;
            }
        }

        public void selectionChanged(SelectionChangedEvent event) {
            IStructuredSelection selection = (IStructuredSelection)event.getSelection();
            if (selection.isEmpty()) {
                return;
            }
            Object obj = selection.getFirstElement();
            if (obj == this.fLastSelected) {
                return;
            }
            this.fDialogSettings.put(this.fDialogSettingKey, this.getNodeIndex(obj));
            ModifyDialogTabPage.this.fPreview.setPreviewText(this.getPreviewText(obj));
            ModifyDialogTabPage.this.doUpdatePreview();
            this.fLastSelected = obj;
        }

        public void doubleClick(DoubleClickEvent event) {
            ISelection selection = event.getSelection();
            if (selection instanceof IStructuredSelection) {
                Object obj;
                this.fTreeViewer.setExpandedState(obj, !this.fTreeViewer.getExpandedState(obj = ((IStructuredSelection)selection).getFirstElement()));
            }
        }

        protected void addPreviewText2Buffer(StringBuffer buffer, String delimiter, Object obj, Set set) {
            String nodePreviewText = this.getNodePreviewText(obj, set);
            if (nodePreviewText.trim().length() > 0) {
                buffer.append(delimiter);
                buffer.append(nodePreviewText);
                buffer.append(delimiter);
            }
        }

        protected void populatePreferenceMapData(Preference pref, EAttribute preferenceAttribute) {
            Object attribVal = pref.eGet((EStructuralFeature)preferenceAttribute);
            if (attribVal != null) {
                String display = (String)attribVal;
                display = FormatProfileRootHelper.getFormattingProfileNLSString(display, ".");
                String[] displays = FormatProfileRootHelper.parseTokenizedString(display, ".");
                String prefKey = CodeFormatterConstants.getPreferenceSettingKey(ModifyDialogTabPage.this.fCategory.getId(), pref.getId());
                String key = displays[0];
                Object obj = this.fOptionNodePreferenceTreeMap.get(key);
                OptionTreeNode wsnode = null;
                if (obj == null) {
                    wsnode = new OptionTreeNode(key, null);
                    this.fOptionNodePreferenceTreeMap.put(key, wsnode);
                } else {
                    wsnode = (OptionTreeNode)obj;
                }
                int i = 1;
                while (i < displays.length) {
                    key = displays[i];
                    if (i != displays.length - 1) {
                        wsnode = wsnode.addChild(key);
                    } else {
                        wsnode.addChild(key, prefKey, pref);
                    }
                    ++i;
                }
            }
        }
    }
}

