/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.ui.internal.handlers;

import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.IHandler;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.edt.ide.core.model.EGLCore;
import org.eclipse.edt.ide.core.model.EGLModelException;
import org.eclipse.edt.ide.core.model.IClassFile;
import org.eclipse.edt.ide.core.model.IEGLElement;
import org.eclipse.edt.ide.core.model.IEGLFile;
import org.eclipse.edt.ide.core.model.IEGLProject;
import org.eclipse.edt.ide.core.model.IPackageFragment;
import org.eclipse.edt.ide.core.model.IPackageFragmentRoot;
import org.eclipse.edt.ide.ui.EDTUIPlugin;
import org.eclipse.edt.ide.ui.internal.editor.BinaryEditorInput;
import org.eclipse.edt.ide.ui.internal.editor.EGLEditor;
import org.eclipse.edt.ide.ui.internal.editor.IEGLEditorWrapper;
import org.eclipse.edt.ide.ui.internal.util.EditorUtility;
import org.eclipse.jface.text.ITextOperationTarget;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.handlers.HandlerUtil;

public abstract class EGLHandler
extends AbstractHandler
implements IHandler {
    protected IStructuredSelection fSelection;
    protected IWorkbenchSite fSite;
    protected EGLEditor fEditor;
    protected Hashtable fileNeedsSave = new Hashtable();

    public abstract void run();

    public Object execute(ExecutionEvent event) throws ExecutionException {
        IEditorPart editor = this.getCurrentActiveEditor(event);
        if (editor instanceof EGLEditor) {
            this.fEditor = (EGLEditor)editor;
            if (editor != null) {
                IClassFile classFile;
                IEditorInput editorInput = editor.getEditorInput();
                if (editorInput instanceof IFileEditorInput) {
                    IFile resource = ((IFileEditorInput)editorInput).getFile();
                    IEGLElement element = EGLCore.create((IResource)resource);
                    this.fSite = editor.getSite();
                    this.fSelection = new StructuredSelection((Object)element);
                } else if (editorInput instanceof BinaryEditorInput && (classFile = ((BinaryEditorInput)editorInput).getClassFile()) != null) {
                    this.fSite = editor.getSite();
                    this.fSelection = new StructuredSelection((Object)classFile);
                }
            }
        }
        if (this.fSelection != null) {
            this.run();
        }
        return null;
    }

    protected List getEGLFiles(IStructuredSelection selection) {
        ArrayList result = new ArrayList();
        if (selection != null) {
            Iterator it = selection.iterator();
            while (it.hasNext()) {
                try {
                    Object element = it.next();
                    if (element instanceof IEGLElement) {
                        IEGLElement eglElem = (IEGLElement)element;
                        this.getEGLElements(eglElem, result);
                        continue;
                    }
                    if (element instanceof IProject) {
                        IEGLProject eglproj = EGLCore.create((IProject)((IProject)element));
                        this.getEGLElements((IEGLElement)eglproj, result);
                        continue;
                    }
                    if (!(element instanceof IResource)) continue;
                    IEGLElement eglResourceElem = EGLCore.create((IResource)((IResource)element));
                    this.getEGLElements(eglResourceElem, result);
                }
                catch (EGLModelException e) {
                    EDTUIPlugin.log(e);
                }
            }
        }
        return result;
    }

    private void getEGLElements(IEGLElement eglElem, List result) throws EGLModelException {
        if (eglElem != null) {
            switch (eglElem.getElementType()) {
                case 2: {
                    IPackageFragmentRoot[] pkgRoots = ((IEGLProject)eglElem).getPackageFragmentRoots();
                    int i = 0;
                    while (i < pkgRoots.length) {
                        this.collectEGLFiles(pkgRoots[i], result);
                        ++i;
                    }
                    break;
                }
                case 3: {
                    this.collectEGLFiles((IPackageFragmentRoot)eglElem, result);
                    break;
                }
                case 4: {
                    this.collectEGLFiles((IPackageFragment)eglElem, result);
                    break;
                }
                case 6: {
                    result.add(eglElem);
                    this.fileNeedsSave.put(eglElem, new Boolean(this.needSave((IEGLFile)eglElem)));
                }
            }
        }
    }

    protected void collectEGLFiles(IPackageFragment pkg, List result) throws EGLModelException {
        IEGLFile[] eglfiles = pkg.getEGLFiles();
        int i = 0;
        while (i < eglfiles.length) {
            result.add(eglfiles[i]);
            this.fileNeedsSave.put(eglfiles[i], new Boolean(this.needSave(eglfiles[i])));
            ++i;
        }
    }

    protected void collectEGLFiles(IPackageFragmentRoot pkgRoot, List result) throws EGLModelException {
        if (pkgRoot.getKind() == 1) {
            IEGLElement[] children = pkgRoot.getChildren();
            int i = 0;
            while (i < children.length) {
                this.collectEGLFiles((IPackageFragment)children[i], result);
                ++i;
            }
        }
    }

    private boolean needSave(IEGLFile eglfile) {
        boolean needSave = false;
        IEditorPart editor = EditorUtility.isOpenInEditor(eglfile);
        if (editor == null) {
            needSave = true;
        } else if (editor instanceof EGLEditor) {
            this.fEditor = (EGLEditor)editor;
        }
        return needSave;
    }

    protected void doTextOperation(final int operationCode) {
        final ITextOperationTarget fOperationTarget = (ITextOperationTarget)this.fEditor.getAdapter(ITextOperationTarget.class);
        if (fOperationTarget != null && fOperationTarget.canDoOperation(operationCode)) {
            Display display = null;
            Shell shell = this.fSite.getShell();
            if (shell != null && !shell.isDisposed()) {
                display = shell.getDisplay();
            }
            BusyIndicator.showWhile((Display)display, (Runnable)new Runnable(){

                @Override
                public void run() {
                    fOperationTarget.doOperation(operationCode);
                }
            });
        }
    }

    protected IEditorPart getCurrentActiveEditor(ExecutionEvent event) {
        Object editor = HandlerUtil.getActiveEditor((ExecutionEvent)event);
        if (editor instanceof IEGLEditorWrapper) {
            editor = ((IEGLEditorWrapper)editor).getEGLEditor();
        }
        return editor;
    }

    protected boolean isInvokedFromEditorContext(ExecutionEvent event) {
        ISelection selection = HandlerUtil.getActiveWorkbenchWindow((ExecutionEvent)event).getSelectionService().getSelection();
        if (selection instanceof IStructuredSelection) {
            this.fSelection = (IStructuredSelection)selection;
            this.fSite = HandlerUtil.getActiveSite((ExecutionEvent)event);
            return false;
        }
        return true;
    }
}

