/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.ui.internal.handlers.folding;

import org.eclipse.core.commands.Command;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.State;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.edt.ide.core.model.EGLCore;
import org.eclipse.edt.ide.core.model.IEGLElement;
import org.eclipse.edt.ide.ui.EDTUIPlugin;
import org.eclipse.edt.ide.ui.internal.editor.EGLEditor;
import org.eclipse.edt.ide.ui.internal.handlers.folding.FoldingHandler;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.commands.ICommandService;
import org.eclipse.ui.handlers.HandlerUtil;

public class FoldingToggleHandler
extends FoldingHandler {
    @Override
    public Object execute(ExecutionEvent event) throws ExecutionException {
        IEditorPart editor = this.getCurrentActiveEditor(event);
        if (editor instanceof EGLEditor) {
            IEditorInput editorInput;
            this.fEditor = (EGLEditor)editor;
            if (editor != null && (editorInput = editor.getEditorInput()) instanceof IFileEditorInput) {
                IFile resource = ((IFileEditorInput)editorInput).getFile();
                IEGLElement element = EGLCore.create((IResource)resource);
                this.fSite = editor.getSite();
                this.fSelection = new StructuredSelection((Object)element);
            }
        }
        if (this.fSelection != null) {
            IPreferenceStore store;
            boolean current = (store = EDTUIPlugin.getDefault().getPreferenceStore()).getBoolean("editor_folding_enabled");
            store.setValue("editor_folding_enabled", !current);
            Command command = event.getCommand();
            HandlerUtil.toggleCommandState((Command)command);
        }
        return null;
    }

    @Override
    public boolean isEnabled() {
        ICommandService service = (ICommandService)PlatformUI.getWorkbench().getService(ICommandService.class);
        Command command = service.getCommand("org.eclipse.edt.ide.ui.ruler.folding.toggle");
        State state = command.getState("org.eclipse.ui.commands.toggleState");
        IPreferenceStore store = EDTUIPlugin.getDefault().getPreferenceStore();
        state.setValue((Object)store.getBoolean("editor_folding_enabled"));
        return true;
    }
}

