/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.ui.internal.outline;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.edt.compiler.core.ast.ArrayType;
import org.eclipse.edt.compiler.core.ast.Expression;
import org.eclipse.edt.compiler.core.ast.Name;
import org.eclipse.edt.compiler.core.ast.Node;
import org.eclipse.edt.compiler.core.ast.Part;
import org.eclipse.edt.compiler.core.ast.SettingsBlock;
import org.eclipse.edt.compiler.core.ast.Type;
import org.eclipse.edt.ide.core.internal.utils.EGLSourceFormatUtil;
import org.eclipse.edt.ide.ui.internal.editor.EGLEditor;
import org.eclipse.edt.ide.ui.internal.outline.IOutlineAdapter;
import org.eclipse.edt.ide.ui.internal.outline.OutlineAdapterFactory;
import org.eclipse.edt.ide.ui.internal.viewsupport.ElementImageProvider;
import org.eclipse.edt.mof.egl.ParameterizedType;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Region;
import org.eclipse.swt.graphics.Image;

public abstract class AbstractOutlineAdapter
implements IOutlineAdapter {
    protected ImageDescriptor nodeIcon;
    protected int fImageFlags;
    protected ElementImageProvider fImageLabelProvider = new ElementImageProvider();
    protected EGLEditor editor;
    protected static OutlineAdapterFactory factory = new OutlineAdapterFactory(null, null);

    public AbstractOutlineAdapter(EGLEditor editor) {
        this.editor = editor;
    }

    @Override
    public Object[] getChildren(Object parentElement) {
        return new Object[0];
    }

    @Override
    public IRegion getHighlightRange(Object element) {
        return new Region(0, 0);
    }

    protected IRegion getPartNameHighlightRange(Part part) {
        return new Region(part.getName().getOffset(), part.getName().getLength());
    }

    @Override
    public Object getParent(Object element) {
        Node node = (Node)element;
        while ((node = node.getParent()) != null && !factory.isDisplayableElement(node)) {
        }
        return node;
    }

    @Override
    public String getText(Object element) {
        return element.getClass().toString();
    }

    @Override
    public boolean hasChildren(Object element) {
        Object[] children = this.getChildren(element);
        return children != null && children.length > 0;
    }

    private String formatArrayType(ArrayType arraytype) {
        Type elemType = arraytype.getElementType();
        StringBuffer typeDisplay = new StringBuffer(this.formatType(elemType));
        typeDisplay.append('[');
        if (arraytype.hasInitialSize()) {
            Expression expr = arraytype.getInitialSize();
            typeDisplay.append(expr.getCanonicalString());
        }
        typeDisplay.append(']');
        return typeDisplay.toString();
    }

    public String formatType(Type type) {
        StringBuffer typeDisplay = new StringBuffer();
        if (type instanceof ArrayType) {
            typeDisplay.append(this.formatArrayType((ArrayType)type));
        } else {
            org.eclipse.edt.mof.egl.Type typeBinding = type.resolveType();
            if (typeBinding instanceof ParameterizedType) {
                typeDisplay.append(typeBinding.getTypeSignature());
            } else {
                typeDisplay.append(type.toString());
            }
        }
        return EGLSourceFormatUtil.getInstance().formatForGenerator(typeDisplay.toString());
    }

    public List filterOutProperties(List children) {
        ArrayList modified = new ArrayList();
        int i = 0;
        while (i < children.size()) {
            if (!(children.get(i) instanceof SettingsBlock)) {
                modified.add(children.get(i));
            }
            ++i;
        }
        return modified;
    }

    @Override
    public Image getImage(Object element) {
        this.fImageFlags = 0;
        Image result = null;
        if (element instanceof Node) {
            Node node = (Node)element;
            if (this.hasErrorsOrNestedErrors(node)) {
                this.fImageFlags = 64;
            } else if (this.hasWarningsOrNestedWarnings(node)) {
                this.fImageFlags = 32;
            }
        }
        if (this.nodeIcon != null) {
            result = this.fImageLabelProvider.getImageLabel(this.nodeIcon, this.fImageFlags);
        }
        return result;
    }

    @Override
    public void dispose() {
    }

    protected boolean hasErrorsOrNestedErrors(Node node) {
        if (this.editor != null && this.editor.getNodesWithSavedErrors() != null) {
            return this.editor.getNodesWithSavedErrors().containsKey(node);
        }
        return false;
    }

    protected boolean hasWarningsOrNestedWarnings(Node node) {
        if (this.editor != null && this.editor.getNodesWithSavedWarnings() != null) {
            return this.editor.getNodesWithSavedWarnings().containsKey(node);
        }
        return false;
    }

    protected String getNameIterationText(Iterator iterator) {
        Object next = iterator.next();
        if (next instanceof Name) {
            Name name = (Name)next;
            String names = name.getCanonicalName();
            while (iterator.hasNext()) {
                names = String.valueOf(names) + ", " + ((Name)iterator.next()).getCanonicalName();
            }
            return names;
        }
        return "";
    }

    protected int getNameIterationLength(Iterator iterator, int beginOffset) {
        Name nameNode = null;
        while (iterator.hasNext()) {
            nameNode = (Name)iterator.next();
        }
        if (nameNode == null) {
            return 0;
        }
        Name node = nameNode;
        return node.getOffset() - beginOffset + node.getLength();
    }
}

