/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.ui.internal.record.conversion.xmlschema;

import java.io.InputStream;
import java.io.Reader;
import org.apache.xerces.xs.XSImplementation;
import org.apache.xerces.xs.XSLoader;
import org.apache.xerces.xs.XSModel;
import org.eclipse.edt.ide.ui.internal.record.conversion.RecordConversion;
import org.eclipse.edt.ide.ui.internal.record.conversion.RecordSource;
import org.eclipse.edt.ide.ui.internal.record.conversion.xmlschema.PartsFromXMLSchemaUtil;
import org.eclipse.edt.ide.ui.templates.parts.Part;
import org.eclipse.edt.ide.ui.templates.parts.Record;
import org.w3c.dom.DOMError;
import org.w3c.dom.DOMErrorHandler;
import org.w3c.dom.bootstrap.DOMImplementationRegistry;
import org.w3c.dom.ls.LSInput;

public class XMLSchemaConversion
extends RecordConversion
implements DOMErrorHandler {
    @Override
    protected Part[] doConvert(RecordSource input) {
        String xmlSchema = input.getContent();
        Part[] parts = null;
        this.ok(false);
        if (xmlSchema.trim().length() > 0) {
            try {
                XSModel xsModel;
                DOMImplementationRegistry domRegistry = DOMImplementationRegistry.newInstance();
                XSImplementation xsImpl = (XSImplementation)domRegistry.getDOMImplementation("XS-Loader");
                XSLoader xsLoader = xsImpl.createXSLoader(null);
                xsLoader.getConfig().setParameter("error-handler", this);
                if (input.getSource() == 1) {
                    xsModel = xsLoader.load((LSInput)new GenericLSInput(xmlSchema));
                } else {
                    xsLoader.getConfig().setParameter("http://apache.org/xml/features/honour-all-schemaLocations", true);
                    xsModel = xsLoader.loadURI(xmlSchema);
                }
                if (xsModel != null) {
                    parts = this.createParts(xsModel);
                }
                this.ok(xsModel != null);
            }
            catch (Throwable ex) {
                this.error(ex.getMessage());
            }
        }
        return parts;
    }

    private Part[] createParts(XSModel xsModel) {
        Record rec = new Record();
        return new PartsFromXMLSchemaUtil(this.getMessageHandler()).process(xsModel, rec);
    }

    @Override
    public boolean handleError(DOMError error) {
        StringBuffer buffer = new StringBuffer();
        if (error.getLocation().getUri() != null) {
            buffer.append("[" + error.getLocation().getUri() + "] ");
        }
        if (error.getLocation().getLineNumber() != -1) {
            buffer.append("[" + error.getLocation().getLineNumber() + "," + error.getLocation().getColumnNumber() + "] ");
        }
        if (buffer.length() > 0) {
            buffer.append(error.getMessage());
            if (error.getSeverity() == 3) {
                this.error(buffer.toString());
            } else {
                this.addMessage(buffer.toString());
            }
        } else {
            buffer.append(error.getMessage());
            if (error.getSeverity() == 3 || error.getSeverity() == 2) {
                this.error(buffer.toString());
            }
        }
        return error.getSeverity() != 3;
    }

    public static class GenericLSInput
    implements LSInput {
        private String xmlSchema;

        public GenericLSInput(String xmlSchema) {
            this.xmlSchema = xmlSchema;
        }

        @Override
        public String getBaseURI() {
            return null;
        }

        @Override
        public InputStream getByteStream() {
            return null;
        }

        @Override
        public boolean getCertifiedText() {
            return false;
        }

        @Override
        public Reader getCharacterStream() {
            return null;
        }

        @Override
        public String getEncoding() {
            return null;
        }

        @Override
        public String getPublicId() {
            return null;
        }

        @Override
        public String getStringData() {
            return this.xmlSchema;
        }

        @Override
        public String getSystemId() {
            return null;
        }

        @Override
        public void setBaseURI(String arg0) {
        }

        @Override
        public void setByteStream(InputStream arg0) {
        }

        @Override
        public void setCertifiedText(boolean arg0) {
        }

        @Override
        public void setCharacterStream(Reader arg0) {
        }

        @Override
        public void setEncoding(String arg0) {
        }

        @Override
        public void setPublicId(String arg0) {
        }

        @Override
        public void setStringData(String arg0) {
        }

        @Override
        public void setSystemId(String arg0) {
        }
    }
}

