/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.ui.internal.refactoring;

import com.ibm.icu.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourceAttributes;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.edt.ide.core.model.IEGLFile;
import org.eclipse.edt.ide.ui.EDTUIPlugin;
import org.eclipse.edt.ide.ui.internal.EGLUIStatus;
import org.eclipse.edt.ide.ui.internal.UINlsStrings;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;

public class Checks {
    private Checks() {
    }

    public static RefactoringStatus checkFileNewName(IEGLFile file, String newName) {
        String newFileName = Checks.getRenamedEGLFileName(file, newName);
        IPath fullPath = file.getResource().getFullPath();
        IPath renamedResourcePath = fullPath.removeLastSegments(1).append(newFileName);
        if (ResourcesPlugin.getWorkspace().getRoot().findMember(renamedResourcePath) != null) {
            return RefactoringStatus.createFatalErrorStatus((String)MessageFormat.format((String)UINlsStrings.Checks_eglfile_name_used, (Object[])new String[]{newName}));
        }
        return new RefactoringStatus();
    }

    public static RefactoringStatus validateModifiedFiles(IFile[] files, Object context) {
        RefactoringStatus result = new RefactoringStatus();
        IStatus status = Checks.checkIfInSync((IResource[])files);
        if (!status.isOK()) {
            result.merge(RefactoringStatus.create((IStatus)status));
        }
        if (!(status = Checks.makeCommittable((IResource[])files, context)).isOK()) {
            result.merge(RefactoringStatus.create((IStatus)status));
        }
        return result;
    }

    private static IStatus checkIfInSync(IResource[] resources) {
        IStatus result = null;
        int i = 0;
        while (i < resources.length) {
            IResource resource = resources[i];
            if (!resource.isSynchronized(2)) {
                result = Checks.addOutOfSyncMsg(result, resource);
            }
            ++i;
        }
        if (result != null) {
            return result;
        }
        return new Status(0, EDTUIPlugin.getPluginId(), 0, "", null);
    }

    private static IStatus addOutOfSyncMsg(IStatus status, IResource resource) {
        Status entry = new Status(4, "org.eclipse.core.resources", 274, MessageFormat.format((String)UINlsStrings.Resources_outOfSync, (Object[])new String[]{resource.getFullPath().toString()}), null);
        if (status == null) {
            return entry;
        }
        if (status.isMultiStatus()) {
            ((MultiStatus)status).add((IStatus)entry);
            return status;
        }
        MultiStatus result = new MultiStatus("org.eclipse.core.resources", 274, UINlsStrings.Resources_outOfSyncResources, null);
        result.add(status);
        result.add((IStatus)entry);
        return result;
    }

    private static IStatus makeCommittable(IResource[] resources, Object context) {
        ArrayList<IResource> readOnlyFiles = new ArrayList<IResource>();
        int i = 0;
        while (i < resources.length) {
            IResource resource = resources[i];
            if (resource.getType() == 1 && Checks.isReadOnly(resource)) {
                readOnlyFiles.add(resource);
            }
            ++i;
        }
        if (readOnlyFiles.size() == 0) {
            return new Status(0, EDTUIPlugin.getPluginId(), 0, "", null);
        }
        Map oldTimeStamps = Checks.createModificationStampMap(readOnlyFiles);
        IStatus status = ResourcesPlugin.getWorkspace().validateEdit(readOnlyFiles.toArray(new IFile[readOnlyFiles.size()]), context);
        if (!status.isOK()) {
            return status;
        }
        IStatus modified = null;
        Map newTimeStamps = Checks.createModificationStampMap(readOnlyFiles);
        for (IFile file : oldTimeStamps.keySet()) {
            if (oldTimeStamps.get(file).equals(newTimeStamps.get(file))) continue;
            modified = Checks.addModified(modified, file);
        }
        if (modified != null) {
            return modified;
        }
        return new Status(0, EDTUIPlugin.getPluginId(), 0, "", null);
    }

    private static boolean isReadOnly(IResource resource) {
        ResourceAttributes resourceAttributes = resource.getResourceAttributes();
        if (resourceAttributes == null) {
            return false;
        }
        return resourceAttributes.isReadOnly();
    }

    private static Map createModificationStampMap(List files) {
        HashMap<IFile, Long> map = new HashMap<IFile, Long>();
        for (IFile file : files) {
            map.put(file, new Long(file.getModificationStamp()));
        }
        return map;
    }

    private static IStatus addModified(IStatus status, IFile file) {
        IStatus entry = EGLUIStatus.createError(4, MessageFormat.format((String)UINlsStrings.Resources_fileModified, (Object[])new String[]{file.getFullPath().toString()}), null);
        if (status == null) {
            return entry;
        }
        if (status.isMultiStatus()) {
            ((MultiStatus)status).add(entry);
            return status;
        }
        MultiStatus result = new MultiStatus(EDTUIPlugin.getPluginId(), 4, UINlsStrings.Resources_modifiedResources, null);
        result.add(status);
        result.add(entry);
        return result;
    }

    private static String getRenamedEGLFileName(IEGLFile file, String newMainName) {
        String oldName = file.getElementName();
        int i = oldName.lastIndexOf(46);
        if (i != -1) {
            return String.valueOf(newMainName) + oldName.substring(i);
        }
        return newMainName;
    }
}

