/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.ui.internal.refactoring.changes;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.edt.ide.core.model.EGLCore;
import org.eclipse.edt.ide.core.model.IEGLFile;
import org.eclipse.edt.ide.core.model.IPackageFragment;
import org.eclipse.edt.ide.ui.internal.UINlsStrings;
import org.eclipse.edt.ide.ui.internal.refactoring.reorg.INewNameQuery;
import org.eclipse.ltk.core.refactoring.Change;

abstract class EGLFileReorgChange
extends Change {
    protected static final int NONE = 0;
    protected static final int READ_ONLY = 1;
    protected static final int DIRTY = 2;
    private static final int SAVE = 4;
    protected static final int SAVE_IF_DIRTY = 6;
    private String fCuHandle;
    private String fOldPackageHandle;
    private String fNewPackageHandle;
    private INewNameQuery fNewNameQuery;

    EGLFileReorgChange(IEGLFile cu, IPackageFragment dest, INewNameQuery newNameQuery) {
        this.fCuHandle = cu.getHandleIdentifier();
        this.fNewPackageHandle = dest.getHandleIdentifier();
        this.fNewNameQuery = newNameQuery;
        this.fOldPackageHandle = cu.getParent().getHandleIdentifier();
    }

    EGLFileReorgChange(IEGLFile cu, IPackageFragment dest) {
        this(cu, dest, null);
    }

    EGLFileReorgChange(String oldPackageHandle, String newPackageHandle, String cuHandle) {
        this.fOldPackageHandle = oldPackageHandle;
        this.fNewPackageHandle = newPackageHandle;
        this.fCuHandle = cuHandle;
    }

    public final Change perform(IProgressMonitor pm) throws CoreException {
        pm.beginTask(this.getName(), 1);
        try {
            Change result;
            this.getCu();
            Change change = result = this.doPerformReorg((IProgressMonitor)new SubProgressMonitor(pm, 1));
            return change;
        }
        finally {
            pm.done();
        }
    }

    abstract Change doPerformReorg(IProgressMonitor var1) throws CoreException;

    public Object getModifiedElement() {
        return this.getCu();
    }

    IEGLFile getCu() {
        return (IEGLFile)EGLCore.create((String)this.fCuHandle);
    }

    IPackageFragment getOldPackage() {
        return (IPackageFragment)EGLCore.create((String)this.fOldPackageHandle);
    }

    IPackageFragment getDestinationPackage() {
        return (IPackageFragment)EGLCore.create((String)this.fNewPackageHandle);
    }

    String getNewName() {
        if (this.fNewNameQuery == null) {
            return null;
        }
        return this.fNewNameQuery.getNewName();
    }

    static String getPackageName(IPackageFragment pack) {
        if (pack.isDefaultPackage()) {
            return UINlsStrings.OpenPartDialog_DefaultPackage;
        }
        return pack.getElementName();
    }
}

