/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.ui.internal.refactoring.rename;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.TextFileChange;
import org.eclipse.text.edits.MultiTextEdit;
import org.eclipse.text.edits.TextEdit;

public class UpdateXMLFileChange
extends Change {
    String newProjectName;
    String oldProjectName;
    String fileName;
    MultiTextEdit multiEdit;
    IFile oldFile;

    public UpdateXMLFileChange(String newProjectName, String oldProjectName, MultiTextEdit multiEdit, IFile oldFile) {
        this.multiEdit = multiEdit;
        this.oldFile = oldFile;
        this.fileName = oldFile.getName();
        this.newProjectName = newProjectName;
        this.oldProjectName = oldProjectName;
    }

    public Object getModifiedElement() {
        return this.oldFile;
    }

    public String getName() {
        return this.fileName;
    }

    public void initializeValidationData(IProgressMonitor pm) {
    }

    public RefactoringStatus isValid(IProgressMonitor pm) throws CoreException, OperationCanceledException {
        return new RefactoringStatus();
    }

    public Change perform(IProgressMonitor pm) throws CoreException {
        TextFileChange change = new TextFileChange("", this.getNewFile());
        change.setEdit((TextEdit)this.multiEdit);
        change.perform(pm);
        return null;
    }

    private IFile getNewFile() {
        IResource res;
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(this.newProjectName);
        if (project.exists() && (res = project.findMember(this.fileName)).exists() && (res.getType() & 1) > 0) {
            return (IFile)res;
        }
        return null;
    }
}

