/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.ui.internal.search;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.edt.ide.core.model.IEGLElement;
import org.eclipse.edt.ide.core.search.IEGLSearchConstants;
import org.eclipse.edt.ide.core.search.IEGLSearchScope;
import org.eclipse.edt.ide.core.search.SearchEngine;
import org.eclipse.edt.ide.ui.EDTUIPlugin;
import org.eclipse.edt.ide.ui.internal.IUIHelpConstants;
import org.eclipse.edt.ide.ui.internal.RowLayouter;
import org.eclipse.edt.ide.ui.internal.search.EGLSearchMessages;
import org.eclipse.edt.ide.ui.internal.search.EGLSearchQuery;
import org.eclipse.edt.ide.ui.internal.search.EGLSearchScopeFactory;
import org.eclipse.edt.ide.ui.internal.search.SearchUtil;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.DialogPage;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.search.ui.ISearchPage;
import org.eclipse.search.ui.ISearchPageContainer;
import org.eclipse.search.ui.ISearchQuery;
import org.eclipse.search.ui.ISearchResultViewEntry;
import org.eclipse.search.ui.NewSearchUI;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkingSet;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.model.IWorkbenchAdapter;

public class EGLSearchPage
extends DialogPage
implements ISearchPage,
IEGLSearchConstants {
    public static final String EXTENSION_POINT_ID = "org.eclipse.edt.ide.ui.search.EGLSearchPage";
    private static final String PAGE_NAME = "EGLSearchPage";
    private static final String STORE_CASE_SENSITIVE = "EGLSearchPageCASE_SENSITIVE";
    private static List fgPreviousSearchPatterns = new ArrayList(20);
    private SearchPatternData fInitialData;
    private IStructuredSelection fStructuredSelection;
    private IEGLElement feglElement;
    private boolean fFirstTime = true;
    private IDialogSettings fDialogSettings;
    private boolean fIsCaseSensitive;
    private Combo fPattern;
    private ISearchPageContainer fContainer;
    private Button fCaseSensitive;
    private Button[] fSearchFor;
    private int[] fSearchForValues;
    private String[] fSearchForText;
    private Button[] fLimitTo;
    private int[] fLimitToValues;
    private String[] fLimitToText;

    public EGLSearchPage() {
        int[] nArray = new int[14];
        nArray[0] = 1;
        nArray[1] = 10;
        nArray[2] = 9;
        nArray[3] = 4;
        nArray[4] = 12;
        nArray[5] = 13;
        nArray[6] = 14;
        nArray[7] = 15;
        nArray[8] = 16;
        nArray[9] = 17;
        nArray[10] = 20;
        nArray[11] = 18;
        nArray[12] = 19;
        this.fSearchForValues = nArray;
        this.fSearchForText = new String[]{EGLSearchMessages.EGLSearchPageSearchForProgram, EGLSearchMessages.EGLSearchPageSearchForFunction, EGLSearchMessages.EGLSearchPageSearchForLibrary, EGLSearchMessages.EGLSearchPageSearchForRecord, EGLSearchMessages.EGLSearchPageSearchForHandler, EGLSearchMessages.EGLSearchPageSearchForService, EGLSearchMessages.EGLSearchPageSearchForInterface, EGLSearchMessages.EGLSearchPageSearchForDelegate, EGLSearchMessages.EGLSearchPageSearchForExternalType, EGLSearchMessages.EGLSearchPageSearchForEnum, EGLSearchMessages.EGLSearchPageSearchForClass, EGLSearchMessages.EGLSearchPageSearchForAnnotation, EGLSearchMessages.EGLSearchPageSearchForStereotype, EGLSearchMessages.EGLSearchPageSearchForAny};
        int[] nArray2 = new int[3];
        nArray2[1] = 1;
        nArray2[2] = 2;
        this.fLimitToValues = nArray2;
        this.fLimitToText = new String[]{EGLSearchMessages.EGLSearchPageLimitToDeclarations, EGLSearchMessages.EGLSearchPageLimitToReferences, EGLSearchMessages.EGLSearchPageLimitToAllOccurrences};
    }

    public boolean performNewSearch() {
        NewSearchUI.activateSearchResultView();
        SearchPatternData patternData = this.getPatternData();
        IEGLSearchScope scope = null;
        String scopeDescription = "";
        switch (this.getContainer().getSelectedScope()) {
            case 0: {
                scopeDescription = EGLSearchMessages.WorkspaceScope;
                scope = SearchEngine.createWorkspaceScope();
                break;
            }
            case 1: {
                scopeDescription = EGLSearchMessages.SelectionScope;
                scope = EGLSearchScopeFactory.getInstance().createEGLSearchScope(this.fStructuredSelection);
                break;
            }
            case 3: {
                scope = EGLSearchScopeFactory.getInstance().createEGLProjectSearchScope((ISelection)this.fStructuredSelection);
                IProject[] projects = EGLSearchScopeFactory.getInstance().getProjects(scope);
                if (projects.length >= 1) {
                    if (projects.length == 1) {
                        scopeDescription = EGLSearchMessages.bind((String)EGLSearchMessages.EnclosingProjectScope, (Object)projects[0].getName());
                        break;
                    }
                    scopeDescription = EGLSearchMessages.bind((String)EGLSearchMessages.EnclosingProjectsScope, (Object)projects[0].getName());
                    break;
                }
                scopeDescription = EGLSearchMessages.bind((String)EGLSearchMessages.EnclosingProjectScope, (Object)"");
                break;
            }
            case 2: {
                IWorkingSet[] workingSets = this.getContainer().getSelectedWorkingSets();
                if (workingSets == null || workingSets.length < 1) {
                    return false;
                }
                scopeDescription = EGLSearchMessages.bind((String)EGLSearchMessages.WorkingSetScope, (Object)SearchUtil.toString(workingSets));
                scope = EGLSearchScopeFactory.getInstance().createEGLSearchScope(this.getContainer().getSelectedWorkingSets());
            }
        }
        EGLSearchQuery wsJob = new EGLSearchQuery(patternData.pattern, patternData.isCaseSensitive, patternData.searchFor, patternData.limitTo, scope, scopeDescription, false);
        NewSearchUI.activateSearchResultView();
        NewSearchUI.runQueryInBackground((ISearchQuery)wsJob);
        return true;
    }

    public boolean performAction() {
        return this.performNewSearch();
    }

    private int getLimitTo() {
        int i = 0;
        while (i < this.fLimitTo.length) {
            if (this.fLimitTo[i].getSelection()) {
                return this.fLimitToValues[i];
            }
            ++i;
        }
        return -1;
    }

    private void setLimitTo(int searchFor) {
        int i = 0;
        while (i < this.fLimitTo.length) {
            this.fLimitTo[i].setEnabled(true);
            ++i;
        }
    }

    private String[] getPreviousSearchPatterns() {
        int patternCount = fgPreviousSearchPatterns.size();
        String[] patterns = new String[patternCount];
        int i = 0;
        while (i < patternCount) {
            patterns[i] = ((SearchPatternData)EGLSearchPage.fgPreviousSearchPatterns.get((int)(patternCount - 1 - i))).pattern;
            ++i;
        }
        return patterns;
    }

    private int getSearchFor() {
        int i = 0;
        while (i < this.fSearchFor.length) {
            if (this.fSearchFor[i].getSelection()) {
                return this.fSearchForValues[i];
            }
            ++i;
        }
        return -1;
    }

    private String getPattern() {
        return this.fPattern.getText();
    }

    private SearchPatternData getPatternData() {
        String pattern = this.getPattern();
        SearchPatternData match = null;
        int i = 0;
        int size = fgPreviousSearchPatterns.size();
        while (match == null && i < size) {
            match = (SearchPatternData)fgPreviousSearchPatterns.get(i);
            ++i;
            if (pattern.equals(match.pattern)) continue;
            match = null;
        }
        if (match == null) {
            match = new SearchPatternData(this.getSearchFor(), this.getLimitTo(), pattern, this.fCaseSensitive.getSelection(), this.feglElement, this.getContainer().getSelectedScope(), this.getContainer().getSelectedWorkingSets());
            fgPreviousSearchPatterns.add(match);
        } else {
            match.searchFor = this.getSearchFor();
            match.limitTo = this.getLimitTo();
            match.isCaseSensitive = this.fCaseSensitive.getSelection();
            match.eglElement = this.feglElement;
            match.scope = this.getContainer().getSelectedScope();
            match.workingSets = this.getContainer().getSelectedWorkingSets();
        }
        return match;
    }

    public void setVisible(boolean visible) {
        if (visible && this.fPattern != null) {
            if (this.fFirstTime) {
                this.fFirstTime = false;
                this.fPattern.setItems(this.getPreviousSearchPatterns());
                this.initSelections();
            }
            this.fPattern.setFocus();
            this.getContainer().setPerformActionEnabled(this.fPattern.getText().length() > 0);
        }
        super.setVisible(visible);
    }

    public boolean isValid() {
        return true;
    }

    public void createControl(Composite parent) {
        this.initializeDialogUnits((Control)parent);
        this.readConfiguration();
        Composite result = new Composite(parent, 0);
        GridLayout layout = new GridLayout(2, false);
        layout.horizontalSpacing = 10;
        result.setLayout((Layout)layout);
        result.setLayoutData((Object)new GridData(768));
        RowLayouter layouter = new RowLayouter(layout.numColumns);
        GridData gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.verticalAlignment = 18;
        layouter.setDefaultGridData(gd, 0);
        layouter.setDefaultGridData(gd, 1);
        layouter.setDefaultSpan();
        layouter.perform(this.createExpression(result));
        layouter.perform(this.createSearchFor(result), this.createLimitTo(result), -1);
        SelectionAdapter eglElementInitializer = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                if (EGLSearchPage.this.getSearchFor() == ((EGLSearchPage)EGLSearchPage.this).fInitialData.searchFor) {
                    EGLSearchPage.this.feglElement = ((EGLSearchPage)EGLSearchPage.this).fInitialData.eglElement;
                } else {
                    EGLSearchPage.this.feglElement = null;
                }
                EGLSearchPage.this.setLimitTo(EGLSearchPage.this.getSearchFor());
                EGLSearchPage.this.updateCaseSensitiveCheckbox();
            }
        };
        int icnt = this.fSearchFor.length;
        int x = 0;
        while (x < icnt) {
            this.fSearchFor[x].addSelectionListener((SelectionListener)eglElementInitializer);
            ++x;
        }
        this.setControl((Control)result);
        Dialog.applyDialogFont((Control)result);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)result, IUIHelpConstants.EGL_SEARCH_DIALOG);
    }

    private Control createExpression(Composite parent) {
        Composite result = new Composite(parent, 0);
        GridLayout layout = new GridLayout(2, false);
        result.setLayout((Layout)layout);
        GridData gd = new GridData(768);
        gd.horizontalSpan = 2;
        gd.horizontalIndent = 0;
        result.setLayoutData((Object)gd);
        Label label = new Label(result, 16384);
        label.setText(EGLSearchMessages.EGLSearchPageExpressionLabel);
        gd = new GridData(1);
        gd.horizontalSpan = 2;
        label.setLayoutData((Object)gd);
        this.fPattern = new Combo(result, 2052);
        this.fPattern.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                EGLSearchPage.this.handlePatternSelected();
            }
        });
        this.fPattern.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                EGLSearchPage.this.getContainer().setPerformActionEnabled(EGLSearchPage.this.getPattern().length() > 0);
                EGLSearchPage.this.updateCaseSensitiveCheckbox();
            }
        });
        gd = new GridData(768);
        gd.horizontalIndent = -gd.horizontalIndent;
        this.fPattern.setLayoutData((Object)gd);
        this.fCaseSensitive = new Button(result, 32);
        this.fCaseSensitive.setText(EGLSearchMessages.EGLSearchPageExpressionCaseSensitive);
        gd = new GridData();
        this.fCaseSensitive.setLayoutData((Object)gd);
        this.fCaseSensitive.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                EGLSearchPage.this.fIsCaseSensitive = EGLSearchPage.this.fCaseSensitive.getSelection();
                EGLSearchPage.this.writeConfiguration();
            }
        });
        return result;
    }

    private void updateCaseSensitiveCheckbox() {
        if (this.fInitialData != null && this.getPattern().equals(this.fInitialData.pattern) && this.feglElement != null) {
            this.fCaseSensitive.setEnabled(false);
            this.fCaseSensitive.setSelection(true);
        } else {
            this.fCaseSensitive.setEnabled(true);
            this.fCaseSensitive.setSelection(this.fIsCaseSensitive);
        }
    }

    private void handlePatternSelected() {
        if (this.fPattern.getSelectionIndex() < 0) {
            return;
        }
        int index = fgPreviousSearchPatterns.size() - 1 - this.fPattern.getSelectionIndex();
        this.fInitialData = (SearchPatternData)fgPreviousSearchPatterns.get(index);
        this.updateSelections();
        if (this.fInitialData.workingSets != null) {
            this.getContainer().setSelectedWorkingSets(this.fInitialData.workingSets);
        } else {
            this.getContainer().setSelectedScope(this.fInitialData.scope);
        }
    }

    private void updateSelections() {
        if (this.fInitialData == null) {
            this.fInitialData = this.trySimpleTextSelection(this.getContainer().getSelection());
        }
        if (this.fInitialData == null) {
            this.fInitialData = this.getDefaultInitValues();
        }
        this.feglElement = this.fInitialData.eglElement;
        this.fIsCaseSensitive = this.fInitialData.isCaseSensitive;
        this.fCaseSensitive.setSelection(this.fInitialData.isCaseSensitive);
        this.fCaseSensitive.setEnabled(this.fInitialData.eglElement == null);
        int i = 0;
        while (i < this.fSearchFor.length) {
            this.fSearchFor[i].setSelection(this.fSearchForValues[i] == this.fInitialData.searchFor);
            ++i;
        }
        this.setLimitTo(this.fInitialData.searchFor);
        i = 0;
        while (i < this.fLimitTo.length) {
            this.fLimitTo[i].setSelection(this.fLimitToValues[i] == this.fInitialData.limitTo);
            ++i;
        }
        this.fPattern.setText(this.fInitialData.pattern);
    }

    private Control createSearchFor(Composite parent) {
        Group result = new Group(parent, 0);
        result.setText(EGLSearchMessages.EGLSearchPageSearchForLabel);
        GridLayout layout = new GridLayout();
        layout.numColumns = 5;
        result.setLayout((Layout)layout);
        this.fSearchFor = new Button[this.fSearchForText.length];
        int i = 0;
        while (i < this.fSearchForText.length) {
            Button button = new Button((Composite)result, 16);
            button.setText(this.fSearchForText[i]);
            this.fSearchFor[i] = button;
            ++i;
        }
        return result;
    }

    private Control createLimitTo(Composite parent) {
        Group result = new Group(parent, 0);
        result.setText(EGLSearchMessages.EGLSearchPageLimitToLabel);
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        result.setLayout((Layout)layout);
        this.fLimitTo = new Button[this.fLimitToText.length];
        int i = 0;
        while (i < this.fLimitToText.length) {
            Button button = new Button((Composite)result, 16);
            button.setText(this.fLimitToText[i]);
            this.fLimitTo[i] = button;
            ++i;
        }
        return result;
    }

    private void initSelections() {
        this.fStructuredSelection = this.asStructuredSelection();
        this.fInitialData = this.tryStructuredSelection(this.fStructuredSelection);
        this.updateSelections();
    }

    private SearchPatternData tryStructuredSelection(IStructuredSelection selection) {
        if (selection == null || selection.size() > 1) {
            return null;
        }
        Object o = selection.getFirstElement();
        if (o instanceof IEGLElement) {
            return this.determineInitValuesFrom((IEGLElement)o);
        }
        if (o instanceof ISearchResultViewEntry) {
            IEGLElement element = SearchUtil.getEGLElement(((ISearchResultViewEntry)o).getSelectedMarker());
            return this.determineInitValuesFrom(element);
        }
        if (o instanceof IAdaptable) {
            IEGLElement element = (IEGLElement)((IAdaptable)o).getAdapter(IEGLElement.class);
            if (element != null) {
                return this.determineInitValuesFrom(element);
            }
            IWorkbenchAdapter adapter = (IWorkbenchAdapter)((IAdaptable)o).getAdapter(IWorkbenchAdapter.class);
            if (adapter != null) {
                return new SearchPatternData(0, 0, this.fIsCaseSensitive, adapter.getLabel(o), null);
            }
        }
        return null;
    }

    private SearchPatternData determineInitValuesFrom(IEGLElement element) {
        if (element == null) {
            return null;
        }
        return null;
    }

    private SearchPatternData trySimpleTextSelection(ISelection selection) {
        SearchPatternData result = null;
        if (selection instanceof ITextSelection) {
            String text;
            BufferedReader reader = new BufferedReader(new StringReader(((ITextSelection)selection).getText()));
            try {
                text = reader.readLine();
                if (text == null) {
                    text = "";
                }
            }
            catch (IOException iOException) {
                text = "";
            }
            result = new SearchPatternData(0, 1, this.fIsCaseSensitive, text, null);
        }
        return result;
    }

    private SearchPatternData getDefaultInitValues() {
        return new SearchPatternData(0, 1, this.fIsCaseSensitive, "", null);
    }

    public void setContainer(ISearchPageContainer container) {
        this.fContainer = container;
    }

    private ISearchPageContainer getContainer() {
        return this.fContainer;
    }

    private IStructuredSelection asStructuredSelection() {
        IWorkbenchPart part;
        IWorkbenchPage page;
        IWorkbenchWindow wbWindow = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (wbWindow != null && (page = wbWindow.getActivePage()) != null && (part = page.getActivePart()) != null) {
            try {
                return this.getStructuredSelection(part);
            }
            catch (Exception exception) {}
        }
        return StructuredSelection.EMPTY;
    }

    private IDialogSettings getDialogSettings() {
        IDialogSettings settings = EDTUIPlugin.getDefault().getDialogSettings();
        this.fDialogSettings = settings.getSection(PAGE_NAME);
        if (this.fDialogSettings == null) {
            this.fDialogSettings = settings.addNewSection(PAGE_NAME);
        }
        return this.fDialogSettings;
    }

    private void readConfiguration() {
        IDialogSettings s = this.getDialogSettings();
        this.fIsCaseSensitive = s.getBoolean(STORE_CASE_SENSITIVE);
    }

    private void writeConfiguration() {
        IDialogSettings s = this.getDialogSettings();
        s.put(STORE_CASE_SENSITIVE, this.fIsCaseSensitive);
    }

    public IStructuredSelection getStructuredSelection(IWorkbenchPart part) {
        ISelection selection;
        ISelectionProvider provider = part.getSite().getSelectionProvider();
        if (provider != null && (selection = provider.getSelection()) instanceof IStructuredSelection) {
            return (IStructuredSelection)selection;
        }
        return StructuredSelection.EMPTY;
    }

    private static class SearchPatternData {
        int searchFor;
        int limitTo;
        String pattern;
        boolean isCaseSensitive;
        IEGLElement eglElement;
        int scope;
        IWorkingSet[] workingSets;

        public SearchPatternData(int s, int l, boolean i, String p, IEGLElement element) {
            this(s, l, p, i, element, 0, null);
        }

        public SearchPatternData(int s, int l, String p, boolean i, IEGLElement element, int scope, IWorkingSet[] workingSets) {
            this.searchFor = s;
            this.limitTo = l;
            this.pattern = p;
            this.isCaseSensitive = i;
            this.eglElement = element;
            this.scope = scope;
            this.workingSets = workingSets;
        }
    }
}

