/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.ui.internal.util;

import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.edt.compiler.binding.IPartBinding;
import org.eclipse.edt.compiler.internal.EGLPropertyRule;

public class CapabilityFilterUtility {
    private static IPartBindingFilter[] defaultPartBindingFilters = new IPartBindingFilter[0];
    private static IPropertyRuleFilter[] defaultPropertyRuleFilters = new IPropertyRuleFilter[0];

    public static Collection filterParts(Collection partBindings) {
        return CapabilityFilterUtility.filterParts(partBindings, new IPartBindingFilter[0]);
    }

    public static Collection filterParts(Collection partBindings, IPartBindingFilter[] additionalFilters) {
        ArrayList<IPartBinding> result = new ArrayList<IPartBinding>();
        for (IPartBinding next : partBindings) {
            boolean passes = true;
            int i = 0;
            while (i < defaultPartBindingFilters.length && passes) {
                passes = defaultPartBindingFilters[i].partBindingPasses(next);
                ++i;
            }
            i = 0;
            while (i < additionalFilters.length && passes) {
                passes = additionalFilters[i].partBindingPasses(next);
                ++i;
            }
            if (!passes) continue;
            result.add(next);
        }
        return result;
    }

    public static Collection filterPropertyRules(Collection propertyRules) {
        return CapabilityFilterUtility.filterPropertyRules(propertyRules, new IPropertyRuleFilter[0]);
    }

    public static Collection filterPropertyRules(Collection propertyRules, IPropertyRuleFilter[] additionalFilters) {
        ArrayList<EGLPropertyRule> result = new ArrayList<EGLPropertyRule>();
        if (propertyRules != null) {
            for (EGLPropertyRule next : propertyRules) {
                boolean passes = true;
                int i = 0;
                while (i < defaultPropertyRuleFilters.length && passes) {
                    passes = defaultPropertyRuleFilters[i].propertyRulePasses(next);
                    ++i;
                }
                i = 0;
                while (i < additionalFilters.length && passes) {
                    passes = additionalFilters[i].propertyRulePasses(next);
                    ++i;
                }
                if (!passes) continue;
                result.add(next);
            }
        }
        return result;
    }

    public static interface IPartBindingFilter {
        public boolean partBindingPasses(IPartBinding var1);
    }

    public static interface IPropertyRuleFilter {
        public boolean propertyRulePasses(EGLPropertyRule var1);
    }

    public static abstract class PackageNameFilter
    implements IPartBindingFilter,
    IPropertyRuleFilter {
        private String[] packageNames;

        public PackageNameFilter(String packageName) {
            this(new String[]{packageName});
        }

        public PackageNameFilter(String[] packageNames) {
            this.packageNames = packageNames;
        }

        private boolean allowed(String packageName) {
            boolean passes = true;
            int i = 0;
            while (i < this.packageNames.length && passes) {
                if (this.equals(packageName, this.packageNames[i])) {
                    passes = this.isAllowed();
                }
                ++i;
            }
            return passes;
        }

        @Override
        public boolean partBindingPasses(IPartBinding partBinding) {
            return this.allowed(partBinding.getPackageName());
        }

        @Override
        public boolean propertyRulePasses(EGLPropertyRule propertyRule) {
            return this.allowed(propertyRule.getPackageName());
        }

        protected abstract boolean isAllowed();

        private boolean equals(String partPackageName, String packageName2) {
            if (partPackageName == packageName2) {
                return true;
            }
            if (partPackageName == null || packageName2 == null) {
                return false;
            }
            return partPackageName.equalsIgnoreCase(packageName2);
        }
    }
}

