/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.rui.visualeditor.internal.editor;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.edt.ide.rui.document.utils.IVEConstants;
import org.eclipse.edt.ide.rui.visualeditor.internal.actions.EvActionWidgetDelete;
import org.eclipse.edt.ide.rui.visualeditor.internal.actions.EvActionWidgetMove;
import org.eclipse.edt.ide.rui.visualeditor.internal.actions.EvActionWidgetProperties;
import org.eclipse.edt.ide.rui.visualeditor.internal.editor.EvDesignCaptureInformation;
import org.eclipse.edt.ide.rui.visualeditor.internal.editor.EvDesignOverlayDropLocation;
import org.eclipse.edt.ide.rui.visualeditor.internal.editor.EvDesignOverlayPainter;
import org.eclipse.edt.ide.rui.visualeditor.internal.editor.EvDesignOverylayClickableArea;
import org.eclipse.edt.ide.rui.visualeditor.internal.editor.EvDesignPage;
import org.eclipse.edt.ide.rui.visualeditor.internal.editor.EvEditor;
import org.eclipse.edt.ide.rui.visualeditor.internal.editor.EvHelp;
import org.eclipse.edt.ide.rui.visualeditor.internal.editor.EvSourceOperation;
import org.eclipse.edt.ide.rui.visualeditor.internal.editor.EvWidgetContextMenuProvider;
import org.eclipse.edt.ide.rui.visualeditor.internal.editor.EvWidgetContextMenuProviderRegister;
import org.eclipse.edt.ide.rui.visualeditor.internal.nl.Messages;
import org.eclipse.edt.ide.rui.visualeditor.internal.preferences.EvPreferences;
import org.eclipse.edt.ide.rui.visualeditor.internal.properties.PropertyChange;
import org.eclipse.edt.ide.rui.visualeditor.internal.util.ColorUtil;
import org.eclipse.edt.ide.rui.visualeditor.internal.views.dataview.model.PageDataNode;
import org.eclipse.edt.ide.rui.visualeditor.internal.widget.WidgetDescriptor;
import org.eclipse.edt.ide.rui.visualeditor.internal.widget.WidgetDescriptorRegistry;
import org.eclipse.edt.ide.rui.visualeditor.internal.widget.WidgetManager;
import org.eclipse.edt.ide.rui.visualeditor.internal.widget.WidgetPart;
import org.eclipse.edt.ide.rui.visualeditor.internal.widget.WidgetPropertyDescriptor;
import org.eclipse.edt.ide.rui.visualeditor.internal.widget.WidgetPropertyValue;
import org.eclipse.edt.ide.rui.visualeditor.internal.widget.layout.RootWidgetLayout;
import org.eclipse.edt.ide.rui.visualeditor.internal.widget.layout.WidgetLayout;
import org.eclipse.edt.ide.rui.visualeditor.internal.widget.layout.WidgetLayoutRegistry;
import org.eclipse.edt.ide.rui.visualeditor.internal.wizards.insertwidget.EvInsertWidgetWizardDialog;
import org.eclipse.edt.ide.rui.visualeditor.internal.wizards.insertwidget.InsertWidgetWizard;
import org.eclipse.edt.ide.rui.visualeditor.plugin.Activator;
import org.eclipse.gef.dnd.TemplateTransfer;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.dnd.DropTarget;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.TraverseEvent;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.actions.ActionFactory;

public class EvDesignOverlay
extends Composite
implements DisposeListener,
DropTargetListener,
FocusListener,
IMenuListener,
KeyListener,
MouseListener,
MouseMoveListener,
MouseTrackListener,
PaintListener,
TraverseListener {
    public static final int DROP_THICKNESS = 5;
    protected Cursor _cursorWait = null;
    protected EvActionWidgetDelete _actionWidgetDelete = null;
    protected EvActionWidgetMove _actionWidgetMove = null;
    protected EvActionWidgetProperties _actionWidgetProperties = null;
    protected boolean _bShowInstructions = false;
    protected Color _colorDropTargetPotential = null;
    protected Color _colorDropTargetSelected = null;
    protected Color _colorWidgetSelected = null;
    protected EvDesignOverlayDropLocation _dropLocation = null;
    protected Image _imageDoubleBuffer = null;
    protected int _iTransparencyAmount = 255;
    protected int _iTransparencyMode = 0;
    protected Collection _listDropLocations = null;
    protected ArrayList _listSelectionHierarchy = new ArrayList();
    protected EvDesignPage _pageDesign = null;
    protected EvDesignOverlayPainter _painter = null;
    protected Point _ptDragOffset = new Point(0, 0);
    protected Collection _ptDropLocations = null;
    protected Point _ptMouse = new Point(0, 0);
    protected Point _ptMouseDown = new Point(0, 0);
    protected WidgetPart _widgetDragging = null;
    protected WidgetPart _widgetDropLocation = null;
    protected WidgetPart _widgetMouseDown = null;
    protected WidgetPart _widgetNextSelection = null;
    protected WidgetPart _widgetSelected = null;
    protected Collection _listClickableAreas = new ArrayList();
    protected MenuManager _menuManager = null;
    protected Point _mouseDownPoint = null;

    public EvDesignOverlay(Composite compositeParent, EvDesignPage pageDesign) {
        super(compositeParent, pageDesign._bGraphicsTransparencyAvailable ? 0x40000000 : 262144);
        this._pageDesign = pageDesign;
        this._painter = new EvDesignOverlayPainter(this);
        this.updateColors();
        this.initializeTransparency();
        this.createContextMenu();
        this.addDisposeListener(this);
        this.addDropSupport();
        this.addFocusListener(this);
        this.addKeyListener(this);
        this.addMouseListener(this);
        this.addMouseMoveListener(this);
        this.addMouseTrackListener(this);
        this.addPaintListener(this);
        this.addTraverseListener(this);
        EvHelp.setHelp((Control)this, EvHelp.DESIGN_AREA);
        EvHelp.setHelp((Control)compositeParent, EvHelp.DESIGN_AREA);
        EvHelp.setHelp((Control)compositeParent.getParent(), EvHelp.DESIGN_AREA);
    }

    protected void addDropSupport() {
        int iOperations = 7;
        DropTarget dropTarget = new DropTarget((Control)this, iOperations);
        Transfer[] types = new Transfer[]{TemplateTransfer.getInstance()};
        dropTarget.setTransfer(types);
        dropTarget.addDropListener((DropTargetListener)this);
    }

    protected void createContextMenu() {
        this._menuManager = new MenuManager("org.eclipse.edt.ide.rui.visualeditor.designarea.contextmenu", "org.eclipse.edt.ide.rui.visualeditor.designarea.contextmenu");
        this._menuManager.addMenuListener((IMenuListener)this);
        Menu menu = this._menuManager.createContextMenu((Control)this);
        this.setMenu(menu);
        IWorkbenchPart workbenchPart = this._pageDesign.getEditor().getSite().getPart();
        IAction actionUndo = this._pageDesign.getEditor().getPageSource().getAction(ActionFactory.UNDO.getId());
        this._menuManager.add(actionUndo);
        IAction actionRedo = this._pageDesign.getEditor().getPageSource().getAction(ActionFactory.REDO.getId());
        this._menuManager.add(actionRedo);
        this._menuManager.add((IContributionItem)new Separator());
        ActionFactory.IWorkbenchAction actionWorkbenchSave = ActionFactory.SAVE.create(workbenchPart.getSite().getWorkbenchWindow());
        this._menuManager.add((IAction)actionWorkbenchSave);
        this._menuManager.add((IContributionItem)new Separator());
        ActionFactory.IWorkbenchAction actionWorkbenchDelete = ActionFactory.DELETE.create(workbenchPart.getSite().getWorkbenchWindow());
        this._actionWidgetDelete = new EvActionWidgetDelete(this);
        this._actionWidgetDelete.setId(actionWorkbenchDelete.getId());
        this._actionWidgetDelete.setText(actionWorkbenchDelete.getText());
        this._actionWidgetDelete.setAccelerator(actionWorkbenchDelete.getAccelerator());
        this._actionWidgetDelete.setImageDescriptor(actionWorkbenchDelete.getImageDescriptor());
        this._actionWidgetDelete.setDescription(actionWorkbenchDelete.getDescription());
        this._actionWidgetDelete.setDisabledImageDescriptor(actionWorkbenchDelete.getDisabledImageDescriptor());
        this._menuManager.add((IAction)this._actionWidgetDelete);
        this._actionWidgetMove = new EvActionWidgetMove(workbenchPart, this);
        this._actionWidgetMove.setId("move");
        this._actionWidgetMove.setText(Messages.NL_Move);
        this._menuManager.add((IAction)this._actionWidgetMove);
        this._menuManager.add((IContributionItem)new Separator());
        ActionFactory.IWorkbenchAction actionWorkbenchProperties = ActionFactory.PROPERTIES.create(workbenchPart.getSite().getWorkbenchWindow());
        this._actionWidgetProperties = new EvActionWidgetProperties(this);
        this._actionWidgetProperties.setId(ActionFactory.PROPERTIES.getId());
        this._actionWidgetProperties.setText(actionWorkbenchProperties.getText());
        this._actionWidgetProperties.setAccelerator(actionWorkbenchProperties.getAccelerator());
        this._actionWidgetProperties.setImageDescriptor(actionWorkbenchProperties.getImageDescriptor());
        this._actionWidgetProperties.setDescription(actionWorkbenchProperties.getDescription());
        this._actionWidgetProperties.setDisabledImageDescriptor(actionWorkbenchProperties.getDisabledImageDescriptor());
        this._menuManager.add((IAction)this._actionWidgetProperties);
    }

    protected void refreshMenu() {
        IContributionItem removeContributionItem;
        IContributionItem deleteContributionItem = this._menuManager.find(ActionFactory.DELETE.getId());
        if (deleteContributionItem == null) {
            this._menuManager.insertBefore(ActionFactory.PROPERTIES.getId(), (IAction)this._actionWidgetDelete);
        }
        if ((removeContributionItem = this._menuManager.find("move")) == null) {
            this._menuManager.insertBefore(ActionFactory.PROPERTIES.getId(), (IAction)this._actionWidgetMove);
            this._menuManager.insertBefore(ActionFactory.PROPERTIES.getId(), (IContributionItem)new Separator());
        }
        Collection<EvWidgetContextMenuProvider> _widgetContextMenuProviders = EvWidgetContextMenuProviderRegister.getInstance().getEvWidgetContextMenuProviders().values();
        Iterator<EvWidgetContextMenuProvider> iterator = _widgetContextMenuProviders.iterator();
        while (iterator.hasNext()) {
            iterator.next().refreshContextMenu(this._widgetSelected, this._menuManager, this, this._mouseDownPoint);
        }
    }

    public void deleteSelected() {
        if (this._widgetSelected != null) {
            if (this._widgetNextSelection == this._widgetSelected) {
                this._widgetNextSelection = null;
            }
            if (!this.isCellInGridLayout(this._widgetSelected)) {
                this.doOperationWidgetDelete(this._widgetSelected);
                this.redraw();
            }
        }
    }

    private boolean isCellInGridLayout(WidgetPart _widgetSelected) {
        if (_widgetSelected == null || !"org.eclipse.edt.rui.widgets".equals(_widgetSelected.getPackageName()) || !"GridLayout".equals(_widgetSelected.getTypeName())) {
            return false;
        }
        String extrainfo = _widgetSelected.getExtraInfo("LayoutInfo");
        if (extrainfo == null || extrainfo.length() == 0) {
            return false;
        }
        String[] tdInfo = extrainfo.split(":");
        int row = -1;
        int column = -1;
        try {
            int index = 0;
            int[] cellInfo = new int[7];
            int i = 0;
            while (i < tdInfo.length) {
                index = i % 7;
                cellInfo[index] = Integer.parseInt(tdInfo[i]);
                if (this._mouseDownPoint != null && index == 6 && cellInfo[2] < this._mouseDownPoint.x && cellInfo[3] < this._mouseDownPoint.y && cellInfo[4] > this._mouseDownPoint.x - cellInfo[2] && cellInfo[5] > this._mouseDownPoint.y - cellInfo[3]) {
                    row = cellInfo[0];
                    column = cellInfo[1];
                    break;
                }
                ++i;
            }
        }
        catch (Exception e) {
            Activator.getDefault().getLog().log((IStatus)new Status(4, "org.eclipse.edt.ide.rui.visualeditor", "GridLayoutWidgetContextMenuProvider: Error parse LayoutInfo", (Throwable)e));
        }
        return row >= 0 && column >= 0;
    }

    public void doOperationWidgetCreate(WidgetDescriptor descriptor, EvDesignOverlayDropLocation location) {
        if (this._cursorWait == null) {
            this._cursorWait = new Cursor((Device)this.getDisplay(), 1);
        }
        this.setCursor(this._cursorWait);
        this.rememberSelectionHierarchyForOperation(location.widgetParent, location.iIndex);
        this._pageDesign.doOperationWidgetCreate(descriptor, location);
        this.setCursor(null);
    }

    public void doOperationWidgetDelete(WidgetPart widget) {
        if (this._cursorWait == null) {
            this._cursorWait = new Cursor((Device)this.getDisplay(), 1);
        }
        this.setCursor(this._cursorWait);
        this.rememberSelectionHierarchyForOperationDelete(widget);
        this._pageDesign.doOperationWidgetDelete(widget);
        this.setCursor(null);
    }

    public void doOperationWidgetMove(WidgetPart widget, EvDesignOverlayDropLocation location) {
        if (this._cursorWait == null) {
            this._cursorWait = new Cursor((Device)this.getDisplay(), 1);
        }
        this.setCursor(this._cursorWait);
        this.rememberSelectionHierarchyForOperation(location.widgetParent, location.iIndex);
        this._pageDesign.doOperationWidgetMove(widget, location);
        this.setCursor(null);
    }

    protected void doOperationWidgetPropertyValueChanges(List listPropertyChanges) {
        if (this._cursorWait == null) {
            this._cursorWait = new Cursor((Device)this.getDisplay(), 1);
        }
        this.setCursor(this._cursorWait);
        this._pageDesign.doOperationWidgetPropertyValueChanges(listPropertyChanges);
        this.setCursor(null);
    }

    protected void doOperationWidgetOnclick(EvDesignOverylayClickableArea area) {
        try {
            int index = Integer.parseInt(area.propertyValue);
            this.rememberSelectionHierarchyForOperation(area.widget, index - 1);
        }
        catch (Exception exception) {}
        this._pageDesign.doOperationWidgetOnclick(area.widget, area.propertyName, area.propertyValue);
    }

    public void doSourceOperation(EvSourceOperation operation) {
        if (this._widgetSelected != null) {
            if (this._widgetNextSelection == this._widgetSelected) {
                this._widgetNextSelection = null;
            }
            if (this._cursorWait == null) {
                this._cursorWait = new Cursor((Device)this.getDisplay(), 1);
            }
            this.setCursor(this._cursorWait);
            this._pageDesign.doSourceOperation(operation);
            this.setCursor(null);
            this.redraw();
        }
    }

    public void dragEnter(DropTargetEvent event) {
        EvEditor editor = this._pageDesign.getEditor();
        boolean bAllowDrop = editor.isRuiHandler();
        if (!bAllowDrop) {
            return;
        }
        DropTarget dropTarget = (DropTarget)event.getSource();
        Transfer[] transfer = dropTarget.getTransfer();
        if (transfer.length == 0) {
            return;
        }
        if (!(transfer[0] instanceof TemplateTransfer)) {
            return;
        }
        TemplateTransfer templateTransfer = (TemplateTransfer)transfer[0];
        if (!(templateTransfer.getObject() instanceof String)) {
            return;
        }
        this._pageDesign.getScroller().activate();
    }

    public void dragLeave(DropTargetEvent event) {
        EvEditor editor = this._pageDesign.getEditor();
        boolean bAllowDrop = editor.isRuiHandler();
        if (!bAllowDrop) {
            return;
        }
        this._ptDropLocations = null;
        this._listDropLocations = null;
        this._pageDesign.getScroller().deactivate();
        this.redraw();
    }

    public void dragOperationChanged(DropTargetEvent event) {
    }

    public void dragOver(DropTargetEvent event) {
        EvEditor editor = this._pageDesign.getEditor();
        boolean bAllowDrop = editor.isRuiHandler();
        if (!bAllowDrop) {
            return;
        }
        Point ptMouse = Display.getCurrent().getCursorLocation();
        ptMouse = this.toControl(ptMouse);
        this._pageDesign.getScroller().autoScroll(ptMouse.x, ptMouse.y);
        this.setupDropLocations(ptMouse.x, ptMouse.y);
        this.setupNextDropLocation(ptMouse.x, ptMouse.y);
        this.redraw();
    }

    public void drop(DropTargetEvent event) {
        EvEditor editor = this._pageDesign.getEditor();
        boolean bAllowDrop = editor.isRuiHandler();
        if (!bAllowDrop) {
            return;
        }
        if (this._dropLocation != null) {
            if (event.data instanceof String) {
                String strWidgetID = event.data.toString();
                WidgetDescriptor descriptor = WidgetDescriptorRegistry.getInstance(this.getDesignPage().getEditor().getProject()).getDescriptor(strWidgetID);
                this.doOperationWidgetCreate(descriptor, this._dropLocation);
            } else if (event.data instanceof PageDataNode) {
                PageDataNode pageDataNode = (PageDataNode)event.data;
                InsertWidgetWizard insertWidgetWizard = new InsertWidgetWizard(pageDataNode, this, this._dropLocation);
                Shell shell = Display.getCurrent().getActiveShell();
                EvInsertWidgetWizardDialog evInsertWidgetWizardDialog = new EvInsertWidgetWizardDialog(shell, (IWizard)insertWidgetWizard);
                evInsertWidgetWizardDialog.setPageSize(800, 400);
                evInsertWidgetWizardDialog.open();
            }
        }
        this._ptDropLocations = null;
        this._listDropLocations = null;
        this._dropLocation = null;
        this._widgetDropLocation = null;
        this.redraw();
    }

    public void dropAccept(DropTargetEvent event) {
    }

    protected void endWidgetMove() {
        WidgetDescriptorRegistry registry;
        WidgetDescriptor widgetDescriptor;
        if (this._dropLocation != null) {
            this.doOperationWidgetMove(this._widgetDragging, this._dropLocation);
        }
        WidgetPropertyValue positionValue = this._pageDesign.getEditor().getPropertyValue(this._widgetDragging, "position", IVEConstants.STRING_TYPE);
        ArrayList listValues = null;
        if (positionValue != null) {
            listValues = positionValue.getValues();
        }
        String strType = null;
        if (listValues != null && listValues.size() > 0) {
            strType = (String)listValues.get(0);
        }
        if (strType != null && (strType.equalsIgnoreCase("absolute") || strType.equalsIgnoreCase("fixed") || strType.equalsIgnoreCase("relative")) && (widgetDescriptor = (registry = WidgetDescriptorRegistry.getInstance(this.getDesignPage().getEditor().getProject())).getDescriptor(this._widgetDragging.getTypeID())) != null) {
            String strOldX = null;
            WidgetPropertyDescriptor descriptorX = widgetDescriptor.getPropertyDescriptor("x");
            WidgetPropertyValue valueOldX = this._pageDesign.getEditor().getPropertyValue(this._widgetDragging, "x", IVEConstants.INTEGER_TYPE);
            ArrayList listX = null;
            if (valueOldX != null) {
                listX = valueOldX.getValues();
            }
            if (listX != null && listX.size() > 0) {
                strOldX = (String)listX.get(0);
            }
            String strOldY = null;
            WidgetPropertyDescriptor descriptorY = widgetDescriptor.getPropertyDescriptor("y");
            WidgetPropertyValue valueOldY = this._pageDesign.getEditor().getPropertyValue(this._widgetDragging, "y", IVEConstants.INTEGER_TYPE);
            ArrayList listY = null;
            if (valueOldY != null) {
                listY = valueOldY.getValues();
            }
            if (listY != null && listY.size() > 0) {
                strOldY = (String)listY.get(0);
            }
            int iX = 0;
            int iY = 0;
            if (strType.equalsIgnoreCase("fixed")) {
                Rectangle rectDragging = this._widgetDragging.getBoundsDragging();
                iX = rectDragging.x;
                iY = rectDragging.y;
            } else {
                Point ptWidget = this._widgetDragging.getBoundsOrigin();
                Rectangle rectDragging = this._widgetDragging.getBoundsDragging();
                int iDeltaX = rectDragging.x - ptWidget.x;
                int iDeltaY = rectDragging.y - ptWidget.y;
                int iOldX = 0;
                int iOldY = 0;
                if (strOldX != null) {
                    try {
                        iOldX = Integer.valueOf(strOldX);
                    }
                    catch (NumberFormatException numberFormatException) {}
                }
                if (strOldY != null) {
                    try {
                        iOldY = Integer.valueOf(strOldY);
                    }
                    catch (NumberFormatException numberFormatException) {}
                }
                iX = iOldX + iDeltaX;
                iY = iOldY + iDeltaY;
            }
            ArrayList<PropertyChange> listPropertyChanges = new ArrayList<PropertyChange>();
            WidgetPropertyValue valueNew = new WidgetPropertyValue(Integer.toString(iX));
            PropertyChange change = new PropertyChange();
            change.strPropertyID = descriptorX.getID();
            change.strPropertyType = descriptorX.getType();
            change.valueNew = valueNew;
            change.valueOld = valueOldX;
            change.widget = this._widgetDragging;
            listPropertyChanges.add(change);
            valueNew = new WidgetPropertyValue(Integer.toString(iY));
            change = new PropertyChange();
            change.strPropertyID = descriptorY.getID();
            change.strPropertyType = descriptorY.getType();
            change.valueNew = valueNew;
            change.valueOld = valueOldY;
            change.widget = this._widgetDragging;
            listPropertyChanges.add(change);
            this.doOperationWidgetPropertyValueChanges(listPropertyChanges);
        }
    }

    protected WidgetPart findDropLocationWidget(int iX, int iY) {
        WidgetManager widgetManager = this._pageDesign.getWidgetManager();
        if (widgetManager == null) {
            return null;
        }
        WidgetPart widgetRoot = widgetManager.getWidgetRoot();
        if (widgetManager.getWidgetCount() == 0) {
            return widgetRoot;
        }
        WidgetPart widgetParent = this.findDropLocationWidgetRecursive(widgetRoot, iX, iY);
        return widgetParent != null ? widgetParent : widgetRoot;
    }

    protected WidgetPart findDropLocationWidgetRecursive(WidgetPart widget, int iX, int iY) {
        if (widget == this._widgetDragging) {
            return null;
        }
        WidgetPart widgetOut = null;
        List listChildren = widget.getChildren();
        int i = 0;
        while (i < listChildren.size()) {
            WidgetPart widgetChild = (WidgetPart)listChildren.get(i);
            widgetOut = this.findDropLocationWidgetRecursive(widgetChild, iX, iY);
            if (widgetOut != null) {
                return widgetOut;
            }
            ++i;
        }
        if (widget.getBounds().contains(iX, iY)) {
            return widget;
        }
        return null;
    }

    protected WidgetPart findNextWidgetInList(WidgetPart widget, Collection listWidgets) {
        int iIndex = -1;
        WidgetPart[] widgets = new WidgetPart[listWidgets.size()];
        System.arraycopy(listWidgets.toArray(), 0, widgets, 0, listWidgets.size());
        int i = 0;
        while (i < widgets.length) {
            if (widgets[i] == widget) {
                iIndex = i;
                break;
            }
            ++i;
        }
        if (iIndex == -1) {
            return widgets[0];
        }
        if (iIndex >= 0) {
            if (++iIndex >= widgets.length) {
                iIndex = 0;
            }
            return widgets[iIndex];
        }
        return widget;
    }

    public void focusGained(FocusEvent e) {
        this._pageDesign.overlayFocusChanged(true);
        this.redraw();
    }

    public void focusLost(FocusEvent e) {
        this.resetMouseDownPoint();
        this._pageDesign.overlayFocusChanged(false);
        this.redraw();
    }

    public IAction getAction(String strActionId) {
        if (strActionId.equals(ActionFactory.DELETE.getId())) {
            return this._actionWidgetDelete;
        }
        if (strActionId.equals(ActionFactory.PROPERTIES.getId())) {
            return this._actionWidgetProperties;
        }
        return null;
    }

    public EvDesignPage getDesignPage() {
        return this._pageDesign;
    }

    protected Iterator getWidgets() {
        WidgetManager widgetManager = this._pageDesign.getWidgetManager();
        return widgetManager.getWidgetList().iterator();
    }

    protected List getWidgetsAtPoint(Point point) {
        WidgetManager widgetManager = this._pageDesign.getWidgetManager();
        return widgetManager.getWidgets(point);
    }

    public WidgetPart getWidgetSelected() {
        return this._widgetSelected;
    }

    public void initializeMoveWidgetWithKeyboard() {
        this._widgetMouseDown = this._widgetSelected;
        this._widgetDragging = this._widgetSelected;
        this._ptDragOffset.x = 0;
        this._ptDragOffset.y = 0;
        Rectangle rectDragging = this._widgetSelected.getBounds();
        this._widgetSelected.setBoundsDragging(rectDragging);
        this.mouseMoved(rectDragging.x + 8, rectDragging.y + 8);
    }

    protected void initializeTransparency() {
        int iTransparencyMode = EvPreferences.getInt("org.eclipse.edt.ide.rui.visualeditor.SemiTransparencyMode");
        int iTransparencyAmount = EvPreferences.getInt("org.eclipse.edt.ide.rui.visualeditor.SemiTransparencyAmount");
        this.setTransparency(iTransparencyMode, iTransparencyAmount);
    }

    protected boolean isContainer(WidgetPart widget) {
        if (widget.getTypeName().equalsIgnoreCase("div") || widget.getTypeName().equalsIgnoreCase("span") || widget.getTypeName().equalsIgnoreCase("grouping") || widget.getTypeName().equalsIgnoreCase("treenode") || widget.getTypeName().equalsIgnoreCase("tree")) {
            return true;
        }
        WidgetDescriptor descriptor = WidgetDescriptorRegistry.getInstance(this._pageDesign.getEditor().getProject()).getDescriptor(widget.getTypeID());
        if (descriptor != null) {
            return descriptor.isContainer();
        }
        return false;
    }

    public boolean isDraggable(String strType) {
        return !strType.equalsIgnoreCase("DojoTreeNode");
    }

    public void keyPressed(KeyEvent event) {
        Rectangle rectMove;
        Rectangle rectDragging;
        if (this._widgetDragging == null) {
            return;
        }
        if (event.keyCode == 0x1000002) {
            rectDragging = this._widgetDragging.getBoundsDragging();
            rectMove = new Rectangle(rectDragging.x, rectDragging.y + 8, 8, 8);
            this.mouseMoved(rectMove.x, rectMove.y);
            this.showRectangle(rectMove);
        }
        if (event.keyCode == 0x1000003) {
            rectDragging = this._widgetDragging.getBoundsDragging();
            rectMove = new Rectangle(rectDragging.x - 8, rectDragging.y, 8, 8);
            this.mouseMoved(rectMove.x, rectMove.y);
            this.showRectangle(rectMove);
        }
        if (event.keyCode == 0x1000004) {
            rectDragging = this._widgetDragging.getBoundsDragging();
            rectMove = new Rectangle(rectDragging.x + 8, rectDragging.y, 8, 8);
            this.mouseMoved(rectMove.x, rectMove.y);
            this.showRectangle(rectMove);
        } else if (event.keyCode == 0x1000001) {
            rectDragging = this._widgetDragging.getBoundsDragging();
            rectMove = new Rectangle(rectDragging.x, rectDragging.y - 8, 8, 8);
            this.mouseMoved(rectMove.x, rectMove.y);
            this.showRectangle(rectMove);
        }
    }

    public void keyReleased(KeyEvent event) {
        if (event.keyCode == 0x1000006) {
            ScrolledComposite scroll = (ScrolledComposite)this.getParent().getParent();
            Rectangle rectClient = scroll.getClientArea();
            Point ptOrigin = scroll.getOrigin();
            scroll.setOrigin(ptOrigin.x, ptOrigin.y + rectClient.height / 2);
            this._pageDesign.capture();
        } else if (event.keyCode == 0x1000005) {
            ScrolledComposite scroll = (ScrolledComposite)this.getParent().getParent();
            Rectangle rectClient = scroll.getClientArea();
            Point ptOrigin = scroll.getOrigin();
            scroll.setOrigin(ptOrigin.x, ptOrigin.y - rectClient.height / 2);
            this._pageDesign.capture();
        } else if (event.character == '\u001b' && this._widgetDragging != null) {
            this._widgetDragging.setBoundsDragging(new Rectangle(0, 0, 0, 0));
            this._widgetMouseDown = null;
            this._widgetDragging = null;
            this._ptDropLocations = null;
            this._listDropLocations = null;
            this._dropLocation = null;
            this.redraw();
        }
    }

    public void keyTraversed(TraverseEvent event) {
        if (event.detail == 32) {
            if (this._widgetSelected == null) {
                return;
            }
            if (this._widgetDragging != null) {
                return;
            }
            WidgetPart widgetPrevious = this._pageDesign.getWidgetManager().getWidgetPrevious(this._widgetSelected);
            if (widgetPrevious == this._widgetSelected) {
                return;
            }
            this.selectWidget(widgetPrevious);
            this.showWidget(this._widgetSelected);
            this.redraw();
        } else if (event.detail == 64) {
            if (this._widgetSelected == null) {
                return;
            }
            if (this._widgetDragging != null) {
                return;
            }
            WidgetPart widgetNext = this._pageDesign.getWidgetManager().getWidgetNext(this._widgetSelected);
            if (widgetNext == this._widgetSelected) {
                return;
            }
            this.selectWidget(widgetNext);
            this.showWidget(this._widgetSelected);
            this.redraw();
        } else if (event.detail == 4) {
            if (this._widgetDragging != null) {
                this.endWidgetMove();
            }
        } else if (event.detail == 8) {
            this._pageDesign._toolbar.setFocus();
        } else {
            int cfr_ignored_0 = event.detail;
        }
    }

    public void menuAboutToShow(IMenuManager manager) {
        this.refreshMenu();
        this.setFocus();
        this._actionWidgetDelete.setEnabled(this._widgetSelected != null);
        this._actionWidgetProperties.setEnabled(this._widgetSelected != null);
        boolean bMoveable = false;
        if (this._widgetSelected != null && this.isDraggable(this._widgetSelected.getTypeName())) {
            bMoveable = true;
        }
        this._actionWidgetMove.setEnabled(bMoveable);
        this._widgetNextSelection = null;
    }

    public void mouseDoubleClick(MouseEvent e) {
    }

    public void resetMouseDownPoint() {
        this._mouseDownPoint = null;
    }

    public void mouseDown(MouseEvent event) {
        if (event.button == 1 || event.button == 3) {
            this._mouseDownPoint = new Point(event.x, event.y);
        }
        if (event.button != 1) {
            return;
        }
        this._ptMouseDown.x = event.x;
        this._ptMouseDown.y = event.y;
        if (this._widgetSelected != null) {
            this._widgetMouseDown = null;
            List widgetsUnderMouse = this.getWidgetsAtPoint(new Point(event.x, event.y));
            if (widgetsUnderMouse.contains(this._widgetSelected)) {
                this._widgetMouseDown = this._widgetSelected;
                Point ptWidget = this._widgetSelected.getBoundsOrigin();
                this._ptDragOffset.x = ptWidget.x - event.x;
                this._ptDragOffset.y = ptWidget.y - event.y;
            }
        }
        if (this._widgetMouseDown == null && this._widgetNextSelection != null) {
            this._widgetMouseDown = this._widgetNextSelection;
            Point ptWidget = this._widgetMouseDown.getBoundsOrigin();
            this._ptDragOffset.x = ptWidget.x - event.x;
            this._ptDragOffset.y = ptWidget.y - event.y;
        }
    }

    public void mouseEnter(MouseEvent e) {
    }

    public void mouseExit(MouseEvent e) {
        if (this._widgetNextSelection != null) {
            this._widgetNextSelection.setMouseOver(false);
            this._widgetNextSelection = null;
            this.redraw();
        }
    }

    public void mouseHover(MouseEvent e) {
    }

    public void mouseMove(MouseEvent event) {
        this.mouseMoved(event.x, event.y);
    }

    public void mouseMoved(int iMouseX, int iMouseY) {
        if (this._ptMouseDown.x == iMouseX && this._ptMouseDown.y == iMouseY) {
            return;
        }
        this._ptMouseDown.x = 0;
        this._ptMouseDown.y = 0;
        if (this._widgetMouseDown == null) {
            for (EvDesignOverylayClickableArea area : this._listClickableAreas) {
                if (!area.clickableRect.contains(iMouseX, iMouseY)) continue;
                this.setCursor(this.getDisplay().getSystemCursor(21));
                return;
            }
            this.setCursor(this.getDisplay().getSystemCursor(0));
            this.setupNextSelectionWidget(iMouseX, iMouseY);
            this.redraw();
            return;
        }
        WidgetManager widgetManager = this._pageDesign.getWidgetManager();
        if (widgetManager.getWidgetCount() < 2) {
            return;
        }
        WidgetPart widgetParent = this._widgetMouseDown.getParent();
        if (widgetParent.getTypeName().equals("ROOT") && widgetParent.getChildren().size() == 1) {
            return;
        }
        if (!this._widgetMouseDown.getMoveable()) {
            return;
        }
        if (!this.isDraggable(this._widgetMouseDown.getTypeName())) {
            return;
        }
        this._widgetDragging = this._widgetMouseDown;
        if (this._widgetDragging.getBoundsDragging().isEmpty()) {
            this._widgetDragging.setBoundsDragging(this._widgetDragging.getBounds());
        }
        int iX = iMouseX + this._ptDragOffset.x;
        int iY = iMouseY + this._ptDragOffset.y;
        this._widgetDragging.setBoundsDraggingOrigin(new Point(iX, iY));
        if (this._widgetDragging != this._widgetSelected) {
            this.selectWidget(this._widgetDragging);
        }
        if (this._ptDropLocations == null || this._listDropLocations == null) {
            this.setupDropLocations(iMouseX, iMouseY);
        }
        this.setupNextDropLocation(iMouseX, iMouseY);
        this.redraw();
    }

    public void mouseUp(MouseEvent event) {
        if (event.button != 1) {
            return;
        }
        if (this._widgetDragging == null) {
            for (EvDesignOverylayClickableArea area : this._listClickableAreas) {
                if (!area.clickableRect.contains(event.x, event.y)) continue;
                this.doOperationWidgetOnclick(area);
                this._widgetMouseDown = null;
                return;
            }
            List listWidgets = this.getWidgetsAtPoint(new Point(event.x, event.y));
            if (listWidgets.size() != 0) {
                if (listWidgets.size() == 1) {
                    WidgetPart widget = (WidgetPart)listWidgets.get(0);
                    if (widget != this._widgetSelected) {
                        this.selectWidget(widget);
                    }
                } else if (this._widgetNextSelection != null) {
                    this.selectWidget(this._widgetNextSelection);
                }
            }
        } else {
            this.endWidgetMove();
        }
        if (this._widgetDragging != null) {
            this._widgetDragging.setBoundsDragging(new Rectangle(0, 0, 0, 0));
            this._widgetDragging = null;
        }
        this._widgetMouseDown = null;
        this._ptDropLocations = null;
        this._listDropLocations = null;
        this._widgetDropLocation = null;
        this._dropLocation = null;
        this.setupNextSelectionWidget(event.x, event.y);
        this.redraw();
    }

    public void paintControl(PaintEvent event) {
        if (!this._pageDesign.getEditor().isRuiHandler()) {
            this._painter.paintBlank(event.gc);
            return;
        }
        if (this._pageDesign._bGraphicsTransparencyAvailable) {
            if (this._pageDesign.getBrowser() == null) {
                this._painter.paintBlank(event.gc);
                return;
            }
            this._painter.paintOpaque(event.gc);
            this._painter.setMouseDownPoint(this._mouseDownPoint);
            this._painter.paintWidgets(event.gc);
            this._painter.paintInstructions(event.gc);
            this._painter.paintDropLocations(event.gc);
            this._painter.paintWidgetDragging(event.gc);
            this._painter.paintHierarchy(event.gc);
            return;
        }
        EvDesignCaptureInformation captureInfo = this._pageDesign.getCaptureInformation();
        if (captureInfo.bCaptureRunning) {
            return;
        }
        Rectangle rectBounds = this.getBounds();
        if (this._imageDoubleBuffer != null) {
            Rectangle rectImage = this._imageDoubleBuffer.getBounds();
            if (rectBounds.width != rectImage.width || rectBounds.height != rectImage.height) {
                this._imageDoubleBuffer.dispose();
                this._imageDoubleBuffer = null;
            }
        }
        if (this._imageDoubleBuffer == null) {
            this._imageDoubleBuffer = new Image((Device)this.getDisplay(), rectBounds.width, rectBounds.height);
        }
        GC gc = null;
        try {
            gc = new GC((Drawable)this._imageDoubleBuffer);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            if (this._imageDoubleBuffer != null && !this._imageDoubleBuffer.isDisposed()) {
                this._imageDoubleBuffer.dispose();
            }
            this._imageDoubleBuffer = new Image((Device)this.getDisplay(), rectBounds.width, rectBounds.height);
            gc = new GC((Drawable)this._imageDoubleBuffer);
        }
        gc.fillRectangle(rectBounds);
        gc.setClipping(captureInfo.rectCapture);
        Image imageBrowser = captureInfo.imageBrowser;
        if (imageBrowser != null) {
            Rectangle r = captureInfo.rectCapture;
            try {
                int iWidth = Math.min(imageBrowser.getBounds().width, r.width);
                int iHeight = Math.min(imageBrowser.getBounds().height, r.height);
                gc.drawImage(imageBrowser, r.x, r.y, iWidth, iHeight, r.x, r.y, iWidth, iHeight);
            }
            catch (IllegalArgumentException illegalArgumentException) {}
        }
        this._painter.paintOpaque(gc);
        this._painter.setMouseDownPoint(this._mouseDownPoint);
        this._painter.paintWidgets(gc);
        this._painter.paintInstructions(gc);
        this._painter.paintDropLocations(gc);
        this._painter.paintWidgetDragging(gc);
        this._painter.paintHierarchy(gc);
        event.gc.drawImage(this._imageDoubleBuffer, 0, 0);
        gc.dispose();
    }

    protected void rememberSelectionHierarchy() {
        this._listSelectionHierarchy.clear();
        if (this._widgetSelected == null) {
            return;
        }
        WidgetManager widgetManager = this._pageDesign.getWidgetManager();
        WidgetPart widgetRoot = widgetManager.getWidgetRoot();
        this.rememberSelectionHierarchyRecursive(widgetRoot);
    }

    protected void rememberSelectionHierarchyForOperation(WidgetPart widgetParent, int iIndex) {
        ArrayList<Integer> listHierarchy = new ArrayList<Integer>();
        listHierarchy.add(new Integer(iIndex));
        boolean bFound = this.rememberSelectionHierarchyForOperationRecursive(widgetParent, listHierarchy);
        if (bFound) {
            this._listSelectionHierarchy = listHierarchy;
        }
    }

    protected void rememberSelectionHierarchyForOperationDelete(WidgetPart widget) {
        int iListIndex = this._listSelectionHierarchy.size() - 1;
        if (iListIndex < 0) {
            return;
        }
        WidgetPart widgetParent = widget.getParent();
        int iNumberOfChildren = widgetParent.getChildren().size();
        if (iNumberOfChildren == 1) {
            this._listSelectionHierarchy.remove(iListIndex);
            return;
        }
        int iWidgetIndex = widgetParent.getChildIndex(widget);
        if (iWidgetIndex == iNumberOfChildren - 1) {
            this._listSelectionHierarchy.remove(iListIndex);
            this._listSelectionHierarchy.add(new Integer(iWidgetIndex - 1));
            return;
        }
    }

    protected boolean rememberSelectionHierarchyForOperationRecursive(WidgetPart widget, ArrayList listHierarchy) {
        if (widget == null) {
            return false;
        }
        WidgetPart widgetParent = widget.getParent();
        if (widgetParent == null) {
            return true;
        }
        int iIndex = widgetParent.getChildIndex(widget);
        if (iIndex < 0) {
            return false;
        }
        listHierarchy.add(0, new Integer(iIndex));
        return this.rememberSelectionHierarchyForOperationRecursive(widgetParent, listHierarchy);
    }

    protected boolean rememberSelectionHierarchyRecursive(WidgetPart widget) {
        boolean bFound = false;
        List listChildren = widget.getChildren();
        int i = 0;
        while (i < listChildren.size()) {
            WidgetPart widgetChild = (WidgetPart)listChildren.get(i);
            if (widgetChild.getSelected()) {
                this._listSelectionHierarchy.add(new Integer(i));
                return true;
            }
            bFound = this.rememberSelectionHierarchyRecursive(widgetChild);
            if (bFound) {
                this._listSelectionHierarchy.add(0, new Integer(i));
                return true;
            }
            ++i;
        }
        return false;
    }

    protected void restoreSelectionHierarchy() {
        WidgetManager widgetManager = this._pageDesign.getWidgetManager();
        if (widgetManager.getWidgetCount() == 0) {
            this.selectWidget(null);
            return;
        }
        if (widgetManager.getWidgetCount() == 1 && this._listSelectionHierarchy.size() == 0) {
            this._listSelectionHierarchy.add(new Integer(0));
        }
        if (this._listSelectionHierarchy.size() == 0) {
            return;
        }
        WidgetPart widgetRoot = widgetManager.getWidgetRoot();
        this.restoreSelectionHierarchyRecursive(widgetRoot, 0);
    }

    protected void restoreSelectionHierarchyRecursive(WidgetPart widgetParent, int iHierarchyListIndex) {
        List listChildren = widgetParent.getChildren();
        int iChildIndex = (Integer)this._listSelectionHierarchy.get(iHierarchyListIndex);
        if (iChildIndex >= listChildren.size()) {
            if (iChildIndex - 1 >= 0 && iChildIndex - 1 < listChildren.size()) {
                this.selectWidget((WidgetPart)listChildren.get(iChildIndex - 1));
            } else if (listChildren.size() > 0) {
                this.selectWidget((WidgetPart)listChildren.get(0));
            } else if (widgetParent.getParent() != null) {
                this.selectWidget(widgetParent);
            }
            return;
        }
        WidgetPart widgetChild = (WidgetPart)listChildren.get(iChildIndex);
        if (iHierarchyListIndex == this._listSelectionHierarchy.size() - 1) {
            this.selectWidget(widgetChild);
        } else {
            this.restoreSelectionHierarchyRecursive(widgetChild, iHierarchyListIndex + 1);
        }
    }

    protected void selectWidget(WidgetPart widget) {
        if (widget == this._widgetSelected) {
            if (widget == null) {
                this._pageDesign.widgetSelectedFromDesignCanvas(null);
            }
            return;
        }
        if (widget == null && this._widgetSelected != null) {
            this._widgetSelected.setSelected(false);
            this._widgetSelected = null;
        } else if (widget != null && this._widgetSelected == null) {
            widget.setSelected(true);
            this._widgetSelected = widget;
        } else {
            this._widgetSelected.setSelected(false);
            widget.setSelected(true);
            this._widgetSelected = widget;
        }
        this.rememberSelectionHierarchy();
        this._pageDesign.widgetSelectedFromDesignCanvas(this._widgetSelected);
        this.showWidget(widget);
    }

    public void setTransparency(int iTransparencyMode, int iTransparencyAmount) {
        this._iTransparencyMode = iTransparencyMode;
        this._iTransparencyAmount = iTransparencyAmount;
        this.redraw();
    }

    protected void setupDropLocations(int iMouseX, int iMouseY) {
        WidgetPart widget;
        WidgetManager widgetManager = this._pageDesign.getWidgetManager();
        if (widgetManager == null) {
            return;
        }
        if (widgetManager.getWidgetCount() == 0) {
            this._listDropLocations = new ArrayList();
            ScrolledComposite sc = (ScrolledComposite)this.getParent().getParent();
            WidgetLayout handlerLayout = WidgetLayoutRegistry.getInstance().getWidgetLayout("VE-HANDLER", false);
            if (handlerLayout != null) {
                handlerLayout.initialize(sc, null, this._widgetDragging, widgetManager, WidgetDescriptorRegistry.getInstance(this._pageDesign.getEditor().getProject()), this._pageDesign.getEditor().getEditorProvider());
                handlerLayout.setupDropLocations(this._listDropLocations);
            }
            return;
        }
        if (this._widgetDragging != null) {
            WidgetPropertyValue positionValue = this._pageDesign.getEditor().getPropertyValue(this._widgetDragging, "position", IVEConstants.STRING_TYPE);
            String strType = null;
            ArrayList listValues = null;
            if (positionValue != null) {
                listValues = positionValue.getValues();
            }
            if (listValues != null && listValues.size() > 0) {
                strType = (String)listValues.get(0);
            }
            if (strType != null && (strType.equalsIgnoreCase("absolute") || strType.equalsIgnoreCase("relative") || strType.equalsIgnoreCase("Fixed"))) {
                return;
            }
        }
        if ((widget = this.findDropLocationWidget(iMouseX, iMouseY)) == this._widgetDropLocation && this._listDropLocations != null) {
            return;
        }
        this._widgetDropLocation = widget;
        this._dropLocation = null;
        this._listDropLocations = new ArrayList();
        while (widget != null) {
            this.setupDropLocationsForWidget(widget, this._listDropLocations);
            widget = widget.getParent();
        }
    }

    protected void setupClickableAreas() {
        Iterator iterWidgets = this.getWidgets();
        this._listClickableAreas.clear();
        while (iterWidgets.hasNext()) {
            WidgetPart widget = (WidgetPart)iterWidgets.next();
            String clickableInfo = widget.getExtraInfo("ClickableAreas");
            if (clickableInfo == null || clickableInfo.length() == 0) continue;
            String[] areas = clickableInfo.split(":");
            if (areas == null || areas.length == 0) {
                return;
            }
            try {
                String selectionProperty = areas[0];
                int i = 1;
                while (i < areas.length) {
                    int x = Integer.parseInt(areas[i]);
                    int y = Integer.parseInt(areas[++i]);
                    int w = Integer.parseInt(areas[++i]);
                    int h = Integer.parseInt(areas[++i]);
                    String value = areas[++i];
                    EvDesignOverylayClickableArea ca = new EvDesignOverylayClickableArea();
                    ca.clickableRect = new Rectangle(x, y, w, h);
                    ca.propertyName = selectionProperty;
                    ca.propertyValue = value;
                    ca.widget = widget;
                    this._listClickableAreas.add(ca);
                    ++i;
                }
            }
            catch (Exception exception) {}
        }
    }

    protected void setupDropLocationsForWidget(WidgetPart widget, Collection listDropLocations) {
        if (widget == this._widgetDragging) {
            return;
        }
        WidgetLayout widgetLayout = WidgetLayoutRegistry.getInstance().getWidgetLayout(WidgetLayoutRegistry.getLayoutName(widget), this.isContainer(widget));
        if (widgetLayout != null) {
            WidgetManager widgetManager = this._pageDesign.getWidgetManager();
            ScrolledComposite sc = (ScrolledComposite)this.getParent().getParent();
            widgetLayout.initialize(sc, widget, this._widgetDragging, widgetManager, WidgetDescriptorRegistry.getInstance(this._pageDesign.getEditor().getProject()), this._pageDesign.getEditor().getEditorProvider());
            if (!(widgetLayout instanceof RootWidgetLayout) || !this.getDesignPage().getEditor().getEditorProvider().isRUIWidget()) {
                widgetLayout.setupDropLocations(listDropLocations);
            }
        }
    }

    protected void setupNextDropLocation(int iX, int iY) {
        if (this._listDropLocations == null) {
            return;
        }
        this._dropLocation = null;
        this._ptMouse.x = iX;
        this._ptMouse.y = iY;
        for (EvDesignOverlayDropLocation location : this._listDropLocations) {
            if (!location.rectDrop.contains(iX, iY)) continue;
            this._dropLocation = location;
            break;
        }
        if (this._dropLocation != null) {
            return;
        }
        for (EvDesignOverlayDropLocation location : this._listDropLocations) {
            Rectangle rectProximity = new Rectangle(location.rectDrop.x - 8, location.rectDrop.y - 8, location.rectDrop.width + 16, location.rectDrop.height + 16);
            if (!rectProximity.contains(iX, iY)) continue;
            this._dropLocation = location;
            break;
        }
        if (this._dropLocation != null) {
            return;
        }
    }

    protected void setupNextSelectionWidget(int iX, int iY) {
        List listWidgets = this.getWidgetsAtPoint(new Point(iX, iY));
        WidgetPart widget = null;
        if (listWidgets.size() != 0) {
            widget = this._widgetSelected != null ? this.findNextWidgetInList(this._widgetSelected, listWidgets) : (WidgetPart)listWidgets.get(0);
        }
        if (widget == this._widgetNextSelection) {
            return;
        }
        if (this._widgetNextSelection != null) {
            this._widgetNextSelection.setMouseOver(false);
            this._widgetNextSelection = null;
        }
        if (widget != null) {
            widget.setMouseOver(true);
            this._widgetNextSelection = widget;
        }
    }

    protected void showRectangle(Rectangle rectShow) {
        ScrolledComposite scroll = (ScrolledComposite)this.getParent().getParent();
        Rectangle rectClient = scroll.getClientArea();
        Point ptOrigin = scroll.getOrigin();
        rectClient.x = ptOrigin.x;
        rectClient.y = ptOrigin.y;
        if (rectShow.width < 1) {
            rectShow.width = 1;
        }
        if (rectShow.height < 1) {
            rectShow.height = 1;
        }
        if (!rectClient.intersects(rectShow)) {
            rectClient.x = rectShow.x < rectClient.x ? rectShow.x - 20 : rectShow.x + rectShow.width - rectClient.width + 20;
            rectClient.y = rectShow.y < rectClient.y ? rectShow.y - 20 : rectShow.y + rectShow.height - rectClient.height + 20;
            scroll.setOrigin(rectClient.x, rectClient.y);
        }
    }

    protected void showWidget(WidgetPart widget) {
        if (widget == null) {
            return;
        }
        Rectangle rectWidget = widget.getBounds();
        Rectangle newRectWidget = new Rectangle(0, 0, 0, 0);
        newRectWidget.x = rectWidget.x + 4;
        newRectWidget.y = rectWidget.y + 4;
        newRectWidget.width = rectWidget.width - 8;
        newRectWidget.height = rectWidget.height - 8;
        this.showRectangle(rectWidget);
    }

    public void updateColors() {
        String strColor = EvPreferences.getString("org.eclipse.edt.ide.rui.visualeditor.ColorDropLocationPotential");
        Color color = ColorUtil.getColorFromRGBString(Display.getCurrent(), strColor);
        if (color != null) {
            if (this._colorDropTargetPotential != null && !this._colorDropTargetPotential.isDisposed()) {
                this._colorDropTargetPotential.dispose();
            }
            this._colorDropTargetPotential = color;
        }
        strColor = EvPreferences.getString("org.eclipse.edt.ide.rui.visualeditor.ColorDropLocationSelected");
        color = ColorUtil.getColorFromRGBString(Display.getCurrent(), strColor);
        if (color != null) {
            if (this._colorDropTargetSelected != null && !this._colorDropTargetSelected.isDisposed()) {
                this._colorDropTargetSelected.dispose();
            }
            this._colorDropTargetSelected = color;
        }
        strColor = EvPreferences.getString("org.eclipse.edt.ide.rui.visualeditor.ColorSelection");
        color = ColorUtil.getColorFromRGBString(Display.getCurrent(), strColor);
        if (color == null) {
            return;
        }
        if (this._colorWidgetSelected != null && !this._colorWidgetSelected.isDisposed()) {
            this._colorWidgetSelected.dispose();
        }
        this._colorWidgetSelected = color;
        this._painter.updateColors();
        this.redraw();
    }

    public void widgetDisposed(DisposeEvent e) {
        if (this._colorDropTargetPotential != null && !this._colorDropTargetPotential.isDisposed()) {
            this._colorDropTargetPotential.dispose();
            this._colorDropTargetPotential = null;
        }
        if (this._colorDropTargetSelected != null && !this._colorDropTargetSelected.isDisposed()) {
            this._colorDropTargetSelected.dispose();
            this._colorDropTargetSelected = null;
        }
        if (this._colorWidgetSelected != null && !this._colorWidgetSelected.isDisposed()) {
            this._colorWidgetSelected.dispose();
            this._colorWidgetSelected = null;
        }
        if (this._cursorWait != null && !this._cursorWait.isDisposed()) {
            this._cursorWait.dispose();
            this._cursorWait = null;
        }
        if (this._imageDoubleBuffer != null && !this._imageDoubleBuffer.isDisposed()) {
            this._imageDoubleBuffer.dispose();
            this._imageDoubleBuffer = null;
        }
    }

    public void widgetsChanged() {
        this._widgetDragging = null;
        this._widgetMouseDown = null;
        this._widgetNextSelection = null;
        this._widgetSelected = null;
        this._ptDropLocations = null;
        this._listDropLocations = null;
        this._dropLocation = null;
        boolean bl = this._bShowInstructions = !this.getWidgets().hasNext();
        if (this._bShowInstructions) {
            ScrolledComposite scroll = (ScrolledComposite)this.getParent().getParent();
            scroll.setOrigin(0, 0);
        }
        this.setupClickableAreas();
        this.restoreSelectionHierarchy();
        this.showWidget(this._widgetSelected);
        this._pageDesign.capture();
        Display display = this.getDisplay();
        if (!display.isDisposed()) {
            display.asyncExec(new Runnable(){

                @Override
                public void run() {
                    EvDesignOverlay.this.redraw();
                }
            });
        }
    }
}

