/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.rui.visualeditor.internal.properties;

import java.util.ArrayList;
import org.eclipse.edt.ide.rui.visualeditor.internal.nl.Tooltips;
import org.eclipse.edt.ide.rui.visualeditor.internal.properties.PropertyEditorAbstract;
import org.eclipse.edt.ide.rui.visualeditor.internal.properties.PropertyPage;
import org.eclipse.edt.ide.rui.visualeditor.internal.util.StringArrayDialog;
import org.eclipse.edt.ide.rui.visualeditor.internal.widget.WidgetPropertyDescriptor;
import org.eclipse.edt.ide.rui.visualeditor.internal.widget.WidgetPropertyValue;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class PropertyEditorStringArray
extends PropertyEditorAbstract
implements SelectionListener {
    protected Button _button = null;
    protected WidgetPropertyValue _propertyValueOriginal = null;
    protected Text _textValue = null;
    protected ArrayList _listValues = null;

    public PropertyEditorStringArray(PropertyPage page, WidgetPropertyDescriptor descriptor) {
        super(page, descriptor);
    }

    @Override
    public void createControl(Composite compositeParent) {
        Composite composite = new Composite(compositeParent, 0);
        GridData gridData = new GridData(768);
        composite.setLayoutData((Object)gridData);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        composite.setLayout((Layout)gridLayout);
        this._button = new Button(composite, 8);
        gridData = new GridData();
        gridData.horizontalAlignment = 0x1000008;
        this._button.setLayoutData((Object)gridData);
        this._button.setText("...");
        this._button.setToolTipText(Tooltips.NL_Press_to_modify_the_list);
        this._button.addSelectionListener((SelectionListener)this);
        this._textValue = new Text(composite, 2056);
        gridData = new GridData(768);
        gridData.widthHint = 100;
        this._textValue.setLayoutData((Object)gridData);
    }

    @Override
    public void initialize() {
        this._propertyValueOriginal = this.getPropertyValue(this.getPropertyDescriptor().getID(), this.getPropertyDescriptor().getType());
        if (this._propertyValueOriginal == null || this._propertyValueOriginal.getValues() == null || this._propertyValueOriginal.getValues().size() == 0) {
            this._textValue.setText("");
            return;
        }
        this._listValues = this._propertyValueOriginal.getValues();
        this.updateTextField();
        this._textValue.setEnabled(this._propertyValueOriginal.isEditable());
        this._button.setEnabled(this._propertyValueOriginal.isEditable());
    }

    protected void updateTextField() {
        StringBuffer strb = new StringBuffer("[");
        int i = 0;
        while (i < this._listValues.size()) {
            strb.append('\"');
            strb.append(this._listValues.get(i).toString());
            strb.append('\"');
            if (i < this._listValues.size() - 1) {
                strb.append(", ");
            } else {
                strb.append(']');
            }
            ++i;
        }
        this._textValue.setText(strb.toString());
    }

    protected void valueChanged() {
        WidgetPropertyValue propertyValueNew = new WidgetPropertyValue(this._listValues, true);
        super.propertyValueChanged(this.getPropertyDescriptor(), this._propertyValueOriginal, propertyValueNew);
    }

    public void widgetDefaultSelected(SelectionEvent e) {
    }

    public void widgetSelected(SelectionEvent event) {
        if (event.widget == this._button) {
            if (this._button.isDisposed()) {
                return;
            }
            StringArrayDialog listDialog = new StringArrayDialog(this._button.getShell(), this._listValues, this.getPropertyDescriptor().getLabel());
            int iRC = listDialog.open();
            if (iRC == 1) {
                return;
            }
            this._listValues = listDialog.getValues();
            this.updateTextField();
            this.valueChanged();
            this._button.setFocus();
        }
    }
}

