/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.rui.visualeditor.internal.widget;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.zip.ZipEntry;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.edt.compiler.internal.eglar.EglarFile;
import org.eclipse.edt.compiler.internal.eglar.EglarFileCache;
import org.eclipse.edt.ide.core.internal.lookup.ProjectEnvironment;
import org.eclipse.edt.ide.core.internal.lookup.ProjectEnvironmentManager;
import org.eclipse.edt.ide.rui.document.utils.IVEConstants;
import org.eclipse.edt.ide.rui.visualeditor.internal.widget.DataTemplate;
import org.eclipse.edt.ide.rui.visualeditor.internal.widget.VEPropertyContainer;
import org.eclipse.edt.ide.rui.visualeditor.internal.widget.WidgetDescriptor;
import org.eclipse.edt.ide.rui.visualeditor.internal.widget.WidgetEventDescriptor;
import org.eclipse.edt.ide.rui.visualeditor.internal.widget.WidgetLayoutDescriptor;
import org.eclipse.edt.ide.rui.visualeditor.internal.widget.WidgetPropertyChoice;
import org.eclipse.edt.ide.rui.visualeditor.internal.widget.WidgetPropertyDescriptor;
import org.eclipse.edt.ide.rui.visualeditor.plugin.Activator;
import org.eclipse.edt.mof.egl.Annotation;
import org.eclipse.edt.mof.egl.ArrayType;
import org.eclipse.edt.mof.egl.EnumerationEntry;
import org.eclipse.edt.mof.egl.ExternalType;
import org.eclipse.edt.mof.egl.Field;
import org.eclipse.edt.mof.egl.LogicAndDataPart;
import org.eclipse.edt.mof.egl.PartNotFoundException;
import org.eclipse.edt.mof.egl.StructPart;
import org.eclipse.edt.mof.egl.Type;
import org.eclipse.edt.mof.egl.utils.TypeUtils;
import org.eclipse.edt.mof.impl.Bootstrap;
import org.eclipse.edt.mof.serialization.Environment;
import org.eclipse.edt.mof.serialization.IEnvironment;
import org.eclipse.edt.mof.utils.EList;
import org.eclipse.edt.mof.utils.NameUtile;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.ImageData;

public class WidgetDescriptorFactory {
    private static final String defaultTemplate = "${typeName}{}";
    private static final String VEWIDGET = NameUtile.getAsName((String)"eglx.ui.rui.VEWidget");
    private static final String VEDATATEMPLATE = NameUtile.getAsName((String)"eglx.ui.rui.VEDataTemplate");
    private static final String VEPROPERTY = NameUtile.getAsName((String)"eglx.ui.rui.VEProperty");
    private static final String VEEVENT = NameUtile.getAsName((String)"eglx.ui.rui.VEEvent");
    private static final String WIDGET_CATEGORY = NameUtile.getAsName((String)"category");
    private static final String WIDGET_DISPLAYNAME = NameUtile.getAsName((String)"displayName");
    private static final String WIDGET_SMALLICON = NameUtile.getAsName((String)"smallIcon");
    private static final String WIDGET_LARGEICON = NameUtile.getAsName((String)"largeIcon");
    private static final String WIDGET_TEMPLATE = NameUtile.getAsName((String)"template");
    private static final String WIDGET_DATA_TEMPLATES = NameUtile.getAsName((String)"dataTemplates");
    private static final String WIDGET_DESCRIPTION = NameUtile.getAsName((String)"description");
    private static final String WIDGET_CONTAINER = NameUtile.getAsName((String)"container");
    private static final String WIDGET_LAYOUTDATATYPE = NameUtile.getAsName((String)"layoutDataType");
    private static final String WIDGET_PROVIDER = NameUtile.getAsName((String)"provider");
    private static final String DATA_TEMPLATE_NAME = NameUtile.getAsName((String)"name");
    private static final String DATA_TEMPLATE_DATA_MAPPING = NameUtile.getAsName((String)"dataMapping");
    private static final String DATA_TEMPLATE_PURPOSES = NameUtile.getAsName((String)"purposes");
    private static final String DATA_TEMPLATE_TEMPLATE = NameUtile.getAsName((String)"template");
    private static final String DATA_TEMPLATE_GEN_CONTROLLER = NameUtile.getAsName((String)"genController");
    private static final String DATA_TEMPLATE_FORM_MANAGER_TEMPLATE = NameUtile.getAsName((String)"formManagerTemplate");
    private static final String DATA_TEMPLATE_CHILD_LAYOUT_DATA_TEMPLATE = NameUtile.getAsName((String)"childLayoutDataTemplate");
    private static final String DATA_TEMPLATE_CHILD_NAME_LABEL_TEMPLATE = NameUtile.getAsName((String)"childNameLabelTemplate");
    private static final String DATA_TEMPLATE_CHILD_ERROR_LABEL_TEMPLATE = NameUtile.getAsName((String)"childErrorLabelTemplate");
    private static final String DATA_TEMPLATE_CHILD_CONTROLLER_TEMPLATE = NameUtile.getAsName((String)"childControllerTemplate");
    private static final String DATA_TEMPLATE_CHILD_CONTROLLER_VALID_STATE_SETTER_TEMPLATE = NameUtile.getAsName((String)"childControllerValidStateSetterTemplate");
    private static final String DATA_TEMPLATE_CHILD_CONTROLLER_PUBLISH_MESSAGE_HELPER_TEMPLATE = NameUtile.getAsName((String)"childControllerPublishMessageHelperTemplate");
    private static final String DATA_TEMPLATE_CHILD_FORM_FIELD_TEMPLATE = NameUtile.getAsName((String)"childFormFieldTemplate");
    private static final String DATA_MAPPING_FOR_ARRAY = NameUtile.getAsName((String)"forArray");
    private static final String DATA_MAPPING_GEN_CHILD_WIDGET = NameUtile.getAsName((String)"genChildWidget");
    private static final String DATA_MAPPING_IS_CONTAINER = NameUtile.getAsName((String)"isContainer");
    private static final String DATA_MAPPING_IS_DEFAULT = NameUtile.getAsName((String)"isDefault");
    private static final String DATA_MAPPING_MAPPINGS = NameUtile.getAsName((String)"mappings");
    private static final String PROPERTY_PROPERTYTYPE = NameUtile.getAsName((String)"propertyType");
    private static final String PROPERTY_DISPLAYNAME = NameUtile.getAsName((String)"displayName");
    private static final String PROPERTY_DEFAULT = NameUtile.getAsName((String)"default");
    private static final String PROPERTY_CATEGORY = NameUtile.getAsName((String)"category");
    private static final String PROPERTY_CHOICES = NameUtile.getAsName((String)"choices");
    private static final String PROPERTYCHOICE_DISPLAYNAME = NameUtile.getAsName((String)"displayName");
    private static final String PROPERTYCHOICE_ID = NameUtile.getAsName((String)"id");
    private static final String EVENT_DISPLAYNAME = NameUtile.getAsName((String)"displayName");
    private static final String PROPERTY_FILTER_TYPE = NameUtile.getAsName((String)"propertyFilterType");
    private static final String EVENT_FILTER_TYPE = NameUtile.getAsName((String)"eventFilterType");
    private static final String PROPERTY_FILTER = NameUtile.getAsName((String)"propertyFilter");
    private static final String EVENT_FILTER = NameUtile.getAsName((String)"eventFilter");
    private static final boolean DEBUG = false;
    private IProject project;
    private ProjectEnvironment environment;
    private EglarFile eglarFile;

    public WidgetDescriptorFactory(IProject project) {
        this.project = project;
        this.environment = ProjectEnvironmentManager.getInstance().getProjectEnvironment(project);
        Bootstrap.initialize((IEnvironment)this.environment.getIREnvironment());
        Environment.pushEnv((IEnvironment)this.environment.getIREnvironment());
    }

    public WidgetDescriptor createWidgetDescriptor(String packageName, String partName) {
        WidgetDescriptor widgetDescriptor = null;
        try {
            LogicAndDataPart part = (LogicAndDataPart)this.environment.findPart(packageName, partName);
            if (part != null && (part.getAnnotation(VEWIDGET) != null || part.getAnnotation(VEDATATEMPLATE) != null)) {
                widgetDescriptor = new WidgetDescriptor();
                widgetDescriptor._strProjectName = this.project.getName();
                this.processWidget(part, widgetDescriptor);
                widgetDescriptor.setPackage(packageName);
                this.processWidgetFields(part, widgetDescriptor);
            }
        }
        catch (PartNotFoundException partNotFoundException) {
        }
        catch (Exception e) {
            Activator.getDefault().getLog().log((IStatus)new Status(4, "org.eclipse.edt.ide.rui.visualeditor", "Error processing VEWidget annotation for part partName " + partName, (Throwable)e));
            widgetDescriptor = null;
        }
        return widgetDescriptor;
    }

    public void setEglarFile(File _eglarFile) {
        IResource resource;
        if (_eglarFile == null) {
            this.eglarFile = null;
            return;
        }
        if (!_eglarFile.exists() && (resource = ResourcesPlugin.getWorkspace().getRoot().findMember("/" + _eglarFile.getPath())).exists()) {
            _eglarFile = new File(resource.getLocation().toOSString());
        }
        if (this.eglarFile == null || !_eglarFile.getPath().equals(this.eglarFile.getName())) {
            try {
                this.eglarFile = EglarFileCache.instance.getEglarFile(_eglarFile);
            }
            catch (IOException iOException) {
                this.eglarFile = null;
            }
        }
    }

    private void processWidget(LogicAndDataPart part, WidgetDescriptor widgetDescriptor) {
        Annotation dataTemplateAnnotation;
        Annotation widgetAnnotation = part.getAnnotation(VEWIDGET);
        this.processWidgetID(part, widgetDescriptor);
        if (widgetAnnotation != null) {
            this.processWidgetGroup(widgetAnnotation, widgetDescriptor);
            this.processWidgetDisplayName(widgetAnnotation, widgetDescriptor);
            this.processWidgetSmallIcon(widgetAnnotation, widgetDescriptor);
            this.processWidgetLargeIcon(widgetAnnotation, widgetDescriptor);
            this.processWidgetTemplate(widgetAnnotation, widgetDescriptor);
            this.processWidgetDescription(widgetAnnotation, widgetDescriptor);
            this.processWidgetExcludedFields(widgetAnnotation, widgetDescriptor);
            this.processWidgetContainer(widgetAnnotation, widgetDescriptor);
            this.processWidgetProvider(widgetAnnotation, widgetDescriptor);
        }
        if ((dataTemplateAnnotation = part.getAnnotation(VEDATATEMPLATE)) != null) {
            this.processWidgetDataTemplates(dataTemplateAnnotation, widgetDescriptor);
        }
    }

    private void processWidgetID(LogicAndDataPart part, WidgetDescriptor widgetDescriptor) {
        widgetDescriptor._strType = part.getCaseSensitiveName();
    }

    private void processWidgetGroup(Annotation widgetAnnotation, WidgetDescriptor widgetDescriptor) {
        String group = (String)widgetAnnotation.getValue(WIDGET_CATEGORY);
        if (!this.isEmpty(group)) {
            widgetDescriptor._strGroup = group;
        }
    }

    private void processWidgetDescription(Annotation widgetAnnotation, WidgetDescriptor widgetDescriptor) {
        String description = (String)widgetAnnotation.getValue(WIDGET_DESCRIPTION);
        if (!this.isEmpty(description)) {
            widgetDescriptor._strDescription = description;
        }
    }

    private void processWidgetProvider(Annotation widgetAnnotation, WidgetDescriptor widgetDescriptor) {
        String provider = (String)widgetAnnotation.getValue(WIDGET_PROVIDER);
        if (!this.isEmpty(provider)) {
            widgetDescriptor._strProvider = provider;
        }
    }

    private void processWidgetTemplate(Annotation widgetAnnotation, WidgetDescriptor widgetDescriptor) {
        String template = (String)widgetAnnotation.getValue(WIDGET_TEMPLATE);
        widgetDescriptor._strTemplate = !this.isEmpty(template) ? template : defaultTemplate;
    }

    private void processWidgetDataTemplates(Annotation widgetAnnotation, WidgetDescriptor widgetDescriptor) {
        EList dataTemplateAnnotations = (EList)widgetAnnotation.getValue(WIDGET_DATA_TEMPLATES);
        if (dataTemplateAnnotations != null) {
            widgetDescriptor._DataTemplates = new ArrayList<DataTemplate>();
            int i = 0;
            while (i < dataTemplateAnnotations.size()) {
                Annotation dataMappingAnnotation;
                String childFormFieldTemplate;
                String childControllerPublishMessageHelperTemplate;
                String childControllerValidStateSetterTemplate;
                String childControllerTemplate;
                String childErrorLabelTemplate;
                String childNameLabelTemplate;
                String childLayoutDataTemplate;
                String formManagerTemplate;
                Annotation dataTemplateAnnotation = (Annotation)dataTemplateAnnotations.get(i);
                DataTemplate dataTemplate = new DataTemplate(widgetDescriptor);
                widgetDescriptor._DataTemplates.add(dataTemplate);
                String name = (String)dataTemplateAnnotation.getValue(DATA_TEMPLATE_NAME);
                if (!this.isEmpty(name)) {
                    dataTemplate.setName(name);
                }
                EList oPurposes = (EList)dataTemplateAnnotation.getValue(DATA_TEMPLATE_PURPOSES);
                EnumerationEntry[] purposes = new EnumerationEntry[oPurposes.size()];
                int j = 0;
                while (j < oPurposes.size()) {
                    purposes[j] = (EnumerationEntry)oPurposes.get(j);
                    ++j;
                }
                dataTemplate.setPurposes(purposes);
                Boolean genController = (Boolean)dataTemplateAnnotation.getValue(DATA_TEMPLATE_GEN_CONTROLLER);
                dataTemplate.setGenController(genController);
                String template = (String)dataTemplateAnnotation.getValue(DATA_TEMPLATE_TEMPLATE);
                if (!this.isEmpty(template)) {
                    dataTemplate.setTemplate(template);
                }
                if (!this.isEmpty(formManagerTemplate = (String)dataTemplateAnnotation.getValue(DATA_TEMPLATE_FORM_MANAGER_TEMPLATE))) {
                    dataTemplate.setFormManagerTemplate(formManagerTemplate);
                }
                if (!this.isEmpty(childLayoutDataTemplate = (String)dataTemplateAnnotation.getValue(DATA_TEMPLATE_CHILD_LAYOUT_DATA_TEMPLATE))) {
                    dataTemplate.setChildLayoutDataTemplate(childLayoutDataTemplate);
                }
                if (!this.isEmpty(childNameLabelTemplate = (String)dataTemplateAnnotation.getValue(DATA_TEMPLATE_CHILD_NAME_LABEL_TEMPLATE))) {
                    dataTemplate.setChildNameLabelTemplate(childNameLabelTemplate);
                }
                if (!this.isEmpty(childErrorLabelTemplate = (String)dataTemplateAnnotation.getValue(DATA_TEMPLATE_CHILD_ERROR_LABEL_TEMPLATE))) {
                    dataTemplate.setChildErrorLabelTemplate(childErrorLabelTemplate);
                }
                if (!this.isEmpty(childControllerTemplate = (String)dataTemplateAnnotation.getValue(DATA_TEMPLATE_CHILD_CONTROLLER_TEMPLATE))) {
                    dataTemplate.setChildControllerTemplate(childControllerTemplate);
                }
                if (!this.isEmpty(childControllerValidStateSetterTemplate = (String)dataTemplateAnnotation.getValue(DATA_TEMPLATE_CHILD_CONTROLLER_VALID_STATE_SETTER_TEMPLATE))) {
                    dataTemplate.setChildControllerValidStateSetterTemplate(childControllerValidStateSetterTemplate);
                }
                if (!this.isEmpty(childControllerPublishMessageHelperTemplate = (String)dataTemplateAnnotation.getValue(DATA_TEMPLATE_CHILD_CONTROLLER_PUBLISH_MESSAGE_HELPER_TEMPLATE))) {
                    dataTemplate.setChildControllerPublishMessageHelperTemplate(childControllerPublishMessageHelperTemplate);
                }
                if (!this.isEmpty(childFormFieldTemplate = (String)dataTemplateAnnotation.getValue(DATA_TEMPLATE_CHILD_FORM_FIELD_TEMPLATE))) {
                    dataTemplate.setChildFormFieldTemplate(childFormFieldTemplate);
                }
                if ((dataMappingAnnotation = (Annotation)dataTemplateAnnotation.getValue(DATA_TEMPLATE_DATA_MAPPING)) != null) {
                    Boolean forArray = (Boolean)dataMappingAnnotation.getValue(DATA_MAPPING_FOR_ARRAY);
                    dataTemplate.getDataMapping().setForArray(forArray);
                    Boolean isContainer = (Boolean)dataMappingAnnotation.getValue(DATA_MAPPING_IS_CONTAINER);
                    dataTemplate.getDataMapping().setContainer(isContainer);
                    Boolean isDefault = (Boolean)dataMappingAnnotation.getValue(DATA_MAPPING_IS_DEFAULT);
                    dataTemplate.getDataMapping().setDefault(isDefault);
                    Boolean genChildWidget = (Boolean)dataMappingAnnotation.getValue(DATA_MAPPING_GEN_CHILD_WIDGET);
                    dataTemplate.getDataMapping().setGenChildWidget(genChildWidget);
                    EList oMappings = (EList)dataMappingAnnotation.getValue(DATA_MAPPING_MAPPINGS);
                    EnumerationEntry[] mappings = new EnumerationEntry[oMappings.size()];
                    int j2 = 0;
                    while (j2 < oMappings.size()) {
                        mappings[j2] = (EnumerationEntry)oMappings.get(j2);
                        ++j2;
                    }
                    dataTemplate.getDataMapping().setMappings(mappings);
                }
                ++i;
            }
        }
    }

    private void processWidgetDisplayName(Annotation widgetAnnotation, WidgetDescriptor widgetDescriptor) {
        String widgetValue = (String)widgetAnnotation.getValue(WIDGET_DISPLAYNAME);
        widgetDescriptor._strLabel = !this.isEmpty(widgetValue) ? widgetValue : widgetDescriptor._strType;
    }

    private void processWidgetSmallIcon(Annotation widgetAnnotation, WidgetDescriptor widgetDescriptor) {
        String widgetValue = (String)widgetAnnotation.getValue(WIDGET_SMALLICON);
        if (!this.isEmpty(widgetValue)) {
            try {
                ZipEntry iconEntry;
                IResource member = this.project.findMember(widgetValue);
                if (member != null && member.getType() == 1) {
                    ImageDescriptor iconSmall;
                    URL url = member.getLocationURI().toURL();
                    widgetDescriptor._iconSmall = iconSmall = ImageDescriptor.createFromURL((URL)url);
                } else if (this.eglarFile != null && (iconEntry = this.eglarFile.getEntry(widgetValue)) != null) {
                    ImageDescriptor iconSmall;
                    widgetDescriptor._iconSmall = iconSmall = ImageDescriptor.createFromImageData((ImageData)new ImageData(this.eglarFile.getInputStream(iconEntry)));
                }
            }
            catch (Exception e) {
                Activator.getDefault().getLog().log((IStatus)new Status(4, "org.eclipse.edt.ide.rui.visualeditor", "Error processing small icon", (Throwable)e));
            }
        } else {
            widgetDescriptor._iconSmall = Activator.getImageDescriptor("ctool16/widget.gif");
        }
    }

    private void processWidgetLargeIcon(Annotation widgetAnnotation, WidgetDescriptor widgetDescriptor) {
        String widgetValue = (String)widgetAnnotation.getValue(WIDGET_LARGEICON);
        if (!this.isEmpty(widgetValue)) {
            try {
                ZipEntry iconEntry;
                IResource member = this.project.findMember(widgetValue);
                if (member != null && member.getType() == 1) {
                    ImageDescriptor iconLarge;
                    URL url = member.getLocationURI().toURL();
                    widgetDescriptor._iconLarge = iconLarge = ImageDescriptor.createFromURL((URL)url);
                } else if (this.eglarFile != null && (iconEntry = this.eglarFile.getEntry(widgetValue)) != null) {
                    ImageDescriptor iconLarge;
                    widgetDescriptor._iconLarge = iconLarge = ImageDescriptor.createFromImageData((ImageData)new ImageData(this.eglarFile.getInputStream(iconEntry)));
                }
            }
            catch (Exception e) {
                Activator.getDefault().getLog().log((IStatus)new Status(4, "org.eclipse.edt.ide.rui.visualeditor", "Error processing large icon", (Throwable)e));
            }
        } else {
            widgetDescriptor._iconLarge = Activator.getImageDescriptor("ctool24/widget.gif");
        }
    }

    private void processWidgetExcludedFields(Annotation widgetAnnotation, WidgetDescriptor widgetDescriptor) {
        EnumerationEntry propertyFilterType = (EnumerationEntry)widgetAnnotation.getValue(PROPERTY_FILTER_TYPE);
        EList excludedProperties = (EList)widgetAnnotation.getValue(PROPERTY_FILTER);
        if (propertyFilterType != null) {
            widgetDescriptor._propertyFilterType = propertyFilterType.getValue();
        }
        if (excludedProperties != null && excludedProperties.size() > 0) {
            int i = 0;
            while (i < excludedProperties.size()) {
                widgetDescriptor._propertyFilter.add((String)excludedProperties.get(i));
                ++i;
            }
        }
        EnumerationEntry eventFilterType = (EnumerationEntry)widgetAnnotation.getValue(EVENT_FILTER_TYPE);
        EList excludedEvents = (EList)widgetAnnotation.getValue(EVENT_FILTER);
        if (eventFilterType != null) {
            widgetDescriptor._eventFilterType = eventFilterType.getValue();
        }
        if (excludedEvents != null && excludedEvents.size() > 0) {
            int i = 0;
            while (i < excludedEvents.size()) {
                widgetDescriptor._eventFilter.add((String)excludedEvents.get(i));
                ++i;
            }
        }
    }

    private void processWidgetContainer(Annotation widgetAnnotation, WidgetDescriptor widgetDescriptor) {
        boolean isContainer = false;
        WidgetLayoutDescriptor layoutDescriptor = null;
        Annotation containerAnnotation = (Annotation)widgetAnnotation.getValue(WIDGET_CONTAINER);
        if (containerAnnotation != null) {
            isContainer = true;
            String layoutDataTypeTemplate = (String)containerAnnotation.getValue(WIDGET_LAYOUTDATATYPE);
            if (!this.isEmpty(layoutDataTypeTemplate)) {
                try {
                    String packageName;
                    layoutDescriptor = new WidgetLayoutDescriptor();
                    widgetDescriptor.setChildLayoutDataTemplate(layoutDataTypeTemplate);
                    String layoutDataType = layoutDataTypeTemplate.replaceFirst(".*\\$\\{typeName:\\s*", "");
                    layoutDataType = layoutDataType.replaceFirst("\\s*}.*", "");
                    int lastIndex = layoutDataType.lastIndexOf(46);
                    String typeName = null;
                    if (lastIndex < 0) {
                        typeName = layoutDataType;
                        packageName = "";
                    } else {
                        typeName = layoutDataType.substring(lastIndex + 1);
                        packageName = layoutDataType = layoutDataType.substring(0, lastIndex);
                    }
                    LogicAndDataPart part = (LogicAndDataPart)this.environment.findPart(NameUtile.getAsName((String)packageName), NameUtile.getAsName((String)typeName));
                    List<Field> allFields = this.getAllFields(part);
                    int i = 0;
                    while (i < allFields.size()) {
                        Field field = allFields.get(i);
                        Annotation propertyAnnotation = field.getAnnotation(VEPROPERTY);
                        if (propertyAnnotation != null) {
                            this.processProperty(propertyAnnotation, field, layoutDescriptor);
                        }
                        ++i;
                    }
                }
                catch (Exception e) {
                    Activator.getDefault().getLog().log((IStatus)new Status(4, "org.eclipse.edt.ide.rui.visualeditor", "Error processing Container annotation for Widget", (Throwable)e));
                    e.printStackTrace();
                }
            }
        }
        widgetDescriptor._bContainer = isContainer;
        widgetDescriptor._layoutDescriptor = layoutDescriptor;
    }

    private void processWidgetFields(LogicAndDataPart part, WidgetDescriptor widgetDescriptor) {
        List<Field> allFields = this.getAllFields(part);
        int i = 0;
        while (i < allFields.size()) {
            Field field = allFields.get(i);
            Annotation propertyAnnotation = field.getAnnotation(VEPROPERTY);
            if (propertyAnnotation != null) {
                this.processProperty(propertyAnnotation, field, widgetDescriptor);
            } else {
                Annotation eventAnnotation = field.getAnnotation(VEEVENT);
                if (eventAnnotation != null) {
                    this.processEvent(eventAnnotation, field, widgetDescriptor);
                }
            }
            ++i;
        }
    }

    private List<Field> getAllFields(LogicAndDataPart part) {
        ArrayList<Field> fields = new ArrayList<Field>();
        List<ExternalType> ancestors = this.getAllAncestors(part);
        for (ExternalType ancestor : ancestors) {
            fields.addAll(ancestor.getFields());
        }
        fields.addAll(part.getFields());
        return fields;
    }

    private List<ExternalType> getAllAncestors(LogicAndDataPart part) {
        ArrayList<ExternalType> ancestors = new ArrayList<ExternalType>();
        List parents = part.getSuperTypes();
        for (StructPart parent : parents) {
            if (!(parent instanceof ExternalType)) continue;
            ExternalType externalTypeParent = (ExternalType)parent;
            ancestors.add(externalTypeParent);
            this.getParents(ancestors, externalTypeParent);
        }
        return ancestors;
    }

    private void getParents(List<ExternalType> ancestors, ExternalType part) {
        List parents = part.getSuperTypes();
        for (StructPart parent : parents) {
            if (!(parent instanceof ExternalType)) continue;
            ExternalType externalTypeParent = (ExternalType)parent;
            ancestors.add(externalTypeParent);
            this.getParents(ancestors, externalTypeParent);
        }
    }

    private void processEvent(Annotation annotation, Field field, WidgetDescriptor widgetDescriptor) {
        WidgetEventDescriptor eventDescriptor = new WidgetEventDescriptor();
        this.processEventID(field, eventDescriptor);
        this.processEventDisplayName(annotation, eventDescriptor);
        this.processEventExcluded(field, eventDescriptor, widgetDescriptor);
        widgetDescriptor.addEventDescriptor(eventDescriptor);
    }

    private void processEventID(Field field, WidgetEventDescriptor eventDescriptor) {
        eventDescriptor._strID = field.getCaseSensitiveName();
    }

    private void processEventDisplayName(Annotation propertyAnnotation, WidgetEventDescriptor eventDescriptor) {
        String eventValue = (String)propertyAnnotation.getValue(EVENT_DISPLAYNAME);
        eventDescriptor._strLabel = !this.isEmpty(eventValue) ? eventValue : eventDescriptor._strID;
    }

    private void processEventExcluded(Field field, WidgetEventDescriptor eventDescriptor, WidgetDescriptor widgetDescriptor) {
        if (!this.isPredefined(field, widgetDescriptor)) {
            return;
        }
        switch (widgetDescriptor._eventFilterType) {
            case 3: {
                eventDescriptor._excluded = false;
                break;
            }
            case 1: {
                eventDescriptor._excluded = true;
                break;
            }
            case 2: 
            case 4: {
                boolean includedInFilter = false;
                int i = 0;
                while (i < widgetDescriptor._eventFilter.size()) {
                    String excludedEvent = (String)widgetDescriptor._eventFilter.get(i);
                    if (eventDescriptor.getID().equalsIgnoreCase(excludedEvent)) {
                        includedInFilter = true;
                        break;
                    }
                    ++i;
                }
                eventDescriptor._excluded = widgetDescriptor._eventFilterType == 2 ? !includedInFilter : includedInFilter;
            }
        }
    }

    private void processProperty(Annotation annotation, Field field, VEPropertyContainer widgetDescriptor) {
        WidgetPropertyDescriptor propertyDescriptor = new WidgetPropertyDescriptor();
        this.processPropertyChoices(annotation, propertyDescriptor);
        this.processPropertyCategory(annotation, propertyDescriptor);
        this.processPropertyDefault(annotation, propertyDescriptor);
        this.processPropertyID(field, propertyDescriptor);
        this.processPropertyDisplayName(annotation, field, propertyDescriptor);
        this.processPropertyType(annotation, field, propertyDescriptor);
        if (widgetDescriptor instanceof WidgetDescriptor) {
            this.processPropertyExcluded(field, propertyDescriptor, (WidgetDescriptor)widgetDescriptor);
        }
        widgetDescriptor.addPropertyDescriptor(propertyDescriptor);
    }

    private void processPropertyExcluded(Field field, WidgetPropertyDescriptor propertyDescriptor, WidgetDescriptor widgetDescriptor) {
        if (!this.isPredefined(field, widgetDescriptor)) {
            return;
        }
        switch (widgetDescriptor._propertyFilterType) {
            case 3: {
                propertyDescriptor._excluded = false;
                break;
            }
            case 1: {
                propertyDescriptor._excluded = true;
                break;
            }
            case 2: 
            case 4: {
                boolean includedInFilter = false;
                int i = 0;
                while (i < widgetDescriptor._propertyFilter.size()) {
                    String excludedProperty = widgetDescriptor._propertyFilter.get(i);
                    if (propertyDescriptor.getID().equalsIgnoreCase(excludedProperty)) {
                        includedInFilter = true;
                        break;
                    }
                    ++i;
                }
                propertyDescriptor._excluded = widgetDescriptor._propertyFilterType == 2 ? !includedInFilter : includedInFilter;
            }
        }
    }

    private void processPropertyChoices(Annotation propertyAnnotation, WidgetPropertyDescriptor propertyDescriptor) {
        EList propertyValue = (EList)propertyAnnotation.getValue(PROPERTY_CHOICES);
        if (propertyValue != null) {
            int i = 0;
            while (i < propertyValue.size()) {
                Annotation choice = (Annotation)propertyValue.get(i);
                WidgetPropertyChoice propertyChoice = new WidgetPropertyChoice((String)choice.getValue(PROPERTYCHOICE_ID), (String)choice.getValue(PROPERTYCHOICE_DISPLAYNAME));
                propertyDescriptor.addChoice(propertyChoice);
                ++i;
            }
        }
    }

    private void processPropertyCategory(Annotation propertyAnnotation, WidgetPropertyDescriptor propertyDescriptor) {
        propertyDescriptor._strCategory = (String)propertyAnnotation.getValue(PROPERTY_CATEGORY);
        if (propertyDescriptor._strCategory.equals("")) {
            propertyDescriptor._strCategory = null;
        }
    }

    private void processPropertyID(Field field, WidgetPropertyDescriptor propertyDescriptor) {
        propertyDescriptor._strID = field.getCaseSensitiveName();
    }

    private void processPropertyDefault(Annotation propertyAnnotation, WidgetPropertyDescriptor propertyDescriptor) {
        propertyDescriptor._strDefault = (String)propertyAnnotation.getValue(PROPERTY_DEFAULT);
        if (propertyDescriptor._strDefault.equals("")) {
            propertyDescriptor._strDefault = null;
        }
    }

    private void processPropertyDisplayName(Annotation propertyAnnotation, Field field, WidgetPropertyDescriptor propertyDescriptor) {
        String propertyValue = (String)propertyAnnotation.getValue(PROPERTY_DISPLAYNAME);
        propertyDescriptor._strLabel = !this.isEmpty(propertyValue) ? propertyValue : propertyDescriptor._strID;
    }

    private void processPropertyType(Annotation propertyAnnotation, Field field, WidgetPropertyDescriptor propertyDescriptor) {
        String propertyValue = (String)propertyAnnotation.getValue(PROPERTY_PROPERTYTYPE);
        propertyDescriptor._strType = !this.isEmpty(propertyValue) ? propertyValue : this.convertEGLTypeToPropertyType(field.getType());
    }

    private String convertEGLTypeToPropertyType(Type type) {
        if (TypeUtils.Type_INT.equals(type).booleanValue()) {
            return IVEConstants.INTEGER_TYPE;
        }
        if (TypeUtils.Type_STRING.equals(type).booleanValue()) {
            return IVEConstants.STRING_TYPE;
        }
        if (TypeUtils.Type_BOOLEAN.equals(type).booleanValue()) {
            return IVEConstants.BOOLEAN_TYPE;
        }
        if (TypeUtils.getTypeKind((Type)type) == 33) {
            Type arrayElementType = ((ArrayType)type).getElementType();
            if (TypeUtils.Type_INT.equals(arrayElementType).booleanValue()) {
                return IVEConstants.STRING_ARRAY_TYPE;
            }
            if (TypeUtils.Type_STRING.equals(arrayElementType).booleanValue()) {
                return IVEConstants.STRING_ARRAY_TYPE;
            }
            if (TypeUtils.Type_BOOLEAN.equals(arrayElementType).booleanValue()) {
                return IVEConstants.STRING_ARRAY_TYPE;
            }
            return IVEConstants.STRING_ARRAY_TYPE;
        }
        return IVEConstants.STRING_TYPE;
    }

    private boolean isPredefined(Field field, WidgetDescriptor widgetDescriptor) {
        if (field.isImplicit().booleanValue()) {
            return true;
        }
        LogicAndDataPart part = (LogicAndDataPart)field.getContainer();
        return !(widgetDescriptor.getPackage() == null ? widgetDescriptor.getType() : String.valueOf(widgetDescriptor.getPackage()) + "." + widgetDescriptor.getType()).equalsIgnoreCase(part.getTypeSignature());
    }

    private boolean isEmpty(String s) {
        return s == null || s.length() == 0;
    }
}

