/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.rui.visualeditor.internal.widget.layout;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.edt.ide.rui.visualeditor.internal.editor.EvDesignOverlay;
import org.eclipse.edt.ide.rui.visualeditor.internal.editor.EvWidgetContextMenuProvider;
import org.eclipse.edt.ide.rui.visualeditor.internal.nl.Messages;
import org.eclipse.edt.ide.rui.visualeditor.internal.widget.WidgetPart;
import org.eclipse.edt.ide.rui.visualeditor.internal.widget.layout.GridLayoutWidgetContextMenuAction;
import org.eclipse.edt.ide.rui.visualeditor.plugin.Activator;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.swt.graphics.Point;
import org.eclipse.ui.actions.ActionFactory;

public class GridLayoutWidgetContextMenuProvider
implements EvWidgetContextMenuProvider {
    private static final String GRIDLAYOUT_CONTEXTMENU_PREFIX = "GRIDLAYOUT_CONTEXTMENU_PREFIX";
    private static final String INSERT = "INSERT";
    private static final String INSERT_ROW_ABOVE = "INSERT_ROW_ABOVE";
    private static final String INSERT_ROW_AFTER = "INSERT_ROW_AFTER";
    private static final String INSERT_COLUMN_LEFT = "INSERT_COLUMN_LEFT";
    private static final String INSERT_COLUMN_RIGHT = "INSERT_COLUMN_RIGHT";
    private static final String DELETE = "DELETE";
    private static final String DELETE_ROW = "DELETE_ROW";
    private static final String DELETE_COLUMN = "DELETE_COLUMN";

    @Override
    public void refreshContextMenu(WidgetPart selectedWidget, MenuManager manager, EvDesignOverlay designOverlay, Point mousePosition) {
        String extrainfo;
        while (manager.findMenuUsingPath("GRIDLAYOUT_CONTEXTMENU_PREFIXINSERT") != null) {
            manager.remove("GRIDLAYOUT_CONTEXTMENU_PREFIXINSERT");
        }
        while (manager.findMenuUsingPath("GRIDLAYOUT_CONTEXTMENU_PREFIXDELETE") != null) {
            manager.remove("GRIDLAYOUT_CONTEXTMENU_PREFIXDELETE");
        }
        if (selectedWidget == null || !"org.eclipse.edt.rui.widgets".equals(selectedWidget.getPackageName()) || !"GridLayout".equals(selectedWidget.getTypeName())) {
            return;
        }
        if (manager.getSize() >= 1 && !manager.getItems()[manager.getSize() - 1].isSeparator()) {
            manager.add((IContributionItem)new Separator());
        }
        if ((extrainfo = selectedWidget.getExtraInfo("LayoutInfo")) == null || extrainfo.length() == 0) {
            return;
        }
        String[] tdInfo = extrainfo.split(":");
        int row = -1;
        int column = -1;
        try {
            int index = 0;
            int[] cellInfo = new int[7];
            int i = 0;
            while (i < tdInfo.length) {
                index = i % 7;
                cellInfo[index] = Integer.parseInt(tdInfo[i]);
                if (index == 6 && cellInfo[2] < mousePosition.x && cellInfo[3] < mousePosition.y && cellInfo[4] > mousePosition.x - cellInfo[2] && cellInfo[5] > mousePosition.y - cellInfo[3]) {
                    row = cellInfo[0];
                    column = cellInfo[1];
                    break;
                }
                ++i;
            }
        }
        catch (Exception e) {
            Activator.getDefault().getLog().log((IStatus)new Status(4, "org.eclipse.edt.ide.rui.visualeditor", "GridLayoutWidgetContextMenuProvider: Error parse LayoutInfo", (Throwable)e));
        }
        if (row >= 0 && column >= 0) {
            IContributionItem[] contributionItems = manager.getItems();
            int i = 0;
            while (i < contributionItems.length) {
                IContributionItem contributionItem = contributionItems[i];
                if (contributionItem instanceof ActionContributionItem) {
                    ActionContributionItem actionContributionItem = (ActionContributionItem)contributionItem;
                    String id = actionContributionItem.getId();
                    if (ActionFactory.DELETE.getId().equals(id) || "move".equals(id)) {
                        manager.remove((IContributionItem)actionContributionItem);
                    }
                }
                ++i;
            }
            MenuManager subMenuInsert = new MenuManager(Messages.NL_GLWCMA_Insert, null, "GRIDLAYOUT_CONTEXTMENU_PREFIXINSERT");
            GridLayoutWidgetContextMenuAction _actionMenu = new GridLayoutWidgetContextMenuAction(selectedWidget, designOverlay, row, column, 1);
            _actionMenu.setText(Messages.NL_GLWCMA_Insert_Row_Above);
            _actionMenu.setId("GRIDLAYOUT_CONTEXTMENU_PREFIXINSERT_ROW_ABOVE");
            subMenuInsert.add((IAction)_actionMenu);
            _actionMenu = new GridLayoutWidgetContextMenuAction(selectedWidget, designOverlay, row, column, 2);
            _actionMenu.setText(Messages.NL_GLWCMA_Insert_Row_Below);
            _actionMenu.setId("GRIDLAYOUT_CONTEXTMENU_PREFIXINSERT_ROW_AFTER");
            subMenuInsert.add((IAction)_actionMenu);
            _actionMenu = new GridLayoutWidgetContextMenuAction(selectedWidget, designOverlay, row, column, 3);
            _actionMenu.setText(Messages.NL_GLWCMA_Insert_Column_To_The_Left);
            _actionMenu.setId("GRIDLAYOUT_CONTEXTMENU_PREFIXINSERT_COLUMN_LEFT");
            subMenuInsert.add((IAction)_actionMenu);
            manager.add((IContributionItem)subMenuInsert);
            _actionMenu = new GridLayoutWidgetContextMenuAction(selectedWidget, designOverlay, row, column, 4);
            _actionMenu.setText(Messages.NL_GLWCMA_Insert_Column_To_The_Right);
            _actionMenu.setId("GRIDLAYOUT_CONTEXTMENU_PREFIXINSERT_COLUMN_RIGHT");
            subMenuInsert.add((IAction)_actionMenu);
            manager.add((IContributionItem)subMenuInsert);
            MenuManager subMenuDelete = new MenuManager(Messages.NL_GLWCMA_Delete, null, "GRIDLAYOUT_CONTEXTMENU_PREFIXDELETE");
            _actionMenu = new GridLayoutWidgetContextMenuAction(selectedWidget, designOverlay, row, column, 5);
            _actionMenu.setText(Messages.NL_GLWCMA_Delete_Row);
            _actionMenu.setId("GRIDLAYOUT_CONTEXTMENU_PREFIXDELETE_ROW");
            subMenuDelete.add((IAction)_actionMenu);
            _actionMenu = new GridLayoutWidgetContextMenuAction(selectedWidget, designOverlay, row, column, 6);
            _actionMenu.setText(Messages.NL_GLWCMA_Delete_Column);
            _actionMenu.setId("GRIDLAYOUT_CONTEXTMENU_PREFIXDELETE_COLUMN");
            subMenuDelete.add((IAction)_actionMenu);
            manager.add((IContributionItem)subMenuDelete);
            _actionMenu = null;
        }
    }
}

