/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.rui.visualeditor.internal.wizards.util;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.edt.compiler.core.ast.ClassDataDeclaration;
import org.eclipse.edt.compiler.core.ast.Handler;
import org.eclipse.edt.compiler.core.ast.NestedFunction;
import org.eclipse.edt.compiler.core.ast.SimpleName;
import org.eclipse.edt.ide.rui.visualeditor.internal.util.HandlerFieldsResolver;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.part.FileEditorInput;

public class NameFinder {
    private static NameFinder instance;
    private List<String> fieldNames;
    private List<String> functionNames = new ArrayList<String>();

    private NameFinder() {
    }

    public static NameFinder getInstance() {
        if (instance == null) {
            instance = new NameFinder();
        }
        return instance;
    }

    public void initralize(IEditorInput editorInput) {
        this.fieldNames = new ArrayList<String>();
        FileEditorInput fileEditorInput = (FileEditorInput)editorInput;
        HandlerFieldsResolver handlerFieldsResolver = new HandlerFieldsResolver(fileEditorInput.getFile());
        handlerFieldsResolver.resolve();
        Handler handler = handlerFieldsResolver.getRUIHandler();
        if (handler != null) {
            List contents = handler.getContents();
            int i = 0;
            while (i < contents.size()) {
                Object content = contents.get(i);
                if (content instanceof ClassDataDeclaration) {
                    ClassDataDeclaration classDataDeclaration = (ClassDataDeclaration)content;
                    List names = classDataDeclaration.getNames();
                    int j = 0;
                    while (j < names.size()) {
                        SimpleName simpleName = (SimpleName)names.get(j);
                        this.fieldNames.add(simpleName.getCanonicalName());
                        ++j;
                    }
                }
                if (content instanceof NestedFunction) {
                    NestedFunction function = (NestedFunction)content;
                    this.functionNames.add(function.getName().getCanonicalName());
                }
                ++i;
            }
        }
    }

    public boolean isFieldNameExist(String fieldName) {
        for (String _FieldName : this.fieldNames) {
            if (!_FieldName.equalsIgnoreCase(fieldName)) continue;
            return true;
        }
        return false;
    }

    public boolean isFunctionNameExist(String functionName) {
        for (String _FunctionNames : this.functionNames) {
            if (!_FunctionNames.equalsIgnoreCase(functionName)) continue;
            return true;
        }
        return false;
    }
}

