/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.gen.javascript.templates;

import org.eclipse.edt.gen.javascript.Context;
import org.eclipse.edt.gen.javascript.templates.JavaScriptTemplate;
import org.eclipse.edt.mof.codegen.api.TabbedWriter;
import org.eclipse.edt.mof.egl.IntegerLiteral;
import org.eclipse.edt.mof.egl.Type;
import org.eclipse.edt.mof.egl.utils.TypeUtils;

public class IntegerLiteralTemplate
extends JavaScriptTemplate {
    public void genExpression(IntegerLiteral expr, Context ctx, TabbedWriter out) {
        Type type = expr.getType();
        if (type.equals(TypeUtils.Type_SMALLINT).booleanValue() || type.equals(TypeUtils.Type_INT).booleanValue()) {
            if (expr.isNegated().booleanValue()) {
                out.print('-');
            }
            out.print(IntegerLiteralTemplate.stripLeadingZeroes((String)expr.getUnsignedValue()));
        } else {
            out.print("new ");
            out.print(ctx.getPrimitiveMapping("eglx.lang.EBigint"));
            out.print("(\"");
            if (expr.isNegated().booleanValue()) {
                out.print('-');
            }
            out.print(IntegerLiteralTemplate.stripLeadingZeroes((String)expr.getUnsignedValue()));
            out.print("\")");
        }
    }
}

