/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.mof.codegen.api;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.List;
import org.eclipse.edt.mof.EClass;
import org.eclipse.edt.mof.EClassifier;
import org.eclipse.edt.mof.EObject;
import org.eclipse.edt.mof.MofFactory;
import org.eclipse.edt.mof.codegen.api.TabbedWriter;
import org.eclipse.edt.mof.codegen.api.Template;
import org.eclipse.edt.mof.codegen.api.TemplateContext;
import org.eclipse.edt.mof.codegen.api.TemplateException;
import org.eclipse.edt.mof.serialization.Environment;

public abstract class AbstractTemplate
implements Template {
    public static MofFactory factory = MofFactory.INSTANCE;

    @Override
    public void gen(String genMethod, EObject object, TemplateContext ctx, TabbedWriter out, Object ... args) throws TemplateException {
        this.gen(genMethod, (Object)object, ctx, out, args);
    }

    @Override
    public void gen(String genMethod, Object object, TemplateContext ctx, TabbedWriter out, Object ... args) throws TemplateException {
        Class<?> impls = object.getClass().getInterfaces()[0];
        try {
            Method method = this.getMethod(genMethod, true, impls, ctx.getClass(), out.getClass(), args.getClass());
            if (method != null) {
                method.invoke((Object)this, object, ctx, out, args);
                return;
            }
            if (args.length == 0 && (method = this.getMethod(genMethod, true, impls, ctx.getClass(), out.getClass())) != null) {
                method.invoke((Object)this, object, ctx, out);
                return;
            }
            if (method == null) {
                StringBuilder builder = new StringBuilder();
                builder.append("No such method ");
                builder.append(genMethod);
                builder.append("(");
                builder.append(impls.getName());
                builder.append(", ");
                builder.append(ctx.getClass().getName());
                builder.append(", ");
                builder.append(out.getClass().getName());
                builder.append(") for template ");
                builder.append(this.getClass().getName());
                throw new TemplateException(builder.toString());
            }
        }
        catch (TemplateException te) {
            throw te;
        }
        catch (InvocationTargetException itx) {
            Throwable t = itx.getTargetException();
            if (t instanceof TemplateException) {
                throw (TemplateException)t;
            }
            throw new TemplateException(t);
        }
        catch (Exception e) {
            throw new TemplateException(e);
        }
    }

    @Override
    public List<Object> xlate(String xlateMethod, EObject object, TemplateContext ctx, Object ... args) throws TemplateException {
        Class<?> impls = object.getClass().getInterfaces()[0];
        try {
            Method method = this.getMethod(xlateMethod, true, impls, ctx.getClass(), args.getClass());
            if (method != null) {
                return (List)method.invoke((Object)this, object, ctx, args);
            }
            if (args.length == 0 && (method = this.getMethod(xlateMethod, true, impls, ctx.getClass())) != null) {
                return (List)method.invoke((Object)this, object, ctx);
            }
            if (method == null) {
                StringBuilder builder = new StringBuilder();
                builder.append("No such method ");
                builder.append(xlateMethod);
                builder.append("(");
                builder.append(impls.getName());
                builder.append(", ");
                builder.append(ctx.getClass().getName());
                builder.append(") for template ");
                builder.append(this.getClass().getName());
                throw new TemplateException(builder.toString());
            }
        }
        catch (TemplateException te) {
            throw te;
        }
        catch (InvocationTargetException itx) {
            Throwable t = itx.getTargetException();
            if (t instanceof TemplateException) {
                throw (TemplateException)t;
            }
            throw new TemplateException(t);
        }
        catch (Exception e) {
            throw new TemplateException(e);
        }
        return null;
    }

    @Override
    public void validate(String validateMethod, EObject object, TemplateContext ctx, Object ... args) throws TemplateException {
        Class<?> impls = object.getClass().getInterfaces()[0];
        try {
            Method method = this.getMethod(validateMethod, true, impls, ctx.getClass(), args.getClass());
            if (method != null) {
                method.invoke((Object)this, object, ctx, args);
                return;
            }
            if (args.length == 0 && (method = this.getMethod(validateMethod, true, impls, ctx.getClass())) != null) {
                method.invoke((Object)this, object, ctx);
                return;
            }
            if (method == null) {
                StringBuilder builder = new StringBuilder();
                builder.append("No such method ");
                builder.append(validateMethod);
                builder.append("(");
                builder.append(impls.getName());
                builder.append(", ");
                builder.append(ctx.getClass().getName());
                builder.append(") for template ");
                builder.append(this.getClass().getName());
                throw new TemplateException(builder.toString());
            }
        }
        catch (TemplateException te) {
            throw te;
        }
        catch (InvocationTargetException itx) {
            Throwable t = itx.getTargetException();
            if (t instanceof TemplateException) {
                throw (TemplateException)t;
            }
            throw new TemplateException(t);
        }
        catch (Exception e) {
            throw new TemplateException(e);
        }
    }

    @Override
    public Method getMethod(String methodName, boolean doGet, Class<?> ... classes) {
        Class<?> iface;
        int n;
        int n2;
        Class<?>[] classArray;
        Method method = null;
        if (doGet) {
            method = this.primGetMethod(methodName, classes);
        }
        Class<?> ifaceClass = classes[0];
        if (method == null) {
            classArray = ifaceClass.getInterfaces();
            n2 = classArray.length;
            n = 0;
            while (n < n2) {
                iface = classArray[n];
                classes[0] = iface;
                method = this.primGetMethod(methodName, classes);
                if (method != null) break;
                ++n;
            }
        }
        if (method == null) {
            classArray = ifaceClass.getInterfaces();
            n2 = classArray.length;
            n = 0;
            while (n < n2) {
                iface = classArray[n];
                classes[0] = iface;
                method = this.getMethod(methodName, false, classes);
                if (method != null) break;
                ++n;
            }
        }
        return method;
    }

    private Method primGetMethod(String methodName, Class<?> ... classes) {
        Method method = null;
        try {
            method = this.getClass().getMethod(methodName, classes);
        }
        catch (SecurityException e) {
            throw new RuntimeException(e);
        }
        catch (NoSuchMethodException noSuchMethodException) {}
        return method;
    }

    public EObject newInstance(String typeSignature) throws TemplateException {
        EClass eClass = (EClass)this.getEClassifier(typeSignature);
        return eClass.newInstance();
    }

    public EClassifier getEClassifier(String typeSignature) throws TemplateException {
        try {
            return (EClassifier)Environment.getCurrentEnv().findType(typeSignature);
        }
        catch (Exception e) {
            throw new TemplateException(e);
        }
    }
}

