/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.mof.utils;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import org.eclipse.edt.mof.serialization.SerializationException;

public class TabbedWriter {
    private Writer writer;
    private int indent;
    private boolean doIndent;
    private boolean doAutoIndent;
    private String currentLine;
    private int lineNumber;
    private static final char[] NEWLINE = new char[]{'\n'};

    public TabbedWriter() {
        this.writer = new BufferedWriter(new StringWriter());
        this.doIndent = true;
        this.doAutoIndent = true;
        this.lineNumber = 1;
    }

    public TabbedWriter(Writer writer) {
        this.writer = writer;
        this.doIndent = true;
        this.doAutoIndent = true;
        this.lineNumber = 1;
    }

    public void close() {
        try {
            if (this.doAutoIndent && this.currentLine != null) {
                this.println();
            }
            this.writer.close();
        }
        catch (IOException e) {
            throw new SerializationException(e.getMessage());
        }
    }

    private int computeIndent() {
        int nextIndent = 0;
        char[] chars = this.currentLine.toCharArray();
        int i = 0;
        while (i < chars.length) {
            if (chars[i] == '}') {
                if (nextIndent > 0) {
                    --nextIndent;
                } else {
                    --this.indent;
                }
            } else if (chars[i] == '{') {
                ++nextIndent;
            }
            ++i;
        }
        return this.indent + nextIndent;
    }

    public void flush() throws SerializationException {
        try {
            this.writer.flush();
        }
        catch (IOException e) {
            throw new SerializationException(e.getMessage());
        }
    }

    public boolean getAutoIndent() {
        return this.doAutoIndent;
    }

    public int getLineNumber() {
        return this.lineNumber;
    }

    public Writer getWriter() {
        return this.writer;
    }

    private void indent() {
        try {
            int i = 0;
            while (i < this.indent) {
                this.writer.write(9);
                ++i;
            }
        }
        catch (IOException e) {
            throw new SerializationException(e.getMessage());
        }
    }

    public void popIndent() {
        if (this.indent > 0) {
            --this.indent;
        }
    }

    public void print(String str) {
        this.print(str.toCharArray());
    }

    public void print(char[] chars) {
        if (this.doAutoIndent) {
            this.printAutoIndented(chars);
        } else {
            this.printManuallyIndented(chars);
        }
    }

    public void print(char c) {
        this.print(new char[]{c});
    }

    public void print(int i) {
        this.print(Integer.toString(i).toCharArray());
    }

    public void print(boolean b) {
        if (b) {
            this.print("true");
        } else {
            this.print("false");
        }
    }

    public void println() {
        this.print(NEWLINE);
    }

    public void println(String str) {
        this.print(str);
        this.print(NEWLINE);
    }

    public void println(char[] chars) {
        this.print(chars);
        this.print(NEWLINE);
    }

    public void println(char c) {
        this.print(new char[]{c, '\n'});
    }

    public void println(int i) {
        this.print(Integer.toString(i).toCharArray());
        this.print(NEWLINE);
    }

    public void println(boolean b) {
        this.print(b);
        this.print(NEWLINE);
    }

    private void printAutoIndented(char[] ch) {
        int currentStart = 0;
        int end = ch.length;
        try {
            int i = 0;
            while (i < end) {
                if (ch[i] == '\n') {
                    String saveText = new String(ch, currentStart, i - currentStart);
                    this.currentLine = this.currentLine == null ? saveText : this.currentLine.concat(saveText);
                    this.currentLine = this.currentLine.trim();
                    int nextIndent = this.computeIndent();
                    this.indent();
                    this.writer.write(this.currentLine);
                    this.writer.write(10);
                    this.currentLine = null;
                    currentStart = i + 1;
                    this.indent = nextIndent;
                    ++this.lineNumber;
                }
                ++i;
            }
        }
        catch (IOException e) {
            throw new SerializationException(e.getMessage());
        }
        if (end > currentStart && ch[end - 1] != '\n') {
            String saveText = new String(ch, currentStart, end - currentStart);
            this.currentLine = this.currentLine == null ? saveText : this.currentLine.concat(saveText);
        }
    }

    private void printManuallyIndented(char[] ch) {
        int currentStart = 0;
        int end = ch.length;
        try {
            int i = 0;
            while (i < end) {
                if (ch[i] == '\n') {
                    if (this.doIndent) {
                        this.indent();
                    }
                    this.writer.write(ch, currentStart, i + 1 - currentStart);
                    currentStart = i + 1;
                    this.doIndent = true;
                    ++this.lineNumber;
                }
                ++i;
            }
            if (end > currentStart && ch[end - 1] != '\n') {
                if (this.doIndent) {
                    this.indent();
                }
                this.writer.write(ch, currentStart, end - currentStart);
                this.doIndent = false;
            }
        }
        catch (IOException e) {
            throw new SerializationException(e.getMessage());
        }
    }

    public void pushIndent() {
        ++this.indent;
    }

    public void setAutoIndent(boolean flag) {
        if (this.doAutoIndent && !flag && this.currentLine != null) {
            this.doIndent = true;
            this.printManuallyIndented(this.currentLine.toCharArray());
            this.currentLine = null;
        }
        this.doAutoIndent = flag;
    }

    public String getCurrentLine() {
        return this.currentLine;
    }
}

