/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.core.internal.errors;

import org.eclipse.edt.ide.core.internal.errors.ErrorGrammar;
import org.eclipse.edt.ide.core.internal.errors.ErrorMarkerCollector;
import org.eclipse.edt.ide.core.internal.errors.NonTerminalNode;
import org.eclipse.edt.ide.core.internal.errors.ParseNode;
import org.eclipse.edt.ide.core.internal.errors.ParseStack;
import org.eclipse.edt.ide.core.internal.errors.SyntaxErrorRecoverer;
import org.eclipse.edt.ide.core.internal.errors.TokenStream;

public class EGLPartialParser {
    private ErrorGrammar grammar = ErrorGrammar.getInstance();
    private TokenStream tokenStream;
    private ParseStack stack;

    public ParseStack parse(TokenStream stream) {
        ErrorMarkerCollector.instance.reset();
        this.tokenStream = stream;
        this.stack = new ParseStack();
        while (!this.tokenStream.isDone()) {
            int action = this.grammar.getTerminalAction(this.stack.getCurrentState(), this.tokenStream.lookAhead());
            if (action > 0) {
                this.stack.connect(this.chainNodes(this.tokenStream.getUnprocessedTerminals()));
                this.stack.shift(this.tokenStream.lookAhead());
                this.tokenStream.shift();
                continue;
            }
            if (action < 0) {
                this.stack.connect(this.chainNodes(this.tokenStream.getUnprocessedTerminals()));
                int ruleNumber = -action - 1;
                this.stack.reduce(ruleNumber);
                if (ruleNumber != 0) continue;
                break;
            }
            this.recover();
        }
        return this.stack;
    }

    private void recover() {
        SyntaxErrorRecoverer recoverer = new SyntaxErrorRecoverer(this.stack, this.tokenStream);
        recoverer.recover();
    }

    private ParseNode chainNodes(ParseNode[] nodes) {
        int size = nodes.length;
        while (size > 1) {
            int i = 0;
            while (i < size / 2) {
                nodes[i] = new NonTerminalNode(4, new ParseNode[]{nodes[i * 2], nodes[i * 2 + 1]});
                ++i;
            }
            if (size % 2 > 0) {
                nodes[size / 2] = nodes[size - 1];
                size = size / 2 + 1;
                continue;
            }
            size /= 2;
        }
        return size > 0 ? nodes[0] : null;
    }
}

